<?php

Redux::set_section($opt_name, array(
    'title'      => esc_html__('advance mode', THEME_NAME),
    'id'         => 'redux-settings',
    'desc'       => esc_html__('turn advance mode on to have nice setting page', THEME_NAME),
    'subsection' => false,
    'icon'       => 'isax isax-heart-edit',
    'fields'     => array(
        array(
            'id'          => 'typography-admin',
            'type'        => 'typography',
            'all_styles'  => true,
            'google'      => false,
            'line-height' => false,
            'title'       => esc_html__('wordpress admin Typography', THEME_NAME),
        ),

        array(
            'id'          => 'typography-elementor',
            'type'        => 'typography',
            'all_styles'  => true,
            'google'      => false,
            'line-height' => false,
            'title'       => esc_html__('elementor Typography', THEME_NAME),
        ),

        array(
            'id'          => 'classic-mode',
            'type'        => 'switch',
            'on'          => esc_html__('classic editor', THEME_NAME),
            'off'         => esc_html__('Gutenberg editor', THEME_NAME),
            'title'       => esc_html__('enable classic editor mode', THEME_NAME),
            'subtitle'    => esc_html__('enable classic editor mode.', THEME_NAME),
            'desc'        => '',
            'default'     => true,
        ),

        array(
            'id'          => 'redux-advance-mode',
            'type'        => 'switch',
            'on'          => esc_html__('advance mode', THEME_NAME),
            'off'         => esc_html__('basic mode', THEME_NAME),
            'title'       => esc_html__('setting panel advance mode', THEME_NAME),
            'subtitle'    => esc_html__('enable advance mode for setting panel.', THEME_NAME),
            'desc'        => '',
            'default'     => true,
        ),
        
        array(
            'id'           => 're-main-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('main admin panel color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-header-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel header color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-btn-bg-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel buttom background color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-btn-hover-bg-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel buttom hover background color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-btn-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel buttom color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-btn-hover-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel buttom hover color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-btn-active-bg-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel buttom active background color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-h2-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel h2 color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-enable-switch-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel enable switch color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),

        array(
            'id'           => 're-disable-switch-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('admin panel disable switch color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'     => array( 'redux-advance-mode', '=', true ),
        ),
    ),
));
