<?php

Redux::set_section( $opt_name, array(
    'title'            => esc_html__('Page 404', THEME_NAME),
    'id'               => 'page404_section',
    'desc'             => esc_html__('Page 404 settings', THEME_NAME),
    'subsection'       => false,
    'icon'             => 'isax isax-forbidden-2',
    'fields'           => array(
        array(
            'id'       => 'page-404-template',
            'type'     => 'select',
            'title'    => esc_html__('Page 404 Template', THEME_NAME),
            'subtitle' => esc_html__('Select template for page 404.', THEME_NAME),
            'data'     => 'callback',
            'args'     => 'get_all_other_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s theme other Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-other") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        ),

        array(
            'id'       => 'enable-header-404',
            'type'     => 'switch',
            'title'    => esc_html__('enable header for 404', THEME_NAME),
            'subtitle' => esc_html__('enable header for 404', THEME_NAME),
            'desc'     => '',
            'default'  => true,
        ),

        array(
            'id'       => 'enable-footer-404',
            'type'     => 'switch',
            'title'    => esc_html__('enable footer for 404', THEME_NAME),
            'subtitle' => esc_html__('enable footer for 404.', THEME_NAME),
            'desc'     => '',
            'default'  => true,
        ),

    )
) );