<?php

Redux::set_section( $opt_name, array(
    'title'               => esc_html__('blog', THEME_NAME),
    'id'                  => 'blog_section',
    'desc'                => esc_html__('blog settings', THEME_NAME),
    'subsection'          => false,
    'icon'                => 'isax isax-message-text',
    'fields'              => array(
        array(
            'id'          => 'title-g-1',
            'type'        => 'raw',
            'full_width'  => true,
            'content'     => '<h2>' . esc_html__('archives', THEME_NAME) . '</h2>',
        ),

        array(
            'id'          => 'archive-top-content-template',
            'type'        => 'select',
            'title'       => esc_html__('Top Content', THEME_NAME),
            'subtitle'    => esc_html__('Select template to show in top of the post.', THEME_NAME),
            'data'        => 'callback',
            'args'        => 'get_all_blog_template',
            'desc'        => sprintf(esc_html__('create your template in %1$s blog Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-blog") . '"><b>', '</b></a>'),
            'default'     => '0',
            'select2'     => array( 'allowClear' => false ),
        ),

        array(
            'id'         => 'archive-bottom-content-template',
            'type'       => 'select',
            'title'      => esc_html__('Bottom Content', THEME_NAME),
            'subtitle'   => esc_html__('Select template to show in bottom of the post.', THEME_NAME),
            'data'       => 'callback',
            'args'       => 'get_all_blog_template',
            'desc'       => sprintf(esc_html__('create your template in %1$s blog Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-blog") . '"><b>', '</b></a>'),
            'default'    => '0',
            'select2'    => array( 'allowClear' => false ),
        ),

        array(
            'id'         => 'archive-post',
            'type'       => 'select',
            'title'      => esc_html__('Blog Archive Template', THEME_NAME),
            'subtitle'   => esc_html__('Select template for blog archive.', THEME_NAME),
            'data'       => 'callback',
            'args'       => 'get_all_blog_template',
            'desc'       => sprintf(esc_html__('create your template in %1$s blog Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-blog") . '"><b>', '</b></a>'),
            'default'    => '0',
            'select2'    => array( 'allowClear' => false ),
        ),

        array(
            'id'         => 'single-post',
            'type'       => 'select',
            'title'      => esc_html__('Blog single Template', THEME_NAME),
            'subtitle'   => esc_html__('Select template for blog single.', THEME_NAME),
            'data'       => 'callback',
            'args'       => 'get_all_blog_template',
            'desc'       => sprintf(esc_html__('create your template in %1$s blog Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-blog") . '"><b>', '</b></a>'),
            'default'    => '0',
            'select2'    => array( 'allowClear' => false ),
        ),
        
        array(
            'id'         => 'subtitle-g-2',
            'type'       => 'raw',
            'full_width' => true,
            'content'    => '<h4>' . esc_html__('Search Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'        => 'search-post-types',
            'type'      => 'select',
            'multi'     => true,
            'title'     => esc_html__('Search Post Types', THEME_NAME),
            'subtitle'  => esc_html__('Limit search for custom post types.', THEME_NAME),
            'data'      => 'post_types',
            'desc'      => esc_html__('WordPress search in all post types by default.', THEME_NAME),
            'args'      => array(
                'exclude_from_search'      => false,
            ),
        ),

        array(
            'id'          => 'subtitle-g-3',
            'type'        => 'raw',
            'full_width'  => true,
            'content'     => '<h4>' . esc_html__('Archive Title Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'        => 'blog-archive-title',
            'type'      => 'checkbox',
            'title'     => esc_html__('show Archive Title Section', THEME_NAME),
            'subtitle'  => '',
            'desc'      => '',
            'default'   => '1'
        ),

        array(
            'id'           => 'blog-archive-title-bg',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('Archive Title Section Background', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'  => array( 'blog-archive-title', '=', '1' ),
        ),

        array(
            'id'           => 'blog-archive-title-color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('Archive Title Section Color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '',
            'validate'     => 'color',
            'required'  => array( 'blog-archive-title', '=', '1' ),

        ),

        array(
            'id'        => 'blog-archive-title-radius',
            'type'      => 'checkbox',
            'title'     => esc_html__('Archive Title Section Radius', THEME_NAME),
            'subtitle'  => '',
            'desc'      => '',
            'default'   => '1',
            'required'  => array( 'blog-archive-title', '=', '1' ),
        ),

        array(
            'id'        => 'blog-archive-title-shadow',
            'type'      => 'checkbox',
            'title'     => esc_html__('Archive Title Section Shadow', THEME_NAME),
            'subtitle'  => '',
            'desc'      => '',
            'default'   => '0',
            'required'  => array( 'blog-archive-title', '=', '1' ),

        ),

        array(
            'id'            => 'title-g-4',
            'type'          => 'raw',
            'full_width'    => true,
            'content'       => '<h2>' . esc_html__('singles', THEME_NAME) . '</h2>',
        ),


        array(
            'id'           => 'single-post-top-content-template',
            'type'         => 'select',
            'title'        => esc_html__('Top Content', THEME_NAME),
            'subtitle'     => esc_html__('Select template to show in top of the post.', THEME_NAME),
            'data'         => 'callback',
            'args'         => 'get_all_blog_template',
            'desc'         => sprintf(esc_html__('create your template in %1$s blog Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-blog") . '"><b>', '</b></a>'),
            'default'      => '0',
            'select2'      => array( 'allowClear' => false ),
        ),

        array(
            'id'           => 'single-post-bottom-content-template',
            'type'         => 'select',
            'title'        => esc_html__('Bottom Content', THEME_NAME),
            'subtitle'     => esc_html__('Select template to show in bottom of the post.', THEME_NAME),
            'data'         => 'callback',
            'args'         => 'get_all_blog_template',
            'desc'         => sprintf(esc_html__('create your template in %1$s blog Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-blog") . '"><b>', '</b></a>'),
            'default'      => '0',
            'select2'      => array( 'allowClear' => false ),
        ),

        array(
            'id'           => 'single-category-multi-bg',
            'type'         => 'switch',
            'title'        => esc_html__('Category Multi Background', THEME_NAME),
            'subtitle'     => esc_html__('Edit category and set its color.', THEME_NAME),
            'desc'         => '',
            'default'      => true,
        ),

        array(
            'id'          => 'post-reading-progress-indicator',
            'type'        => 'switch',
            'title'       => esc_html__('Reading Progress Indicator', THEME_NAME),
            'subtitle'    => esc_html__('Show reading progress indicator in post.', THEME_NAME),
            'desc'        => '',
            'default'     => true,
        ),

        array(
            'id'          => 'disable-tags',
            'type'        => 'switch',
            'title'       => esc_html__('Disable Tags', THEME_NAME),
            'subtitle'    => esc_html__('Disable showing tags from the bottom of posts.', THEME_NAME),
            'desc'        => '',
        ),

        array(
            'id'         => 'comments-list-show',
            'type'       => 'switch',
            'title'      => esc_html__('show Comments', THEME_NAME),
            'subtitle'   => esc_html__('show all comments', THEME_NAME),
            'desc'       => '',
            'default'    => true,
        ),

        array(
            'id'        => 'comments-list-collapsable',
            'type'      => 'switch',
            'title'     => esc_html__('Comments List Collapsable', THEME_NAME),
            'subtitle'  => esc_html__('Makes comments list collapsable with show/hide button.', THEME_NAME),
            'desc'      => '',
            'default'   => true,
        ),

        array(
            'id'        => 'single-post-share-box',
            'type'      => 'switch',
            'title'     => esc_html__('Show Share Box', THEME_NAME),
            'subtitle'  => esc_html__('Show share box in the single post.', THEME_NAME),
            'desc'      => '',
            'default'   => true,
        ),

        array(
            'id'           => 'single-post-share-box-options',
            'type'         => 'checkbox',
            'required'     => array( 'single-post-share-box', '=', '1' ),
            'title'        => esc_html__('Share Box Options', THEME_NAME),
            'subtitle'     => esc_html__('Select share box options.', THEME_NAME),
            'desc'         => '',
            'options'      => array(
                'link'     => esc_html__('Link Box', THEME_NAME),
                'telegram' => esc_html__('Telegram', THEME_NAME),
                'whatsapp' => esc_html__('WhatsApp', THEME_NAME),
                'twitter'  => esc_html__('Twitter', THEME_NAME),
                'email'    => esc_html__('Email', THEME_NAME),
                'pinterest'=> esc_html__('Pinterest', THEME_NAME),
                'facebook' => esc_html__('Facebook', THEME_NAME),
                'linkedin' => esc_html__('Linkedin', THEME_NAME),
            ),

            'default' => array(
                'link'      => '1',
                'telegram'  => '1',
                'whatsapp'  => '1',
                'twitter'   => '1',
                'email'     => '1',
                'pinterest' => '0',
                'facebook'  => '0',
                'linkedin'  => '0',
            )
        ),

        array(
            'id'        => 'single-post-author-box',
            'type'      => 'switch',
            'title'     => esc_html__('Show Author Box', THEME_NAME),
            'subtitle'  => esc_html__('Show author box in the single post.', THEME_NAME),
            'desc'      => '',
            'default'   => true,
        ),

        array(
            'id'        => 'single-post-next-prev-posts',
            'type'      => 'switch',
            'title'     => esc_html__('Show Next And Previous Posts', THEME_NAME),
            'subtitle'  => esc_html__('Show next and Previous posts in the single post.', THEME_NAME),
            'desc'      => '',
            'default'   => true,
        ),

        array(
            'id'        => 'single-next-prev-posts-title',
            'type'      => 'text',
            'required'  => array( 'single-post-next-prev-posts', '=', '1' ),
            'title'     => esc_html__('Next And Previous Posts Title', THEME_NAME),
            'subtitle'  => esc_html__('Enter your title for the next and Previous posts.', THEME_NAME),
            'desc'      => esc_html__('Default value: Other Articles', THEME_NAME),
        ),

        array(
            'id'        => 'reading-time-words-per-minute',
            'type'      => 'slider',
            'title'     => esc_html__('Reading Time Words Per Minute', THEME_NAME),
            'subtitle'  => esc_html__('How many words user can read per minute?', THEME_NAME),
            'desc'      => esc_html__('Default value: 255', THEME_NAME),
            'default'   => 255,
            'min'       => 100,
            'step'      => 10,
            'max'       => 500,
        ),
        
        array(
            'id'           => 'title-g-5',
            'type'         => 'raw',
            'full_width'   => true,
            'content'      => '<h2>' . esc_html__('Standard Post Format', THEME_NAME) . '</h2>',
        ),
        
        array(
            'id'       => 'single-format-standard-layout',
            'type'     => 'select',
            'title'    => esc_html__('Standard Post Layout', THEME_NAME),
            'subtitle' => esc_html__('Select default layout for standard posts. You can customize settings for each layout below.', THEME_NAME),
            'desc'     => '',
            'options'  => array(
                '1'    => esc_html__('Layout 1', THEME_NAME),
                '2'    => esc_html__('Layout 2', THEME_NAME),
                '3'    => esc_html__('Layout 3', THEME_NAME),
                '4'    => esc_html__('Layout 4', THEME_NAME),
                '5'    => esc_html__('Layout 5', THEME_NAME),
                '6'    => esc_html__('Layout 6', THEME_NAME),
                '7'    => esc_html__('Layout 7', THEME_NAME),
                '8'    => esc_html__('Layout 8', THEME_NAME),
                '9'    => esc_html__('Layout 9', THEME_NAME),
                '10'   => esc_html__('Layout 10', THEME_NAME),
                '11'   => esc_html__('Layout 11', THEME_NAME),
                '12'   => esc_html__('Layout 12', THEME_NAME),
                '13'   => esc_html__('Layout 13', THEME_NAME),
                '14'   => esc_html__('Layout 14', THEME_NAME),
                '15'   => esc_html__('Layout 15', THEME_NAME),
                '16'   => esc_html__('Layout 16', THEME_NAME),
                '17'   => esc_html__('Layout 17', THEME_NAME),
                '18'   => esc_html__('Layout 18', THEME_NAME),
                '19'   => esc_html__('Layout 19', THEME_NAME),
                '20'   => esc_html__('Layout 20', THEME_NAME),
                '21'   => esc_html__('Layout 21', THEME_NAME),
                '22'   => esc_html__('Layout 22', THEME_NAME),
                '23'   => esc_html__('Layout 23', THEME_NAME),
                '24'   => esc_html__('Layout 24', THEME_NAME),
                '25'   => esc_html__('Layout 25', THEME_NAME),
                '26'   => esc_html__('Layout 26', THEME_NAME),
            ),
            'select2'  => array( 'allowClear' => false ),
            'default'  => '1',
        ),

        array(
            'id'          => 'subtitle-g-6',
            'required'    => array( 'single-format-standard-layout', '=', '1' ),
            'type'        => 'raw',
            'full_width'  => true,
            'content'     => '<h4>' . esc_html__('Layout 1 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'         => 'single-format-standard-layout-1-img-position',
            'type'       => 'select',
            'required'   => array( 'single-format-standard-layout', '=', '1' ),
            'title'      => esc_html__('Image Position', THEME_NAME),
            'subtitle'   => esc_html__('Select image position.', THEME_NAME),
            'desc'       => '',
            'select2'    => array( 'allowClear' => false ),
            'default'    => 'before',
            'options'    => array(
                'before' => esc_html__('Before Meta', THEME_NAME),
                'after'  => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'         => 'single-format-standard-layout-1-meta',
            'type'       => 'checkbox',
            'required'   => array( 'single-format-standard-layout', '=', '1' ),
            'title'      => esc_html__('Post Meta', THEME_NAME),
            'subtitle'   => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'       => '',
            'options'    => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'          => 'single-format-standard-layout-1-full-img',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '1' ),
            'title'       => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '0'
        ),

        array(
            'id'          => 'single-format-standard-layout-1-radius',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '1' ),
            'title'       => esc_html__('Image Radius', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '1'
        ),

        array(
            'id'          => 'single-format-standard-layout-1-shadow',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '1' ),
            'title'       => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '1'
        ),

        array(
            'id'          => 'subtitle-g-7',
            'required'    => array( 'single-format-standard-layout', '=', '2' ),
            'type'        => 'raw',
            'full_width'  => true,
            'content'     => '<h4>' . esc_html__('Layout 2 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'          => 'single-format-standard-layout-2-img-position',
            'type'        => 'select',
            'required'    => array( 'single-format-standard-layout', '=', '2' ),
            'title'       => esc_html__('Image Position', THEME_NAME),
            'subtitle'    => esc_html__('Select image position.', THEME_NAME),
            'desc'        => '',
            'select2'     => array( 'allowClear' => false ),
            'default'     => 'before',
            'options'     => array(
                'before'  => esc_html__('Before Meta', THEME_NAME),
                'after'   => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'       => 'single-format-standard-layout-2-meta',
            'type'     => 'checkbox',
            'required' => array( 'single-format-standard-layout', '=', '2' ),
            'title'    => esc_html__('Post Meta', THEME_NAME),
            'subtitle' => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'     => '',
            'options'  => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'          => 'single-format-standard-layout-2-full-img',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '2' ),
            'title'       => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '0'
        ),

        array(
            'id'          => 'single-format-standard-layout-2-radius',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '2' ),
            'title'       => esc_html__('Image Radius', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '1'
        ),

        array(
            'id'          => 'single-format-standard-layout-2-shadow',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '2' ),
            'title'       => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '1'
        ),

        array(
            'id'          => 'subtitle-g-8',
            'required'    => array( 'single-format-standard-layout', '=', '3' ),
            'type'        => 'raw',
            'full_width'  => true,
            'content'     => '<h4>' . esc_html__('Layout 3 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'          => 'single-format-standard-layout-3-img-position',
            'type'        => 'select',
            'required'    => array( 'single-format-standard-layout', '=', '3' ),
            'title'       => esc_html__('Image Position', THEME_NAME),
            'subtitle'    => esc_html__('Select image position.', THEME_NAME),
            'desc'        => '',
            'select2'     => array( 'allowClear' => false ),
            'default'     => 'before',
            'options'     => array(
                'before'  => esc_html__('Before Meta', THEME_NAME),
                'after'   => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'        => 'single-format-standard-layout-3-meta',
            'type'      => 'checkbox',
            'required'  => array( 'single-format-standard-layout', '=', '3' ),
            'title'     => esc_html__('Post Meta', THEME_NAME),
            'subtitle'  => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'      => '',
            'options'   => array(
                'author-name'    => esc_html__('Author Name', THEME_NAME),
                'author-avatar'  => esc_html__('Author Avatar', THEME_NAME),
                'date'           => esc_html__('Date', THEME_NAME),
                'category'       => esc_html__('Category', THEME_NAME),
                'comments'       => esc_html__('Comments', THEME_NAME),
                'views'          => esc_html__('Views', THEME_NAME),
                'reading-time'   => esc_html__('Reading Time', THEME_NAME),
                'excerpt'        => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'           => 'single-format-standard-layout-3-full-img',
            'type'         => 'checkbox',
            'required'     => array( 'single-format-standard-layout', '=', '3' ),
            'title'        => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '0'
        ),

        array(
            'id'           => 'single-format-standard-layout-3-radius',
            'type'         => 'checkbox',
            'required'     => array( 'single-format-standard-layout', '=', '3' ),
            'title'        => esc_html__('Image Radius', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '1'
        ),

        array(
            'id'          => 'single-format-standard-layout-3-shadow',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '3' ),
            'title'       => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '1'
        ),


        array(
            'id'          => 'subtitle-g-9',
            'required'    => array( 'single-format-standard-layout', '=', '4' ),
            'type'        => 'raw',
            'full_width'  => true,
            'content'     => '<h4>' . esc_html__('Layout 4 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'          => 'single-format-standard-layout-4-img-position',
            'type'        => 'select',
            'required'    => array( 'single-format-standard-layout', '=', '4' ),
            'title'       => esc_html__('Image Position', THEME_NAME),
            'subtitle'    => esc_html__('Select image position.', THEME_NAME),
            'desc'        => '',
            'select2'     => array( 'allowClear' => false ),
            'default'     => 'before',
            'options'     => array(
                'before'  => esc_html__('Before Meta', THEME_NAME),
                'after'   => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'       => 'single-format-standard-layout-4-meta',
            'type'     => 'checkbox',
            'required' => array( 'single-format-standard-layout', '=', '4' ),
            'title'    => esc_html__('Post Meta', THEME_NAME),
            'subtitle' => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'     => '',
            'options'  => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'          => 'single-format-standard-layout-4-full-img',
            'type'        => 'checkbox',
            'required'    => array( 'single-format-standard-layout', '=', '4' ),
            'title'       => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'    => '',
            'desc'        => '',
            'default'     => '0'
        ),

        array(
            'id'         => 'single-format-standard-layout-4-radius',
            'type'       => 'checkbox',
            'required'   => array( 'single-format-standard-layout', '=', '4' ),
            'title'      => esc_html__('Image Radius', THEME_NAME),
            'subtitle'   => '',
            'desc'       => '',
            'default'    => '1'
        ),

        array(
            'id'         => 'single-format-standard-layout-4-shadow',
            'type'       => 'checkbox',
            'required'   => array( 'single-format-standard-layout', '=', '4' ),
            'title'      => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'   => '',
            'desc'       => '',
            'default'    => '1'
        ),


        array(
            'id'         => 'subtitle-g10',
            'required'   => array( 'single-format-standard-layout', '=', '5' ),
            'type'       => 'raw',
            'full_width' => true,
            'content'    => '<h4>' . esc_html__('Layout 5 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'       => 'single-format-standard-layout-5-meta',
            'type'     => 'checkbox',
            'required' => array( 'single-format-standard-layout', '=', '5' ),
            'title'    => esc_html__('Post Meta', THEME_NAME),
            'subtitle' => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'     => '',
            'options'  => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'           => 'single-format-standard-layout-5-full-img',
            'type'         => 'checkbox',
            'required'     => array( 'single-format-standard-layout', '=', '5' ),
            'title'        => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '0'
        ),

        array(
            'id'           => 'single-format-standard-layout-5-radius',
            'type'         => 'checkbox',
            'required'     => array( 'single-format-standard-layout', '=', '5' ),
            'title'        => esc_html__('Image Radius', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '1'
        ),

        array(
            'id'           => 'single-format-standard-layout-5-shadow',
            'type'         => 'checkbox',
            'required'     => array( 'single-format-standard-layout', '=', '5' ),
            'title'        => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '1'
        ),


        array(
            'id'           => 'subtitle-g-11',
            'required'     => array( 'single-format-standard-layout', '=', '6' ),
            'type'         => 'raw',
            'full_width'   => true,
            'content'      => '<h4>' . esc_html__('Layout 6 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'           => 'single-format-standard-layout-6-meta',
            'type'         => 'checkbox',
            'required'     => array( 'single-format-standard-layout', '=', '6' ),
            'title'        => esc_html__('Post Meta', THEME_NAME),
            'subtitle'     => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'         => '',
            'options'      => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-6-bg',
            'type'              => 'color',
            'required'          => array( 'single-format-standard-layout', '=', '6' ),
            'transparent'       => false,
            'title'             => esc_html__('Background Color', THEME_NAME),
            'subtitle'          => esc_html__('Choose background color.', THEME_NAME),
            'desc'              => '',
            'default'           => '',
            'validate'          => 'color',
        ),

        array(
            'id'                => 'single-format-standard-layout-6-full-img',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '6' ),
            'title'             => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '0'
        ),

        array(
            'id'                => 'single-format-standard-layout-6-radius',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '6' ),
            'title'             => esc_html__('Image Radius', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '1'
        ),

        array(
            'id'                => 'single-format-standard-layout-6-shadow',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '6' ),
            'title'             => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '1'
        ),


        array(
            'id'               => 'subtitle-g-12',
            'required'         => array( 'single-format-standard-layout', '=', '7' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 7 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-7-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '7' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-7-bg',
            'type'              => 'color',
            'required'          => array( 'single-format-standard-layout', '=', '7' ),
            'transparent'       => false,
            'title'             => esc_html__('Background Color', THEME_NAME),
            'subtitle'          => esc_html__('Choose background color.', THEME_NAME),
            'desc'              => '',
            'default'           => '',
            'validate'          => 'color',
        ),

        array(
            'id'               => 'single-format-standard-layout-7-full-img',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '7' ),
            'title'            => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '0'
        ),

        array(
            'id'              => 'single-format-standard-layout-7-radius',
            'type'            => 'checkbox',
            'required'        => array( 'single-format-standard-layout', '=', '7' ),
            'title'           => esc_html__('Image Radius', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '1'
        ),

        array(
            'id'              => 'single-format-standard-layout-7-shadow',
            'type'            => 'checkbox',
            'required'        => array( 'single-format-standard-layout', '=', '7' ),
            'title'           => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '1'
        ),


        array(
            'id'              => 'subtitle-g-13',
            'required'        => array( 'single-format-standard-layout', '=', '8' ),
            'type'            => 'raw',
            'full_width'      => true,
            'content'         => '<h4>' . esc_html__('Layout 8 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-8-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '8' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'               => 'single-format-standard-layout-8-full-img',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '8' ),
            'title'            => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '0'
        ),

        array(
            'id'               => 'single-format-standard-layout-8-radius',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '8' ),
            'title'            => esc_html__('Image Radius', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'              => 'single-format-standard-layout-8-shadow',
            'type'            => 'checkbox',
            'required'        => array( 'single-format-standard-layout', '=', '8' ),
            'title'           => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '1'
        ),


        array(
            'id'              => 'subtitle-g-14',
            'required'        => array( 'single-format-standard-layout', '=', '9' ),
            'type'            => 'raw',
            'full_width'      => true,
            'content'         => '<h4>' . esc_html__('Layout 9 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-9-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '9' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-9-full-img',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '9' ),
            'title'             => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '0'
        ),

        array(
            'id'               => 'single-format-standard-layout-9-radius',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '9' ),
            'title'            => esc_html__('Image Radius', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'               => 'single-format-standard-layout-9-shadow',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '9' ),
            'title'            => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),


        array(
            'id'              => 'subtitle-g-15',
            'required'        => array( 'single-format-standard-layout', '=', '10' ),
            'type'            => 'raw',
            'full_width'      => true,
            'content'         => '<h4>' . esc_html__('Layout 10 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'             => 'single-format-standard-layout-10-img-position',
            'type'           => 'select',
            'required'       => array( 'single-format-standard-layout', '=', '10' ),
            'title'          => esc_html__('Image Position', THEME_NAME),
            'subtitle'       => esc_html__('Select image position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'before',
            'options'        => array(
                'before'     => esc_html__('Before Meta', THEME_NAME),
                'after'      => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'                => 'single-format-standard-layout-10-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '10' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'               => 'single-format-standard-layout-10-full-img',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '10' ),
            'title'            => esc_html__('Full Image Size', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '0'
        ),


        array(
            'id'               => 'subtitle-g-16',
            'required'         => array( 'single-format-standard-layout', '=', '11' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 11 (No Image) Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-11-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '11' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),


        array(
            'id'                => 'subtitle-g-17',
            'required'          => array( 'single-format-standard-layout', '=', '12' ),
            'type'              => 'raw',
            'full_width'        => true,
            'content'           => '<h4>' . esc_html__('Layout 12 (No Image) Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-12-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '12' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),


        array(
            'id'               => 'subtitle-g-18',
            'required'         => array( 'single-format-standard-layout', '=', '13' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 13 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-13-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '13' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'               => 'single-format-standard-layout-13-bg',
            'type'             => 'color',
            'required'         => array( 'single-format-standard-layout', '=', '13' ),
            'transparent'      => false,
            'title'            => esc_html__('Background Color', THEME_NAME),
            'subtitle'         => esc_html__('Choose background color.', THEME_NAME),
            'desc'             => '',
            'default'          => '',
            'validate'         => 'color',
        ),

        array(
            'id'               => 'single-format-standard-layout-13-color',
            'type'             => 'color',
            'required'         => array( 'single-format-standard-layout', '=', '13' ),
            'transparent'      => false,
            'title'            => esc_html__('Text Color', THEME_NAME),
            'subtitle'         => esc_html__('Choose text color.', THEME_NAME),
            'desc'             => '',
            'default'          => '',
            'validate'         => 'color',
        ),

        array(
            'id'               => 'single-format-standard-layout-13-radius',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '13' ),
            'title'            => esc_html__('Image Radius', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'               => 'single-format-standard-layout-13-shadow',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '13' ),
            'title'            => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),


        array(
            'id'               => 'subtitle-g-19',
            'required'         => array( 'single-format-standard-layout', '=', '14' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 14 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-14-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '14' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),


        array(
            'id'               => 'subtitle-g-20',
            'required'         => array( 'single-format-standard-layout', '=', '15' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 15 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-15-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '15' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'               => 'single-format-standard-layout-15-bg',
            'type'             => 'color',
            'transparent'      => false,
            'required'         => array( 'single-format-standard-layout', '=', '15' ),
            'title'            => esc_html__('Background Color', THEME_NAME),
            'subtitle'         => esc_html__('Choose background color.', THEME_NAME),
            'desc'             => '',
            'default'          => '',
            'validate'         => 'color',
        ),


        array(
            'id'               => 'subtitle-g-21',
            'required'         => array( 'single-format-standard-layout', '=', '16' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 16 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-16-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '16' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-16-bg',
            'type'              => 'color',
            'transparent'       => false,
            'required'          => array( 'single-format-standard-layout', '=', '16' ),
            'title'             => esc_html__('Background Color', THEME_NAME),
            'subtitle'          => esc_html__('Choose background color.', THEME_NAME),
            'desc'              => '',
            'default'           => '',
            'validate'          => 'color',
        ),

        array(
            'id'               => 'single-format-standard-layout-16-radius',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '16' ),
            'title'            => esc_html__('Image Radius', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'              => 'single-format-standard-layout-16-shadow',
            'type'            => 'checkbox',
            'required'        => array( 'single-format-standard-layout', '=', '16' ),
            'title'           => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '1'
        ),


        array(
            'id'              => 'subtitle-g-22',
            'required'        => array( 'single-format-standard-layout', '=', '17' ),
            'type'            => 'raw',
            'full_width'      => true,
            'content'         => '<h4>' . esc_html__('Layout 17 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-17-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '17' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),


        array(
            'id'                => 'subtitle-g-23',
            'required'          => array( 'single-format-standard-layout', '=', '18' ),
            'type'              => 'raw',
            'full_width'        => true,
            'content'           => '<h4>' . esc_html__('Layout 18 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-18-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '18' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default'           => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-18-radius',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '18' ),
            'title'             => esc_html__('Image Radius', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '1'
        ),

        array(
            'id'               => 'single-format-standard-layout-18-shadow',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '18' ),
            'title'            => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),


        array(
            'id'              => 'subtitle-g-24',
            'required'        => array( 'single-format-standard-layout', '=', '19' ),
            'type'            => 'raw',
            'full_width'      => true,
            'content'         => '<h4>' . esc_html__('Layout 19 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-19-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '19' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-19-radius',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '19' ),
            'title'             => esc_html__('Image Radius', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '1'
        ),

        array(
            'id'                => 'single-format-standard-layout-19-shadow',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '19' ),
            'title'             => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '1'
        ),


        array(
            'id'                => 'subtitle-g-25',
            'required'          => array( 'single-format-standard-layout', '=', '20' ),
            'type'              => 'raw',
            'full_width'        => true,
            'content'           => '<h4>' . esc_html__('Layout 20 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-20-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '20' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-20-title-bg',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '20' ),
            'title'             => esc_html__('Title Background', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '0'
        ),


        array(
            'id'                 => 'subtitle-g-26',
            'required'           => array( 'single-format-standard-layout', '=', '21' ),
            'type'               => 'raw',
            'full_width'         => true,
            'content'            => '<h4>' . esc_html__('Layout 21 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                 => 'single-format-standard-layout-21-meta',
            'type'               => 'checkbox',
            'required'           => array( 'single-format-standard-layout', '=', '21' ),
            'title'              => esc_html__('Post Meta', THEME_NAME),
            'subtitle'           => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'               => '',
            'options'            => array(
                'author-name'    => esc_html__('Author Name', THEME_NAME),
                'author-avatar'  => esc_html__('Author Avatar', THEME_NAME),
                'date'           => esc_html__('Date', THEME_NAME),
                'category'       => esc_html__('Category', THEME_NAME),
                'comments'       => esc_html__('Comments', THEME_NAME),
                'views'          => esc_html__('Views', THEME_NAME),
                'reading-time'   => esc_html__('Reading Time', THEME_NAME),
                'excerpt'        => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'    => '1',
                'author-avatar'  => '1',
                'date'           => '1',
                'category'       => '1',
                'comments'       => '1',
                'views'          => '1',
                'reading-time'   => '1',
                'excerpt'        => '0',
            )
        ),

        array(
            'id'                 => 'single-format-standard-layout-21-radius',
            'type'               => 'checkbox',
            'required'           => array( 'single-format-standard-layout', '=', '21' ),
            'title'              => esc_html__('Image Radius', THEME_NAME),
            'subtitle'           => '',
            'desc'               => '',
            'default'            => '1'
        ),

        array(
            'id'                 => 'single-format-standard-layout-21-shadow',
            'type'               => 'checkbox',
            'required'           => array( 'single-format-standard-layout', '=', '21' ),
            'title'              => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'           => '',
            'desc'               => '',
            'default'            => '1'
        ),

        array(
            'id'                => 'single-format-standard-layout-21-title-bg',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '21' ),
            'title'             => esc_html__('Title Background', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '0'
        ),


        array(
            'id'               => 'subtitle-g-27',
            'required'         => array( 'single-format-standard-layout', '=', '22' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 22 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-22-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '22' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'               => 'single-format-standard-layout-22-radius',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '22' ),
            'title'            => esc_html__('Image Radius', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'               => 'single-format-standard-layout-22-shadow',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '22' ),
            'title'            => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'               => 'single-format-standard-layout-22-title-bg',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '22' ),
            'title'            => esc_html__('Title Background', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '0'
        ),


        array(
            'id'              => 'subtitle-g-28',
            'required'        => array( 'single-format-standard-layout', '=', '23' ),
            'type'            => 'raw',
            'full_width'      => true,
            'content'         => '<h4>' . esc_html__('Layout 23 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-23-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '23' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'                => 'single-format-standard-layout-23-title-bg',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '23' ),
            'title'             => esc_html__('Title Background', THEME_NAME),
            'subtitle'          => '',
            'desc'              => '',
            'default'           => '0'
        ),

        array(
            'id'               => 'single-format-standard-layout-23-title-center',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '23' ),
            'title'            => esc_html__('Title Center', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '0'
        ),


        array(
            'id'               => 'subtitle-g-29',
            'required'         => array( 'single-format-standard-layout', '=', '24' ),
            'type'             => 'raw',
            'full_width'       => true,
            'content'          => '<h4>' . esc_html__('Layout 24 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-24-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '24' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'               => 'single-format-standard-layout-24-radius',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '24' ),
            'title'            => esc_html__('Image Radius', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'               => 'single-format-standard-layout-24-shadow',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '24' ),
            'title'            => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'              => 'single-format-standard-layout-24-title-bg',
            'type'            => 'checkbox',
            'required'        => array( 'single-format-standard-layout', '=', '24' ),
            'title'           => esc_html__('Title Background', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '0'
        ),

        array(
            'id'              => 'single-format-standard-layout-24-title-center',
            'type'            => 'checkbox',
            'required'        => array( 'single-format-standard-layout', '=', '24' ),
            'title'           => esc_html__('Title Center', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '0'
        ),

        array(
            'id'              => 'subtitle-g-30',
            'required'        => array( 'single-format-standard-layout', '=', '25' ),
            'type'            => 'raw',
            'full_width'      => true,
            'content'         => '<h4>' . esc_html__('Layout 25 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-25-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '25' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'               => 'single-format-standard-layout-25-radius',
            'type'             => 'checkbox',
            'required'         => array( 'single-format-standard-layout', '=', '25' ),
            'title'            => esc_html__('Image Radius', THEME_NAME),
            'subtitle'         => '',
            'desc'             => '',
            'default'          => '1'
        ),

        array(
            'id'              => 'single-format-standard-layout-25-shadow',
            'type'            => 'checkbox',
            'required'        => array( 'single-format-standard-layout', '=', '25' ),
            'title'           => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '1'
        ),

        array(
            'id'             => 'single-format-standard-layout-25-title-bg',
            'type'           => 'checkbox',
            'required'       => array( 'single-format-standard-layout', '=', '25' ),
            'title'          => esc_html__('Title Background', THEME_NAME),
            'subtitle'       => '',
            'desc'           => '',
            'default'        => '0'
        ),

        array(
            'id'             => 'single-format-standard-layout-25-title-center',
            'type'           => 'checkbox',
            'required'       => array( 'single-format-standard-layout', '=', '25' ),
            'title'          => esc_html__('Title Center', THEME_NAME),
            'subtitle'       => '',
            'desc'           => '',
            'default'        => '0'
        ),


        array(
            'id'             => 'subtitle-g-31',
            'required'       => array( 'single-format-standard-layout', '=', '26' ),
            'type'           => 'raw',
            'full_width'     => true,
            'content'        => '<h4>' . esc_html__('Layout 26 Settings', THEME_NAME) . '</h4>',
        ),

        array(
            'id'                => 'single-format-standard-layout-26-meta',
            'type'              => 'checkbox',
            'required'          => array( 'single-format-standard-layout', '=', '26' ),
            'title'             => esc_html__('Post Meta', THEME_NAME),
            'subtitle'          => esc_html__('Select post meta for this layout.', THEME_NAME),
            'desc'              => '',
            'options'           => array(
                'author-name'   => esc_html__('Author Name', THEME_NAME),
                'author-avatar' => esc_html__('Author Avatar', THEME_NAME),
                'date'          => esc_html__('Date', THEME_NAME),
                'category'      => esc_html__('Category', THEME_NAME),
                'comments'      => esc_html__('Comments', THEME_NAME),
                'views'         => esc_html__('Views', THEME_NAME),
                'reading-time'  => esc_html__('Reading Time', THEME_NAME),
                'excerpt'       => esc_html__('Excerpt', THEME_NAME),
            ),
            'default' => array(
                'author-name'   => '1',
                'author-avatar' => '1',
                'date'          => '1',
                'category'      => '1',
                'comments'      => '1',
                'views'         => '1',
                'reading-time'  => '1',
                'excerpt'       => '0',
            )
        ),

        array(
            'id'              => 'single-format-standard-layout-26-bg',
            'type'            => 'color',
            'required'        => array( 'single-format-standard-layout', '=', '26' ),
            'transparent'     => false,
            'title'           => esc_html__('Background Color', THEME_NAME),
            'subtitle'        => esc_html__('Choose background color.', THEME_NAME),
            'desc'            => '',
            'default'         => '',
            'validate'        => 'color',
        ),

        array(
            'id'             => 'single-format-standard-layout-26-radius',
            'type'           => 'checkbox',
            'required'       => array( 'single-format-standard-layout', '=', '26' ),
            'title'          => esc_html__('Image Radius', THEME_NAME),
            'subtitle'       => '',
            'desc'           => '',
            'default'        => '1'
        ),

        array(
            'id'             => 'title-g-32',
            'type'           => 'raw',
            'full_width'     => true,
            'content'        => '<h2>' . esc_html__('Gallery Post Format', THEME_NAME) . '</h2>',
        ),

        array(
            'id'             => 'single-format-gallery-position',
            'type'           => 'select',
            'title'          => esc_html__('Gallery Position', THEME_NAME),
            'subtitle'       => esc_html__('Select gallery position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'inside',
            'options'        => array(
                'inside'     => esc_html__('Inside content', THEME_NAME),
                'outside'    => esc_html__('Outside Content', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-gallery-position-to-meta',
            'type'           => 'select',
            'title'          => esc_html__('Gallery Position To Meta', THEME_NAME),
            'subtitle'       => esc_html__('Select gallery position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'before',
            'options'        => array(
                'before'     => esc_html__('Before Meta', THEME_NAME),
                'after'      => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-gallery-radius',
            'type'           => 'checkbox',
            'title'          => esc_html__('Image Radius', THEME_NAME),
            'subtitle'       => '',
            'desc'           => '',
            'default'        => '0'
        ),

        array(
            'id'              => 'single-format-gallery-shadow',
            'type'            => 'checkbox',
            'title'           => esc_html__('Image Shadow', THEME_NAME),
            'subtitle'        => '',
            'desc'            => '',
            'default'         => '0'
        ),

        array(
            'id'             => 'title-g-35',
            'type'           => 'raw',
            'full_width'     => true,
            'content'        => '<h2>' . esc_html__('Video Post Format', THEME_NAME) . '</h2>',
        ),

        array(
            'id'             => 'single-format-video-position',
            'type'           => 'select',
            'title'          => esc_html__('Video Position', THEME_NAME),
            'subtitle'       => esc_html__('Select video position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'inside',
            'options'        => array(
                'inside'     => esc_html__('Inside content', THEME_NAME),
                'outside'    => esc_html__('Outside Content', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-video-position-to-meta',
            'type'           => 'select',
            'title'          => esc_html__('Video Position To Meta', THEME_NAME),
            'subtitle'       => esc_html__('Select video position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'before',
            'options'        => array(
                'before'     => esc_html__('Before Meta', THEME_NAME),
                'after'      => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'title-g-36',
            'type'           => 'raw',
            'full_width'     => true,
            'content'        => '<h2>' . esc_html__('Audio Post Format', THEME_NAME) . '</h2>',
        ),

        array(
            'id'             => 'single-format-audio-position',
            'type'           => 'select',
            'title'          => esc_html__('Audio Position', THEME_NAME),
            'subtitle'       => esc_html__('Select audio position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'inside',
            'options'        => array(
                'inside'     => esc_html__('Inside content', THEME_NAME),
                'outside'    => esc_html__('Outside Content', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-audio-position-to-meta',
            'type'           => 'select',
            'title'          => esc_html__('Audio Position To Meta', THEME_NAME),
            'subtitle'       => esc_html__('Select audio position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'before',
            'options'        => array(
                'before'     => esc_html__('Before Meta', THEME_NAME),
                'after'      => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'title-g-33',
            'type'           => 'raw',
            'full_width'     => true,
            'content'        => '<h2>' . esc_html__('Quote Post Format', THEME_NAME) . '</h2>',
        ),

        array(
            'id'             => 'single-format-quote-position',
            'type'           => 'select',
            'title'          => esc_html__('Quote Position', THEME_NAME),
            'subtitle'       => esc_html__('Select quote position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'inside',
            'options'        => array(
                'inside'     => esc_html__('Inside content', THEME_NAME),
                'outside'    => esc_html__('Outside Content', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-quote-position-to-meta',
            'type'           => 'select',
            'title'          => esc_html__('Quote Position To Meta', THEME_NAME),
            'subtitle'       => esc_html__('Select quote position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'before',
            'options'        => array(
                'before'     => esc_html__('Before Meta', THEME_NAME),
                'after'      => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-quote-style',
            'type'           => 'select',
            'title'          => esc_html__('Quote Style', THEME_NAME),
            'subtitle'       => esc_html__('Select quote style.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => '1',
            'options'        => array(
                '1'          => esc_html__('Style 1', THEME_NAME),
                '2'          => esc_html__('Style 2', THEME_NAME),
                '3'          => esc_html__('Style 3', THEME_NAME),
                '4'          => esc_html__('Style 4', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-quote-radius',
            'type'           => 'checkbox',
            'title'          => esc_html__('Quote Box Radius', THEME_NAME),
            'subtitle'       => '',
            'desc'           => '',
            'default'        => '1'
        ),

        array(
            'id'             => 'single-format-quote-shadow',
            'type'           => 'checkbox',
            'title'          => esc_html__('Quote Box Shadow', THEME_NAME),
            'subtitle'       => '',
            'desc'           => '',
            'default'        => '1'
        ),

        array(
            'id'             => 'single-format-quote-bg',
            'type'           => 'color',
            'transparent'    => false,
            'title'          => esc_html__('Quote Box Background', THEME_NAME),
            'subtitle'       => esc_html__('Choose background color.', THEME_NAME),
            'desc'           => '',
            'default'        => '',
            'validate'       => 'color',
        ),

        array(
            'id'             => 'single-format-quote-color',
            'type'           => 'color',
            'transparent'    => false,
            'title'          => esc_html__('Quote Box Text Color', THEME_NAME),
            'subtitle'       => esc_html__('Choose text color.', THEME_NAME),
            'desc'           => '',
            'default'        => '',
            'validate'       => 'color',
        ),

        array(
            'id'             => 'title-g-34',
            'type'           => 'raw',
            'full_width'     => true,
            'content'        => '<h2>' . esc_html__('Link Post Format', THEME_NAME) . '</h2>',
        ),

        array(
            'id'             => 'single-format-link-position',
            'type'           => 'select',
            'title'          => esc_html__('Link Position', THEME_NAME),
            'subtitle'       => esc_html__('Select link position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'inside',
            'options'        => array(
                'inside'     => esc_html__('Inside content', THEME_NAME),
                'outside'    => esc_html__('Outside Content', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-link-position-to-meta',
            'type'           => 'select',
            'title'          => esc_html__('Link Position To Meta', THEME_NAME),
            'subtitle'       => esc_html__('Select link position.', THEME_NAME),
            'desc'           => '',
            'select2'        => array( 'allowClear' => false ),
            'default'        => 'before',
            'options'        => array(
                'before'     => esc_html__('Before Meta', THEME_NAME),
                'after'      => esc_html__('After Meta', THEME_NAME),
            ),
        ),

        array(
            'id'             => 'single-format-link-radius',
            'type'           => 'checkbox',
            'title'          => esc_html__('Link Box Radius', THEME_NAME),
            'subtitle'       => '',
            'desc'           => '',
            'default'        => '1'
        ),

        array(
            'id'           => 'single-format-link-shadow',
            'type'         => 'checkbox',
            'title'        => esc_html__('Link Box Shadow', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '1'
        ),

        array(
            'id'            => 'single-format-link-bg',
            'type'          => 'color',
            'transparent'   => false,
            'title'         => esc_html__('Link Box Background', THEME_NAME),
            'subtitle'      => esc_html__('Choose background color.', THEME_NAME),
            'desc'          => '',
            'default'       => '',
            'validate'      => 'color',
        ),

        array(
            'id'             => 'single-format-link-color',
            'type'           => 'color',
            'transparent'    => false,
            'title'          => esc_html__('Link Box Text Color', THEME_NAME),
            'subtitle'       => esc_html__('Choose text color.', THEME_NAME),
            'desc'           => '',
            'default'        => '',
            'validate'       => 'color',
        ),
    )
) );
