<?php

$colors = theme_defualt_colors();
$colors_fields = array();

foreach ($colors as $color_key => $color) {
    $color_name = esc_html__(str_replace('-', ' ', $color_key), THEME_NAME);
    $color_title = sprintf('%s (%s)', $color['name'], $color_name);

    $colors_fields[] = array(
        'id'       => $color_key,
        'type'     => 'color',
        'subtitle' => '',
        'desc'     => '',
		'default' => $color['value'],
        'validate' => 'color',
        'title'    => $color_title,
    );
}

$colors_fields[] = array(
    'id'           => 'body-bg',
    'type'         => 'color',
    'transparent'  => false,
    'title'        => esc_html__('Body Background Color', THEME_NAME),
    'subtitle'     => '',
    'desc'         => '',
    'default'      => '',
    'validate'     => 'color'
);

$colors_fields[] = array(
    'id'           => 'link-color-hover',
    'type'         => 'color',
    'transparent'  => false,
    'title'        => esc_html__('Links Hover Color', THEME_NAME),
    'subtitle'     => '',
    'desc'         => '',
    'default'      => '',
    'validate'     => 'color',
);

$colors_fields[] = array(
    'id'           => 'single-progress-bar-color',
    'type'         => 'color',
    'transparent'  => false,
    'title'        => esc_html__('Single Post Progress Bar Color', THEME_NAME),
    'subtitle'     => '',
    'desc'         => '',
    'default'      => '',
    'validate'     => 'color',
);

Redux::set_section( $opt_name, array(
    'title'       =>  esc_html__('Styling', THEME_NAME),
    'id'          => 'styling_section',
    'desc'        =>  esc_html__('Styling settings', THEME_NAME),
    'icon'        => 'isax isax-receipt-edit4',
    'fields'      => $colors_fields,
) );