<?php

$post_type_fields = array();
$post_type_fields[] = array(
    'id'       => 'site-header',
    'type'     => 'select',
    'title'    => esc_html__('Site default Header Template', THEME_NAME),
    'subtitle' => esc_html__('Select default header template for your site.', THEME_NAME),
    'data'     => 'callback',
    'args'     => 'get_all_header_template',
    'desc'     => sprintf(esc_html__('create your template in %1$s header Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-header") . '"><b>', '</b></a>'),
    'default'  => '0',
    'select2'  => array( 'allowClear' => false ),
);

$post_types_theme = theme_post_type();
foreach ($post_types_theme as $post_type) {
    if( $post_type['name']){
        $post_type_fields[] = array(
            'id'          => 'subtitle-header-'. $post_type['name'],
            'type'        => 'raw',
            'full_width'  => true,
            'content'     => '<h4>' . sprintf(esc_html__('%1$s header', THEME_NAME), $post_type['title']) . '</h4>',
        );

        $post_type_fields[] = array(
            'id'       => $post_type['name'] .'-header',
            'type'     => 'select',
            'title'    => sprintf(esc_html__('%s1 header', THEME_NAME), $post_type['title']),
            'data'     => 'callback',
            'args'     => 'get_all_header_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s header Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-header") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        );

        $post_type_fields[] = array(
                'id'       => $post_type['name'] .'-archive-header',
                'type'     => 'select',
                'title'    => sprintf(esc_html__('%1$s archive', THEME_NAME), $post_type['title']),
                'data'     => 'callback',
                'args'     => 'get_all_header_template',
                'desc'     => sprintf(esc_html__('create your template in %1$s header Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-header") . '"><b>', '</b></a>'),
                'default'  => '0',
                'select2'  => array( 'allowClear' => false ),
            );
            
        $post_type_fields[] = array(
            'id'       => $post_type['name'] .'-sticky-header-status',
            'type'     => 'switch',
            'title'    => sprintf(esc_html__('%1$s Sticky Header', THEME_NAME), $post_type['title']),
            'desc'     => '',
            'default'  => false,
        );

        $post_type_fields[] = array(
            'id'       => $post_type['name'] .'-sticky-header',
            'type'     => 'select',
            'required' => array( $post_type['title'] .'-sticky-header-status', '=', '1' ),
            'title'    => sprintf( esc_html__('%1$s Site Sticky Header', THEME_NAME), $post_type['title']),
            'data'     => 'callback',
            'args'     => 'get_all_header_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s header Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-header") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        );
	}
}

$post_types = get_post_types(array('public' => true), 'objects');
$excluded_post_types = array('attachment', 'elementor_library', 'e-landing-page');

// Filter out excluded post types
foreach ($excluded_post_types as $exclude_type) {
    if (isset($post_types[$exclude_type])) {
        unset($post_types[$exclude_type]);
    }
}

foreach ($post_types as $post_type) {

    $post_type_fields[] = array(
        'id'          => 'subtitle-header-'. $post_type->name,
        'type'        => 'raw',
        'full_width'  => true,
        'content'     => '<h4>' . sprintf(esc_html__('%1$s header', THEME_NAME), $post_type->labels->name) . '</h4>',
    );

    if($post_type->name != 'page'){
        $post_type_fields[] = array(
            'id'       => $post_type->name .'-archive-header',
            'type'     => 'select',
            'title'    => sprintf(esc_html__('%1$s archive', THEME_NAME), $post_type->labels->name),
            'data'     => 'callback',
            'args'     => 'get_all_header_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s header Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-header") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        );
    }

    $post_type_fields[] = array(
        'id'       => $post_type->name .'-header',
        'type'     => 'select',
        'title'    => sprintf(esc_html__('%s1 header', THEME_NAME), $post_type->labels->name),
        'data'     => 'callback',
        'args'     => 'get_all_header_template',
        'desc'     => sprintf(esc_html__('create your template in %1$s header Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-header") . '"><b>', '</b></a>'),
        'default'  => '0',
        'select2'  => array( 'allowClear' => false ),
    );

        
    $post_type_fields[] = array(
        'id'       => $post_type->name .'-sticky-header-status',
        'type'     => 'switch',
        'title'    => sprintf(esc_html__('%1$s Sticky Header', THEME_NAME), $post_type->labels->name),
        'desc'     => '',
        'default'  => false,
    );

    $post_type_fields[] = array(
        'id'       => $post_type->name .'-sticky-header',
        'type'     => 'select',
        'required' => array( $post_type->name .'-sticky-header-status', '=', '1' ),
        'title'    => sprintf( esc_html__('%1$s Site Sticky Header', THEME_NAME), $post_type->labels->name),
        'data'     => 'callback',
        'args'     => 'get_all_header_template',
        'desc'     => sprintf(esc_html__('create your template in %1$s header Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-header") . '"><b>', '</b></a>'),
        'default'  => '0',
        'select2'  => array( 'allowClear' => false ),
    );
}

Redux::set_section( $opt_name, array(
    'title'        =>  esc_html__('Header', THEME_NAME),
    'id'           => 'header_section',
    'desc'         =>  esc_html__('General settings for header', THEME_NAME),
    'icon'         => 'isax isax-sidebar-top',
    'fields'       => $post_type_fields,
) );