<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$custom_css = '';
$colors = theme_colors();
foreach ( $colors as $color_key => $color_value ) {
	if ( option_value( $color_key ) ) {
		$custom_css .= "body .editor-styles-wrapper { --$color_key: " . option_value( $color_key ) . ";}";
	}
}
$tags = theme_title_tag();

foreach ( $tags as $tag => $tag_name ) {
	if ( option_value( "typography-$tag", 'font-family' ) ) {
		$uploads_dir = wp_upload_dir();
		$font_folder = $uploads_dir['basedir'] . '/redux/custom-fonts/custom/' . option_value( "typography-$tag", 'font-family' );
		$font_files = glob( $font_folder . '/*.{ttf,woff,otf}', GLOB_BRACE );

		if ( ! empty( $font_files ) ) {
			$custom_css .= "@font-face {\n";
			$custom_css .= "font-family: '" . $font_name . "';\n";
			$custom_css .= "src: ";

			$sources = [];
			foreach ( $font_files as $font_file ) {
				$file_ext = pathinfo( $font_file, PATHINFO_EXTENSION );
				$format = '';

				switch ( $file_ext ) {
					case 'ttf':
						$format = 'truetype';
						break;
					case 'woff':
						$format = 'woff';
						break;
					case 'woff2':
						$format = 'woff2';
						break;
					case 'otf':
						$format = 'opentype';
						break;
				}

				$font_relative_path = str_replace( ABSPATH, '/', $font_file );
				$font_url = home_url( $font_relative_path );
				$sources[] = "url('{$font_url}') format('{$format}')";
			}

			$custom_css .= implode( ",\n", $sources );
			$custom_css .= ";\n";
			$custom_css .= "}\n";
		}

		$custom_css .= "$tag {";
		$custom_css .= "font-family: " . option_value( "typography-$tag", 'font-family' ) . ";";

		if ( option_value( "typography-$tag", 'font-weight' ) ) {
			$custom_css .= "font-weight: " . option_value( "typography-$tag", 'font-weight' ) . ";";
		}
		if ( option_value( "typography-$tag", 'font-style' ) ) {
			$custom_css .= "font-style: " . option_value( "typography-$tag", 'font-style' ) . ";";
		}
		if ( option_value( "typography-$tag", 'color' ) ) {
			$custom_css .= "color: " . option_value( "typography-$tag", 'color' ) . ";";
		}

		$custom_css .= "}\n";
	}
}