<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;
$attachment_ids = $product->get_gallery_image_ids();
$has_post_thumbnail = has_post_thumbnail();

    echo '<div class="swiper gallery-slider order-last">';
    if ($has_post_thumbnail):
    echo '<div class="swiper-wrapper">';
        echo '<div class="swiper-slide">';
           the_post_thumbnail('full');
        echo '</div>';
        foreach ($attachment_ids as $attachment_id) {
            echo '<div class="swiper-slide">';
                echo wp_get_attachment_image($attachment_id, 'large');
            echo '</div>';
        }

    echo '</div>';
    else:
       echo wc_placeholder_img('full');
    endif;
    echo '</div>';

    if ($has_post_thumbnail):
        // Thumbnail Slider
        echo '<div class="swiper gallery-thumbs">';
            echo '<div class="swiper-wrapper">';
                 echo '<div class="swiper-slide">';
                       the_post_thumbnail('thumbnail');
                 echo '</div>';
                foreach ($attachment_ids as $attachment_id) {
                    echo '<div class="swiper-slide">';
                        echo wp_get_attachment_image($attachment_id, 'thumbnail');
                    echo '</div>';
                }
            echo '</div>';
        echo '</div>';
//        echo '<div class="swiper-button-prev swiper-icon"></div><div class="swiper-button-next swiper-icon"></div></div>';
    endif;

