<?php
$section_title = get_field('section_title', 'option');
$section_subtitle = get_field('section_subtitle', 'option');
$pro_link = get_field('pro_link', 'option');
?>

<section class="popular-products">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 text-center section-head">
                <?php if($section_title) { echo '<h2 class="section-title">'.$section_title.'</h2>'; } ?>
                <?php if($section_subtitle) { echo '<span class="d-block subtitle">'.$section_subtitle.'</span>'; } ?>
            </div>
            <div class="col-12">
                <div class="product-wrapper position-relative">
                    <div class="row align-items-center">
                        <div class="col-12 col-md-3 col-xl-2">
                            <div class="d-flex flex-md-column box-title-wrapper justify-content-between align-items-center">
                                <?php if($section_title) { echo '<h3 class="title">'.$section_title.'</h3>'; } ?>
                                <?php if($pro_link) {
                                    echo '<a href="'.$pro_link.'" class="link-btn">
                                        مشاهده همه
                                        <i class="icon-chevron-left"></i>
                                    </a>';
                                } ?>
                            </div>
                        </div>
                        <div class="col-12 col-md-9 col-xl-10 position-relative">
                            <div class="swiper swiper-product">
                                <div class="swiper-wrapper">
                                    <?php
                                    $args = array(
                                        'post_type' => 'product',
                                        'posts_per_page' => 8,
                                        'meta_query' => array(
                                            array(
                                                'key' => 'is_show',
                                                'compare' => '=',
                                                'value' => '1'
                                            ),
                                        ),
                                    );
                                    $posts = new WP_Query($args);
                                    if ($posts->have_posts()) {
                                        while ($posts->have_posts()) : $posts->the_post(); ?>
                                            <div class="swiper-slide">
                                                <?php echo get_template_part('templates/card/home', 'product'); ?>
                                            </div>
                                    <?php
                                        endwhile;
                                        }
                                    wp_reset_query();
                                    ?>
                                </div>
                            </div>
                            <!-- If we need navigation buttons -->
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
