<?php

ob_start();
//lightgallery
add_filter('post_gallery', 'ct_post_gallery', 10, 2);
function ct_post_gallery($output, $attr) {
    global $post;

    if (isset($attr['orderby'])) {
        $attr['orderby'] = sanitize_sql_orderby($attr['orderby']);
        if (!$attr['orderby'])
            unset($attr['orderby']);
    }

    extract(shortcode_atts(array(
        'order' => 'ASC',
        'orderby' => 'menu_order ID',
        'id' => $post->ID,
        'itemtag' => 'dl',
        'icontag' => 'dt',
        'captiontag' => 'dd',
        'columns' => 3,
        'size' => 'medium',
        'include' => '',
        'exclude' => ''
    ), $attr));

    $id = intval($id);
    if ('RAND' == $order) $orderby = 'none';

    if (!empty($include)) {
        $include = preg_replace('/[^0-9,]+/', '', $include);
        $_attachments = get_posts(array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));

        $attachments = array();
        foreach ($_attachments as $key => $val) {
            $attachments[$val->ID] = $_attachments[$key];
        }
    }

    if (empty($attachments)) return '';

    // Here's your actual output, you may customize it to your need
    $output .= "<div class=\"editor-gallery_wrapper position-relative\"><div class=\"swiper swiper-gallery\"><div class=\"swiper-wrapper editor_gallery\" id=\"page_lightgallery\">\n";

    // Now you loop through each attachment
    foreach ($attachments as $id => $attachment) {
        // Fetch the thumbnail (or full image, it's up to you)
        $full = wp_get_attachment_image_src($id, 'full');
        // $img = wp_get_attachment_image_src($id, 'my-custom-image-size');
        $size = 'medium';
        $img = wp_get_attachment_image_src($id, $size);
        $image_alt = get_post_meta( $id , '_wp_attachment_image_alt', true);
        $output .= "<div class=\"swiper-slide gallery_item\" data-src=\"{$full[0]}\" data-thumb=\"{$full[0]}\">\n";
        $output .= "<a href=\"{$full[0]}\" ><i class='icon-plus'></i><img src=\"{$img[0]}\" width=\"{$img[1]}\" height=\"{$img[2]}\" alt=\"{$image_alt}\" /></a>\n";
        $output .= "</div>\n";
    }

    $output .= "</div></div><div class=\"swiper-button-prev\"></div><div class=\"swiper-button-next\"></div></div>\n";

    return $output;
}

// Pagination
function pagination_bar( $custom_query ) {
	$total_pages = $custom_query->max_num_pages;
	//echo $total_pages;
	$big = 999999999; // need an unlikely integer
	if ($total_pages > 1){
		$current_page = max(1, get_query_var('paged'));
		echo paginate_links(array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'prev_text' => __('<i class="icon-chevron-left"></i>'),
			'next_text' => __('<i class="icon-chevron-left"></i>'),
			'before_page_number' => '',
			'current' => $current_page,
			'total' => $total_pages,
		));
	}
}

function custom_recent_posts_with_thumbnails() {
    $recent_posts = wp_get_recent_posts(array(
        'numberposts' => 5,
        'post_status' => 'publish',
    ));

    $output = '<ul class="custom-recent-posts">';

    foreach ($recent_posts as $post) {
        $post_id = $post['ID'];
        $title = esc_html($post['post_title']);
        $permalink = get_permalink($post_id);
        $thumbnail = get_the_post_thumbnail($post_id, 'thumbnail');

        $output .= '<li class="recent-post-item">';
        if ($thumbnail) {
            $output .= '<a href="' . $permalink . '">' . $thumbnail . '</a>';
        }
        $output .= '<div class="post-info">';
        $output .= '<a href="' . $permalink . '">' . $title . '</a>';
        $output .= '</div></li>';
    }

    $output .= '</ul>';
    return $output;
}




class My_Custom_Widget extends WP_Widget {
    function __construct() {
        parent::__construct(
            'my_custom_widget', // Base ID
            __('آخرین نوشته ها', 'tiyara'), // Name
            array('description' => __('نمایش نوشته ها با تصویر', 'tiyara')) // Args
        );
    }
    public function widget($args, $instance) {
        echo $args['before_widget'];
        $title = apply_filters('widget_title', $instance['title']);
        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        $recent_posts = wp_get_recent_posts(array(
            'numberposts' => 5,
            'post_status' => 'publish',
        ));

        $output = '<ul class="custom-recent-posts">';

        foreach ($recent_posts as $post) {
            $post_id = $post['ID'];
            $title = esc_html($post['post_title']);
            $permalink = get_permalink($post_id);
            $thumbnail = get_the_post_thumbnail($post_id, 'thumbnail');

            $output .= '<li class="recent-post-item mb-4 pb-4 d-flex">';
            if ($thumbnail) {
                $output .= '<div class="col-5"><a class="ratio-4x3 ratio" href="' . $permalink . '">' . $thumbnail . '</a>';
                $output .= '</div>';
            }
            $output .= '<div class="post-info col-7">';
            $output .= '<a class="post-title" href="' . $permalink . '">' . wp_trim_words( $title , 7 ). '</a>';
            $output .= '<span class="post-date d-block">';
            $output .= '<i class="icon-calendar"></i>';
            $output .= get_the_date(' m F Y');
            $output .= '</span>';
            $output .= '<a class="more-link" href="' . $permalink . '">مطالعه بیشتر <i class="icon-arrow-left"></i> </a>';
            $output .= '</div></li>';
        }

        $output .= '</ul>';
        echo $output;



        echo $args['after_widget'];
    }
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : __('آخرین مقالات', 'text_domain');
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        return $instance;
    }
}
function register_my_custom_widget() {
    register_widget('My_Custom_Widget');
}
add_action('widgets_init', 'register_my_custom_widget');

add_filter('wpcf7_autop_or_not', '__return_false');


//add_action('wp_nav_menu_item_custom_fields', function ($item_id, $item, $depth, $args) {
//    $icon = get_post_meta($item_id, '_menu_item_icon', true);
//    echo '<p class="description description-wide">
//        <label>آیکن<br />
//            <input type="text" name="menu-item-icon[' . $item_id . ']" value="' . esc_attr($icon) . '" class="widefat" />
//        </label>
//    </p>';
//}, 10, 4);
//
//add_action('wp_update_nav_menu_item', function ($menu_id, $menu_item_db_id, $args) {
//    if (isset($_POST['menu-item-icon'][$menu_item_db_id])) {
//        update_post_meta($menu_item_db_id, '_menu_item_icon', sanitize_text_field($_POST['menu-item-icon'][$menu_item_db_id]));
//    }
//}, 10, 3);



// Add icon, image, and description fields
add_action('wp_nav_menu_item_custom_fields', function ($item_id, $item, $depth, $args) {
    $icon = get_post_meta($item_id, '_menu_item_icon', true);
    $image = get_post_meta($item_id, '_menu_item_image', true);
    $desc = get_post_meta($item_id, '_menu_item_desc', true);

    echo '<p class="description description-wide">
        <label>آیکن<br />
            <input type="text" name="menu-item-icon['.$item_id.']" value="'.esc_attr($icon).'" class="widefat" />
        </label></p>';

    echo '<p class="description description-wide">
        <label>تصویر<br />
            <input type="text" name="menu-item-image['.$item_id.']" value="'.esc_attr($image).'" class="widefat" />
        </label></p>';

    echo '<p class="description description-wide">
        <label>عنوان<br />
            <input name="menu-item-desc['.$item_id.']" value="'.esc_attr($desc).'" class="widefat" />
        </label></p>';
}, 10, 4);

// Save fields
add_action('wp_update_nav_menu_item', function ($menu_id, $menu_item_db_id) {
    foreach (['icon', 'image', 'desc'] as $field) {
        if (isset($_POST["menu-item-{$field}"][$menu_item_db_id])) {
            update_post_meta($menu_item_db_id, "_menu_item_{$field}", sanitize_text_field($_POST["menu-item-{$field}"][$menu_item_db_id]));
        }
    }
}, 10, 2);


add_action('wp_ajax_nopriv_handle_like_dislike', 'handle_like_dislike');
add_action('wp_ajax_handle_like_dislike', 'handle_like_dislike');

function handle_like_dislike() {
    $comment_id = intval($_POST['comment_id']);
    $type = sanitize_text_field($_POST['type']);
    $reverse = isset($_POST['reverse']) ? sanitize_text_field($_POST['reverse']) : null;

    if (!in_array($type, ['like', 'dislike'])) {
        wp_send_json_error('Invalid type');
    }

    $meta_key = $type === 'like' ? 'likes' : 'dislikes';
    $count = get_comment_meta($comment_id, $meta_key, true);
    $count = $count ? intval($count) : 0;
    $count++;
    update_comment_meta($comment_id, $meta_key, $count);

    // If reverse is set (user previously clicked the opposite), reduce it
    if (in_array($reverse, ['like', 'dislike'])) {
        $reverse_key = $reverse === 'like' ? 'likes' : 'dislikes';
        $reverse_count = get_comment_meta($comment_id, $reverse_key, true);
        $reverse_count = $reverse_count ? max(0, intval($reverse_count) - 1) : 0;
        update_comment_meta($comment_id, $reverse_key, $reverse_count);
    }

    // Return both counts
    wp_send_json_success([
        'likes' => intval(get_comment_meta($comment_id, 'likes', true)),
        'dislikes' => intval(get_comment_meta($comment_id, 'dislikes', true))
    ]);
}
?>

