<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_card_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if($product_card_item->is_active()): ?>
        <?php if(!$product_card_item->is_inventory_less_than_min_order_quantity()): ?>
            <?php if($product_card_item->is_in_inventory()): ?>
                <?php if($columns): ?>
                    <div class="col-12 col-md-4 col-lg-3">
                        <?php else: ?>
                            <div class="item">
                                <?php endif; ?>
                                <div class="ts-product product-default border-full-<?php echo e($border_style); ?>">
                                    <div class="w-100">
                                        <div class="product-image-and-details">
                                            <figure class="product-main hover-scale">
                                                <a href="<?php echo e(asset('product/' . $product_card_item->slug)); ?>">
                                                    <?php if($product_card_item->has_thumbnail()): ?>
                                                        <img src="<?php echo e(asset($product_card_item->single_image)); ?>"
                                                             class="product-main-image br-1"
                                                             alt="" loading="lazy" width="250px" height="250px">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('/images/other/no-image.jpg')); ?>" alt=""
                                                             class="br-1 product-main-image" width="250px"
                                                             height="250px">
                                                    <?php endif; ?>
                                                </a>
                                            </figure>
                                            <?php if($product_card_item->is_on_sale()): ?>
                                                <div class="product-image-labels hide-in-mobile">
                                                    <span class="on-sale-label">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="38" height="41"
                                                         viewBox="0 0 38 41">
                                                    <path
                                                        d="M13.12 8.656C13.12 8.82667 13.2053 8.912 13.376 8.912C13.4507 8.912 13.5147 8.89067 13.568 8.848C13.6213 8.79467 13.648 8.73067 13.648 8.656V6.272H16.448V8.912C16.448 9.44533 16.3627 9.904 16.192 10.288C16.0213 10.672 15.792 10.992 15.504 11.248C15.216 11.504 14.8853 11.696 14.512 11.824C14.1493 11.9413 13.7707 12 13.376 12C13.1627 12 12.9013 11.968 12.592 11.904C12.2827 11.84 12.016 11.696 11.792 11.472C11.5253 11.696 11.2693 11.84 11.024 11.904C10.7893 11.968 10.6027 12 10.464 12C10.2507 12 10.0373 11.9787 9.824 11.936C9.62133 11.8933 9.456 11.8293 9.328 11.744L9.76 11.024C9.76 11.6427 9.664 12.224 9.472 12.768C9.28 13.312 8.99733 13.7867 8.624 14.192C8.26133 14.608 7.81333 14.9333 7.28 15.168C6.74667 15.4027 6.13867 15.52 5.456 15.52H4.656C3.99467 15.52 3.40267 15.4187 2.88 15.216C2.368 15.0133 1.93067 14.72 1.568 14.336C1.20533 13.9627 0.928 13.504 0.736 12.96C0.544 12.416 0.448 11.8027 0.448 11.12V7.776H3.344V11.2C3.344 11.6053 3.46133 11.9147 3.696 12.128C3.93067 12.3413 4.30933 12.448 4.832 12.448H5.36C5.936 12.448 6.34667 12.3307 6.592 12.096C6.83733 11.8613 6.96 11.5627 6.96 11.2V6.272H9.76V8.656C9.76 8.73067 9.78667 8.79467 9.84 8.848C9.89333 8.89067 9.95733 8.912 10.032 8.912C10.2027 8.912 10.288 8.82667 10.288 8.656V6.272H13.12V8.656ZM12.752 2.752H10.464V0.559999H12.752V2.752ZM13.904 5.392H9.328V3.2H13.904V5.392ZM24.0266 11.648C24.0266 12.352 23.9253 12.9707 23.7226 13.504C23.5306 14.048 23.2533 14.5013 22.8906 14.864C22.528 15.2267 22.096 15.4987 21.5946 15.68C21.104 15.872 20.5653 15.968 19.9786 15.968H17.5946L17.4186 12.88H20.1546C20.5066 12.88 20.752 12.8107 20.8906 12.672C21.04 12.5333 21.1146 12.3093 21.1146 12H20.8586C20.1973 12 19.6533 11.9253 19.2266 11.776C18.8 11.6267 18.464 11.4187 18.2186 11.152C17.984 10.8747 17.8186 10.5387 17.7226 10.144C17.6373 9.74933 17.5946 9.312 17.5946 8.832C17.5946 8.37333 17.664 7.936 17.8026 7.52C17.9413 7.104 18.144 6.74133 18.4106 6.432C18.688 6.112 19.024 5.86133 19.4186 5.68C19.8133 5.488 20.2613 5.392 20.7626 5.392C21.2 5.392 21.616 5.456 22.0106 5.584C22.4053 5.712 22.752 5.92 23.0506 6.208C23.3493 6.48533 23.584 6.848 23.7546 7.296C23.936 7.73333 24.0266 8.272 24.0266 8.912V11.648ZM20.3306 8.64C20.3306 8.81067 20.3626 8.944 20.4266 9.04C20.4906 9.136 20.6346 9.184 20.8586 9.184H21.2906V8.736C21.2906 8.33067 21.1253 8.128 20.7946 8.128C20.4853 8.128 20.3306 8.29867 20.3306 8.64ZM24.37 12.624C24.946 12.624 25.3513 12.5067 25.586 12.272C25.8313 12.0373 25.954 11.744 25.954 11.392V6.272H28.866V8.688C28.866 8.83733 28.9513 8.912 29.122 8.912H29.73C29.794 8.912 29.8473 8.928 29.89 8.96C29.9433 8.98133 29.9807 9.04 30.002 9.136C30.034 9.232 30.0553 9.38133 30.066 9.584C30.0767 9.78667 30.082 10.064 30.082 10.416C30.082 10.7893 30.0767 11.0827 30.066 11.296C30.0553 11.5093 30.034 11.6693 30.002 11.776C29.9807 11.8827 29.9433 11.9467 29.89 11.968C29.8473 11.9893 29.794 12 29.73 12H29.474C29.218 12 28.994 11.984 28.802 11.952C28.738 12.4747 28.594 12.96 28.37 13.408C28.146 13.8667 27.858 14.2613 27.506 14.592C27.154 14.9333 26.738 15.2 26.258 15.392C25.7887 15.5947 25.2713 15.696 24.706 15.696H23.922L23.666 12.624H24.37ZM30.7904 8.912C30.7264 8.73067 30.6784 8.55467 30.6464 8.384C30.625 8.21333 30.6144 8.04267 30.6144 7.872C30.6144 7.52 30.6784 7.16267 30.8064 6.8C30.945 6.42667 31.1477 6.096 31.4144 5.808C31.681 5.50933 32.017 5.264 32.4224 5.072C32.8384 4.88 33.3184 4.784 33.8624 4.784C34.321 4.784 34.7477 4.848 35.1424 4.976C35.537 5.104 35.873 5.30667 36.1504 5.584C36.4277 5.86133 36.6464 6.224 36.8064 6.672C36.9664 7.12 37.0464 7.664 37.0464 8.304V8.912C37.0464 9.36 36.9717 9.77067 36.8224 10.144C36.6837 10.5173 36.465 10.8427 36.1664 11.12C35.8677 11.3973 35.489 11.616 35.0304 11.776C34.5824 11.9253 34.049 12 33.4304 12H29.7344C29.6704 12 29.617 11.9893 29.5744 11.968C29.521 11.9467 29.4837 11.888 29.4624 11.792C29.4304 11.6853 29.409 11.5307 29.3984 11.328C29.3877 11.1253 29.3824 10.848 29.3824 10.496C29.3824 10.1227 29.3877 9.82933 29.3984 9.616C29.409 9.40267 29.4304 9.248 29.4624 9.152C29.4837 9.04533 29.521 8.98133 29.5744 8.96C29.617 8.928 29.6704 8.912 29.7344 8.912H30.7904ZM34.2144 9.008C34.2677 8.92267 34.2944 8.816 34.2944 8.688C34.305 8.56 34.3104 8.432 34.3104 8.304C34.3104 8.12267 34.273 7.96267 34.1984 7.824C34.1344 7.67467 33.9957 7.6 33.7824 7.6C33.6544 7.6 33.5477 7.64267 33.4624 7.728C33.3877 7.80267 33.3504 7.904 33.3504 8.032C33.3504 8.16 33.393 8.30933 33.4784 8.48C33.5744 8.65067 33.8197 8.82667 34.2144 9.008ZM35.2864 3.904H32.3744V1.712H35.2864V3.904ZM0.448 33.912C0.448 33.3893 0.554667 32.8987 0.768 32.44C0.981333 31.9707 1.312 31.464 1.76 30.92L1.088 30.216L3.136 28.2C3.95733 28.9467 4.61867 29.5973 5.12 30.152C5.62133 30.696 6.00533 31.1867 6.272 31.624C6.54933 32.0507 6.73067 32.4453 6.816 32.808C6.912 33.1707 6.96 33.5387 6.96 33.912C6.96 34.36 6.87467 34.7707 6.704 35.144C6.53333 35.5173 6.29867 35.8427 6 36.12C5.712 36.3973 5.36 36.616 4.944 36.776C4.53867 36.9253 4.096 37 3.616 37C3.136 37 2.69867 36.9253 2.304 36.776C1.90933 36.6267 1.57333 36.4187 1.296 36.152C1.02933 35.8853 0.821333 35.5653 0.672 35.192C0.522667 34.808 0.448 34.3813 0.448 33.912ZM4.224 33.624C4.224 33.3253 4.048 33.016 3.696 32.696C3.344 33.0373 3.168 33.3467 3.168 33.624C3.168 33.9333 3.344 34.088 3.696 34.088C4.048 34.088 4.224 33.9333 4.224 33.624ZM11.0066 33.688C11.0066 33.8373 11.092 33.912 11.2626 33.912H11.8706C11.9346 33.912 11.988 33.928 12.0306 33.96C12.084 33.9813 12.1213 34.04 12.1426 34.136C12.1746 34.232 12.196 34.3813 12.2066 34.584C12.2173 34.7867 12.2226 35.064 12.2226 35.416C12.2226 35.7893 12.2173 36.0827 12.2066 36.296C12.196 36.5093 12.1746 36.6693 12.1426 36.776C12.1213 36.8827 12.084 36.9467 12.0306 36.968C11.988 36.9893 11.9346 37 11.8706 37H11.6146C11.3586 37 11.1346 36.984 10.9426 36.952C10.8786 37.4747 10.7346 37.96 10.5106 38.408C10.2866 38.8667 9.99863 39.2613 9.64663 39.592C9.29463 39.9333 8.87863 40.2 8.39863 40.392C7.92929 40.5947 7.41729 40.696 6.86263 40.696H5.10262L4.83062 37.624H6.51062C7.08662 37.624 7.49196 37.5067 7.72663 37.272C7.97196 37.0373 8.09463 36.744 8.09463 36.392V31.272H11.0066V33.688ZM10.6386 27.752H8.35063V25.56H10.6386V27.752ZM11.7906 30.392H7.21462V28.2H11.7906V30.392ZM14.515 33.912C14.579 33.912 14.6323 33.928 14.675 33.96C14.7283 33.9813 14.7657 34.04 14.787 34.136C14.819 34.232 14.8403 34.3813 14.851 34.584C14.8617 34.7867 14.867 35.064 14.867 35.416C14.867 35.7893 14.8617 36.0827 14.851 36.296C14.8403 36.5093 14.819 36.6693 14.787 36.776C14.7657 36.8827 14.7283 36.9467 14.675 36.968C14.6323 36.9893 14.579 37 14.515 37H11.875C11.811 37 11.7577 36.9893 11.715 36.968C11.6617 36.9467 11.6243 36.888 11.603 36.792C11.571 36.6853 11.5497 36.5307 11.539 36.328C11.5283 36.1253 11.523 35.848 11.523 35.496C11.523 35.1227 11.5283 34.8293 11.539 34.616C11.5497 34.4027 11.571 34.248 11.603 34.152C11.6243 34.0453 11.6617 33.9813 11.715 33.96C11.7577 33.928 11.811 33.912 11.875 33.912H14.515ZM17.1556 33.912C17.2196 33.912 17.273 33.928 17.3156 33.96C17.369 33.9813 17.4063 34.04 17.4276 34.136C17.4596 34.232 17.481 34.3813 17.4916 34.584C17.5023 34.7867 17.5076 35.064 17.5076 35.416C17.5076 35.7893 17.5023 36.0827 17.4916 36.296C17.481 36.5093 17.4596 36.6693 17.4276 36.776C17.4063 36.8827 17.369 36.9467 17.3156 36.968C17.273 36.9893 17.2196 37 17.1556 37H14.5156C14.4516 37 14.3983 36.9893 14.3556 36.968C14.3023 36.9467 14.265 36.888 14.2436 36.792C14.2116 36.6853 14.1903 36.5307 14.1796 36.328C14.169 36.1253 14.1636 35.848 14.1636 35.496C14.1636 35.1227 14.169 34.8293 14.1796 34.616C14.1903 34.4027 14.2116 34.248 14.2436 34.152C14.265 34.0453 14.3023 33.9813 14.3556 33.96C14.3983 33.928 14.4516 33.912 14.5156 33.912H17.1556ZM19.7963 33.912C19.8603 33.912 19.9136 33.928 19.9563 33.96C20.0096 33.9813 20.0469 34.04 20.0683 34.136C20.1003 34.232 20.1216 34.3813 20.1323 34.584C20.1429 34.7867 20.1483 35.064 20.1483 35.416C20.1483 35.7893 20.1429 36.0827 20.1323 36.296C20.1216 36.5093 20.1003 36.6693 20.0683 36.776C20.0469 36.8827 20.0096 36.9467 19.9563 36.968C19.9136 36.9893 19.8603 37 19.7963 37H17.1562C17.0922 37 17.0389 36.9893 16.9962 36.968C16.9429 36.9467 16.9056 36.888 16.8842 36.792C16.8522 36.6853 16.8309 36.5307 16.8202 36.328C16.8096 36.1253 16.8042 35.848 16.8042 35.496C16.8042 35.1227 16.8096 34.8293 16.8202 34.616C16.8309 34.4027 16.8522 34.248 16.8842 34.152C16.9056 34.0453 16.9429 33.9813 16.9962 33.96C17.0389 33.928 17.0922 33.912 17.1562 33.912H19.7963ZM22.4369 33.912C22.5009 33.912 22.5542 33.928 22.5969 33.96C22.6502 33.9813 22.6875 34.04 22.7089 34.136C22.7409 34.232 22.7622 34.3813 22.7729 34.584C22.7835 34.7867 22.7889 35.064 22.7889 35.416C22.7889 35.7893 22.7835 36.0827 22.7729 36.296C22.7622 36.5093 22.7409 36.6693 22.7089 36.776C22.6875 36.8827 22.6502 36.9467 22.5969 36.968C22.5542 36.9893 22.5009 37 22.4369 37H19.7969C19.7329 37 19.6795 36.9893 19.6369 36.968C19.5835 36.9467 19.5462 36.888 19.5249 36.792C19.4929 36.6853 19.4715 36.5307 19.4609 36.328C19.4502 36.1253 19.4449 35.848 19.4449 35.496C19.4449 35.1227 19.4502 34.8293 19.4609 34.616C19.4715 34.4027 19.4929 34.248 19.5249 34.152C19.5462 34.0453 19.5835 33.9813 19.6369 33.96C19.6795 33.928 19.7329 33.912 19.7969 33.912H22.4369ZM25.0775 33.912C25.1415 33.912 25.1948 33.928 25.2375 33.96C25.2908 33.9813 25.3282 34.04 25.3495 34.136C25.3815 34.232 25.4028 34.3813 25.4135 34.584C25.4242 34.7867 25.4295 35.064 25.4295 35.416C25.4295 35.7893 25.4242 36.0827 25.4135 36.296C25.4028 36.5093 25.3815 36.6693 25.3495 36.776C25.3282 36.8827 25.2908 36.9467 25.2375 36.968C25.1948 36.9893 25.1415 37 25.0775 37H22.4375C22.3735 37 22.3202 36.9893 22.2775 36.968C22.2242 36.9467 22.1868 36.888 22.1655 36.792C22.1335 36.6853 22.1122 36.5307 22.1015 36.328C22.0908 36.1253 22.0855 35.848 22.0855 35.496C22.0855 35.1227 22.0908 34.8293 22.1015 34.616C22.1122 34.4027 22.1335 34.248 22.1655 34.152C22.1868 34.0453 22.2242 33.9813 22.2775 33.96C22.3202 33.928 22.3735 33.912 22.4375 33.912H25.0775ZM26.0541 33.912C26.1181 33.912 26.1768 33.8907 26.2301 33.848C26.2835 33.7947 26.3101 33.7307 26.3101 33.656V31.272H29.2061V33.912C29.2061 34.424 29.1315 34.872 28.9821 35.256C28.8435 35.64 28.6461 35.96 28.3901 36.216C28.1341 36.472 27.8248 36.6693 27.4621 36.808C27.1101 36.936 26.7261 37 26.3101 37H25.0781C25.0141 37 24.9608 36.9893 24.9181 36.968C24.8648 36.9467 24.8275 36.888 24.8061 36.792C24.7741 36.6853 24.7528 36.5307 24.7421 36.328C24.7315 36.1253 24.7261 35.848 24.7261 35.496C24.7261 35.1227 24.7315 34.8293 24.7421 34.616C24.7528 34.4027 24.7741 34.248 24.8061 34.152C24.8275 34.0453 24.8648 33.9813 24.9181 33.96C24.9608 33.928 25.0141 33.912 25.0781 33.912H26.0541ZM29.6541 40.072H25.0781V37.864H29.6541V40.072ZM36.7923 36.648C36.7923 37.352 36.6909 37.9707 36.4883 38.504C36.2963 39.048 36.0189 39.5013 35.6563 39.864C35.2936 40.2267 34.8616 40.4987 34.3602 40.68C33.8696 40.872 33.3309 40.968 32.7443 40.968H30.3603L30.1842 37.88H32.9203C33.2723 37.88 33.5176 37.8107 33.6562 37.672C33.8056 37.5333 33.8802 37.3093 33.8802 37H33.6243C32.9629 37 32.4189 36.9253 31.9923 36.776C31.5656 36.6267 31.2296 36.4187 30.9843 36.152C30.7496 35.8747 30.5843 35.5387 30.4883 35.144C30.4029 34.7493 30.3603 34.312 30.3603 33.832C30.3603 33.3733 30.4296 32.936 30.5683 32.52C30.7069 32.104 30.9096 31.7413 31.1763 31.432C31.4536 31.112 31.7896 30.8613 32.1843 30.68C32.5789 30.488 33.0269 30.392 33.5283 30.392C33.9656 30.392 34.3816 30.456 34.7763 30.584C35.1709 30.712 35.5176 30.92 35.8163 31.208C36.1149 31.4853 36.3496 31.848 36.5203 32.296C36.7016 32.7333 36.7923 33.272 36.7923 33.912V36.648ZM33.0963 33.64C33.0963 33.8107 33.1283 33.944 33.1923 34.04C33.2563 34.136 33.4003 34.184 33.6243 34.184H34.0563V33.736C34.0563 33.3307 33.8909 33.128 33.5603 33.128C33.2509 33.128 33.0963 33.2987 33.0963 33.64Z"/>
                                                </svg>
                                                    </span>
                                                </div>
                                            <?php endif; ?>
                                            <div class="product-details product-default">
                                                <div class="details-wrapp">
                                                    <div class="product-cat">
                                                        <?php
                                                            $numItems = count($product_card_item->categories);
                                                            $i = 0;
                                                        ?>
                                                        <?php if($product_card_item->categories->count()): ?>
                                                            <?php $__currentLoopData = $product_card_item->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_card_item_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(++$i == $numItems): ?>
                                                                <a href="<?php echo e(route('product-category.show' , $product_card_item_category)); ?>"><?php echo e($product_card_item_category->name); ?></a>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <a href="#">بدون دسته بندی</a>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php if($product_card_item->reviews->whereNull('parent_id')->where('status')->count()): ?>
                                                        <div class="product-rating">
                                                            <i class="fi fi-rr-star align-middle"></i>
                                                            <?php echo e(get_review_average($product_card_item)); ?>

                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="product-title">
                                                    <h3>
                                                        <a href="<?php echo e(asset('product/' . $product_card_item->slug)); ?>">
                                                            <?php echo e($product_card_item->title); ?>

                                                        </a>
                                                    </h3>
                                                </div>
                                                <div
                                                    class="product-price d-flex justify-content-center align-items-center">
                                                    <?php if($product_card_item->is_on_sale()): ?>
                                                        <ins class="old-price ml-3">
                                                            <?php echo e(number_format($product_card_item->price)); ?>

                                                        </ins>

                                                        <ins class="new-price">
                                                            <?php echo e(number_format($product_card_item->sale_price)); ?>

                                                        </ins>
                                                        <svg class="ts-mr-small" width="14" height="16"
                                                             viewBox="0 0 14 16" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path class="text-gray-880 dark:text-white"
                                                                  d="M1.14878 6.91843C1.44428 6.91843 1.70285 6.87142 1.92447 6.77739C2.15282 6.68337 2.34422 6.55577 2.49869 6.39458C2.65316 6.2334 2.77069 6.04535 2.85128 5.83044C2.93187 5.62224 2.97888 5.40062 2.99231 5.16556H1.98492C1.6424 5.16556 1.36033 5.12862 1.1387 5.05474C0.917077 4.98087 0.742461 4.87341 0.614858 4.73238C0.487254 4.59134 0.396588 4.42344 0.34286 4.22868C0.295849 4.0272 0.272343 3.80221 0.272343 3.55372C0.272343 3.29852 0.309281 3.05674 0.383156 2.8284C0.457032 2.60005 0.564488 2.39857 0.705523 2.22396C0.846559 2.04934 1.02117 1.91167 1.22937 1.81093C1.44428 1.70347 1.68941 1.64974 1.96477 1.64974C2.1864 1.64974 2.39795 1.68668 2.59943 1.76056C2.80091 1.83443 2.97888 1.95196 3.13335 2.11315C3.28782 2.26761 3.40871 2.47245 3.49601 2.72766C3.59004 2.97615 3.63705 3.27837 3.63705 3.63431V4.47045H4.60415C4.68474 4.47045 4.73847 4.50068 4.76533 4.56112C4.79891 4.61485 4.8157 4.6988 4.8157 4.81297C4.8157 4.93386 4.79891 5.02452 4.76533 5.08497C4.73847 5.13869 4.68474 5.16556 4.60415 5.16556H3.6169C3.60347 5.49464 3.53631 5.80693 3.41542 6.10244C3.30125 6.39794 3.14007 6.65651 2.93187 6.87813C2.72368 7.09976 2.47518 7.27438 2.1864 7.40198C1.89761 7.5363 1.57188 7.60346 1.20922 7.60346H0.141381L0.0809373 6.91843H1.14878ZM0.896929 3.51343C0.896929 3.68133 0.913719 3.82572 0.947299 3.94661C0.987594 4.0675 1.0514 4.16823 1.1387 4.24883C1.23273 4.3227 1.35697 4.37979 1.51144 4.42008C1.66591 4.45366 1.86067 4.47045 2.09573 4.47045H3.00239V3.71491C3.00239 3.21792 2.90501 2.86198 2.71024 2.64707C2.51548 2.43215 2.24684 2.3247 1.90433 2.3247C1.58196 2.3247 1.33347 2.43215 1.15885 2.64707C0.984237 2.86198 0.896929 3.15076 0.896929 3.51343ZM6.26895 4.47045C6.35626 4.47045 6.41335 4.50068 6.44021 4.56112C6.47379 4.61485 6.49058 4.6988 6.49058 4.81297C6.49058 4.93386 6.47379 5.02452 6.44021 5.08497C6.41335 5.13869 6.35626 5.16556 6.26895 5.16556H4.60675C4.51944 5.16556 4.46235 5.13869 4.43549 5.08497C4.40191 5.03124 4.38512 4.94729 4.38512 4.83312C4.38512 4.71223 4.40191 4.62156 4.43549 4.56112C4.46235 4.50068 4.51944 4.47045 4.60675 4.47045H6.26895ZM7.93155 4.47045C8.01886 4.47045 8.07594 4.50068 8.10281 4.56112C8.13639 4.61485 8.15318 4.6988 8.15318 4.81297C8.15318 4.93386 8.13639 5.02452 8.10281 5.08497C8.07594 5.13869 8.01886 5.16556 7.93155 5.16556H6.26935C6.18204 5.16556 6.12495 5.13869 6.09809 5.08497C6.06451 5.03124 6.04772 4.94729 6.04772 4.83312C6.04772 4.71223 6.06451 4.62156 6.09809 4.56112C6.12495 4.50068 6.18204 4.47045 6.26935 4.47045H7.93155ZM9.59415 4.47045C9.68146 4.47045 9.73854 4.50068 9.76541 4.56112C9.79899 4.61485 9.81578 4.6988 9.81578 4.81297C9.81578 4.93386 9.79899 5.02452 9.76541 5.08497C9.73854 5.13869 9.68146 5.16556 9.59415 5.16556H7.93194C7.84464 5.16556 7.78755 5.13869 7.76069 5.08497C7.72711 5.03124 7.71032 4.94729 7.71032 4.83312C7.71032 4.71223 7.72711 4.62156 7.76069 4.56112C7.78755 4.50068 7.84464 4.47045 7.93194 4.47045H9.59415ZM11.2567 4.47045C11.3441 4.47045 11.4011 4.50068 11.428 4.56112C11.4616 4.61485 11.4784 4.6988 11.4784 4.81297C11.4784 4.93386 11.4616 5.02452 11.428 5.08497C11.4011 5.13869 11.3441 5.16556 11.2567 5.16556H9.59454C9.50723 5.16556 9.45015 5.13869 9.42328 5.08497C9.3897 5.03124 9.37291 4.94729 9.37291 4.83312C9.37291 4.71223 9.3897 4.62156 9.42328 4.56112C9.45015 4.50068 9.50723 4.47045 9.59454 4.47045H11.2567ZM12.1638 4.47045C12.4257 4.47045 12.6339 4.39994 12.7884 4.2589C12.9496 4.11787 13.0302 3.9231 13.0302 3.67461V2.2844H13.685V3.67461C13.685 4.15144 13.5506 4.52082 13.282 4.78275C13.0201 5.03795 12.6608 5.16556 12.2041 5.16556H11.2571C11.1698 5.16556 11.1127 5.13869 11.0859 5.08497C11.0523 5.03124 11.0355 4.94729 11.0355 4.83312C11.0355 4.71223 11.0523 4.62156 11.0859 4.56112C11.1127 4.50068 11.1698 4.47045 11.2571 4.47045H12.1638ZM13.7857 0.994934H12.9798V0.279683H13.7857V0.994934ZM12.5063 0.994934H11.7004V0.279683H12.5063V0.994934ZM5.64177 12.9641C5.64177 13.3267 5.58468 13.6659 5.47051 13.9815C5.35634 14.3039 5.1918 14.5826 4.97689 14.8177C4.76198 15.0595 4.50005 15.2509 4.19112 15.3919C3.8889 15.5329 3.54638 15.6035 3.16357 15.6035H2.56921C1.81702 15.6035 1.23273 15.3718 0.816337 14.9084C0.399946 14.445 0.191751 13.8103 0.191751 13.0044V11.2414H0.836485V12.9842C0.836485 13.273 0.870065 13.5349 0.937225 13.77C1.0111 14.0051 1.12191 14.2065 1.26967 14.3744C1.42413 14.549 1.61554 14.6834 1.84388 14.7774C2.07223 14.8714 2.34758 14.9184 2.66995 14.9184H3.1132C3.42885 14.9184 3.70421 14.8647 3.93927 14.7572C4.17433 14.6565 4.36909 14.5188 4.52356 14.3442C4.68474 14.1696 4.80227 13.9648 4.87615 13.7297C4.95674 13.4946 4.99703 13.2495 4.99703 12.9943V10.2844H5.64177V12.9641ZM3.21394 10.0628H2.36773V9.32738H3.21394V10.0628ZM8.24526 13.1656C8.07064 13.1656 7.90274 13.1421 7.74156 13.095C7.58038 13.0413 7.43598 12.954 7.30838 12.8331C7.18749 12.7122 7.09011 12.5544 7.01624 12.3596C6.94236 12.1582 6.90542 11.9097 6.90542 11.6142V6.9197H7.56023V11.4933C7.56023 11.7754 7.62067 12.0104 7.74156 12.1985C7.86916 12.3798 8.074 12.4705 8.35607 12.4705H8.52733C8.67508 12.4705 8.74896 12.5846 8.74896 12.813C8.74896 13.048 8.67508 13.1656 8.52733 13.1656H8.24526ZM8.69324 12.4705C8.95516 12.4705 9.15328 12.4067 9.2876 12.279C9.42192 12.1514 9.48908 11.9802 9.48908 11.7653V11.3825C9.48908 10.7982 9.63683 10.3415 9.93233 10.0124C10.2346 9.68332 10.6509 9.51878 11.1815 9.51878C11.4569 9.51878 11.6986 9.56243 11.9068 9.64974C12.115 9.73705 12.2863 9.8613 12.4206 10.0225C12.5616 10.1837 12.6657 10.3751 12.7329 10.5967C12.8001 10.8183 12.8336 11.0635 12.8336 11.3321C12.8336 11.9097 12.6825 12.3596 12.3803 12.682C12.0781 13.0044 11.6651 13.1656 11.1412 13.1656C10.8726 13.1656 10.614 13.1152 10.3655 13.0144C10.117 12.907 9.92226 12.7189 9.78123 12.4503C9.72078 12.6048 9.64691 12.729 9.5596 12.823C9.47229 12.9171 9.38162 12.9909 9.2876 13.0447C9.19358 13.0917 9.09284 13.1253 8.98538 13.1454C8.88464 13.1588 8.78726 13.1656 8.69324 13.1656H8.53205C8.44475 13.1656 8.38766 13.1387 8.3608 13.085C8.32722 13.0312 8.31043 12.9473 8.31043 12.8331C8.31043 12.7122 8.32722 12.6216 8.3608 12.5611C8.38766 12.5007 8.44475 12.4705 8.53205 12.4705H8.69324ZM12.1889 11.3925C12.1889 11.0433 12.1117 10.7612 11.9572 10.5463C11.8027 10.3247 11.5375 10.2139 11.1614 10.2139C10.4629 10.2139 10.1137 10.6202 10.1137 11.4328C10.1137 11.7754 10.2077 12.0339 10.3957 12.2085C10.5905 12.3831 10.839 12.4705 11.1412 12.4705C11.4837 12.4705 11.7423 12.3764 11.9169 12.1884C12.0982 12.0003 12.1889 11.7351 12.1889 11.3925Z"
                                                                  fill="currentColor"></path>
                                                        </svg>
                                                    <?php else: ?>
                                                        <ins class="new-price">
                                                            <?php echo e(number_format($product_card_item->price)); ?>

                                                        </ins>
                                                        <svg class="ts-mr-small" width="14" height="16"
                                                             viewBox="0 0 14 16" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path class="text-gray-880 dark:text-white"
                                                                  d="M1.14878 6.91843C1.44428 6.91843 1.70285 6.87142 1.92447 6.77739C2.15282 6.68337 2.34422 6.55577 2.49869 6.39458C2.65316 6.2334 2.77069 6.04535 2.85128 5.83044C2.93187 5.62224 2.97888 5.40062 2.99231 5.16556H1.98492C1.6424 5.16556 1.36033 5.12862 1.1387 5.05474C0.917077 4.98087 0.742461 4.87341 0.614858 4.73238C0.487254 4.59134 0.396588 4.42344 0.34286 4.22868C0.295849 4.0272 0.272343 3.80221 0.272343 3.55372C0.272343 3.29852 0.309281 3.05674 0.383156 2.8284C0.457032 2.60005 0.564488 2.39857 0.705523 2.22396C0.846559 2.04934 1.02117 1.91167 1.22937 1.81093C1.44428 1.70347 1.68941 1.64974 1.96477 1.64974C2.1864 1.64974 2.39795 1.68668 2.59943 1.76056C2.80091 1.83443 2.97888 1.95196 3.13335 2.11315C3.28782 2.26761 3.40871 2.47245 3.49601 2.72766C3.59004 2.97615 3.63705 3.27837 3.63705 3.63431V4.47045H4.60415C4.68474 4.47045 4.73847 4.50068 4.76533 4.56112C4.79891 4.61485 4.8157 4.6988 4.8157 4.81297C4.8157 4.93386 4.79891 5.02452 4.76533 5.08497C4.73847 5.13869 4.68474 5.16556 4.60415 5.16556H3.6169C3.60347 5.49464 3.53631 5.80693 3.41542 6.10244C3.30125 6.39794 3.14007 6.65651 2.93187 6.87813C2.72368 7.09976 2.47518 7.27438 2.1864 7.40198C1.89761 7.5363 1.57188 7.60346 1.20922 7.60346H0.141381L0.0809373 6.91843H1.14878ZM0.896929 3.51343C0.896929 3.68133 0.913719 3.82572 0.947299 3.94661C0.987594 4.0675 1.0514 4.16823 1.1387 4.24883C1.23273 4.3227 1.35697 4.37979 1.51144 4.42008C1.66591 4.45366 1.86067 4.47045 2.09573 4.47045H3.00239V3.71491C3.00239 3.21792 2.90501 2.86198 2.71024 2.64707C2.51548 2.43215 2.24684 2.3247 1.90433 2.3247C1.58196 2.3247 1.33347 2.43215 1.15885 2.64707C0.984237 2.86198 0.896929 3.15076 0.896929 3.51343ZM6.26895 4.47045C6.35626 4.47045 6.41335 4.50068 6.44021 4.56112C6.47379 4.61485 6.49058 4.6988 6.49058 4.81297C6.49058 4.93386 6.47379 5.02452 6.44021 5.08497C6.41335 5.13869 6.35626 5.16556 6.26895 5.16556H4.60675C4.51944 5.16556 4.46235 5.13869 4.43549 5.08497C4.40191 5.03124 4.38512 4.94729 4.38512 4.83312C4.38512 4.71223 4.40191 4.62156 4.43549 4.56112C4.46235 4.50068 4.51944 4.47045 4.60675 4.47045H6.26895ZM7.93155 4.47045C8.01886 4.47045 8.07594 4.50068 8.10281 4.56112C8.13639 4.61485 8.15318 4.6988 8.15318 4.81297C8.15318 4.93386 8.13639 5.02452 8.10281 5.08497C8.07594 5.13869 8.01886 5.16556 7.93155 5.16556H6.26935C6.18204 5.16556 6.12495 5.13869 6.09809 5.08497C6.06451 5.03124 6.04772 4.94729 6.04772 4.83312C6.04772 4.71223 6.06451 4.62156 6.09809 4.56112C6.12495 4.50068 6.18204 4.47045 6.26935 4.47045H7.93155ZM9.59415 4.47045C9.68146 4.47045 9.73854 4.50068 9.76541 4.56112C9.79899 4.61485 9.81578 4.6988 9.81578 4.81297C9.81578 4.93386 9.79899 5.02452 9.76541 5.08497C9.73854 5.13869 9.68146 5.16556 9.59415 5.16556H7.93194C7.84464 5.16556 7.78755 5.13869 7.76069 5.08497C7.72711 5.03124 7.71032 4.94729 7.71032 4.83312C7.71032 4.71223 7.72711 4.62156 7.76069 4.56112C7.78755 4.50068 7.84464 4.47045 7.93194 4.47045H9.59415ZM11.2567 4.47045C11.3441 4.47045 11.4011 4.50068 11.428 4.56112C11.4616 4.61485 11.4784 4.6988 11.4784 4.81297C11.4784 4.93386 11.4616 5.02452 11.428 5.08497C11.4011 5.13869 11.3441 5.16556 11.2567 5.16556H9.59454C9.50723 5.16556 9.45015 5.13869 9.42328 5.08497C9.3897 5.03124 9.37291 4.94729 9.37291 4.83312C9.37291 4.71223 9.3897 4.62156 9.42328 4.56112C9.45015 4.50068 9.50723 4.47045 9.59454 4.47045H11.2567ZM12.1638 4.47045C12.4257 4.47045 12.6339 4.39994 12.7884 4.2589C12.9496 4.11787 13.0302 3.9231 13.0302 3.67461V2.2844H13.685V3.67461C13.685 4.15144 13.5506 4.52082 13.282 4.78275C13.0201 5.03795 12.6608 5.16556 12.2041 5.16556H11.2571C11.1698 5.16556 11.1127 5.13869 11.0859 5.08497C11.0523 5.03124 11.0355 4.94729 11.0355 4.83312C11.0355 4.71223 11.0523 4.62156 11.0859 4.56112C11.1127 4.50068 11.1698 4.47045 11.2571 4.47045H12.1638ZM13.7857 0.994934H12.9798V0.279683H13.7857V0.994934ZM12.5063 0.994934H11.7004V0.279683H12.5063V0.994934ZM5.64177 12.9641C5.64177 13.3267 5.58468 13.6659 5.47051 13.9815C5.35634 14.3039 5.1918 14.5826 4.97689 14.8177C4.76198 15.0595 4.50005 15.2509 4.19112 15.3919C3.8889 15.5329 3.54638 15.6035 3.16357 15.6035H2.56921C1.81702 15.6035 1.23273 15.3718 0.816337 14.9084C0.399946 14.445 0.191751 13.8103 0.191751 13.0044V11.2414H0.836485V12.9842C0.836485 13.273 0.870065 13.5349 0.937225 13.77C1.0111 14.0051 1.12191 14.2065 1.26967 14.3744C1.42413 14.549 1.61554 14.6834 1.84388 14.7774C2.07223 14.8714 2.34758 14.9184 2.66995 14.9184H3.1132C3.42885 14.9184 3.70421 14.8647 3.93927 14.7572C4.17433 14.6565 4.36909 14.5188 4.52356 14.3442C4.68474 14.1696 4.80227 13.9648 4.87615 13.7297C4.95674 13.4946 4.99703 13.2495 4.99703 12.9943V10.2844H5.64177V12.9641ZM3.21394 10.0628H2.36773V9.32738H3.21394V10.0628ZM8.24526 13.1656C8.07064 13.1656 7.90274 13.1421 7.74156 13.095C7.58038 13.0413 7.43598 12.954 7.30838 12.8331C7.18749 12.7122 7.09011 12.5544 7.01624 12.3596C6.94236 12.1582 6.90542 11.9097 6.90542 11.6142V6.9197H7.56023V11.4933C7.56023 11.7754 7.62067 12.0104 7.74156 12.1985C7.86916 12.3798 8.074 12.4705 8.35607 12.4705H8.52733C8.67508 12.4705 8.74896 12.5846 8.74896 12.813C8.74896 13.048 8.67508 13.1656 8.52733 13.1656H8.24526ZM8.69324 12.4705C8.95516 12.4705 9.15328 12.4067 9.2876 12.279C9.42192 12.1514 9.48908 11.9802 9.48908 11.7653V11.3825C9.48908 10.7982 9.63683 10.3415 9.93233 10.0124C10.2346 9.68332 10.6509 9.51878 11.1815 9.51878C11.4569 9.51878 11.6986 9.56243 11.9068 9.64974C12.115 9.73705 12.2863 9.8613 12.4206 10.0225C12.5616 10.1837 12.6657 10.3751 12.7329 10.5967C12.8001 10.8183 12.8336 11.0635 12.8336 11.3321C12.8336 11.9097 12.6825 12.3596 12.3803 12.682C12.0781 13.0044 11.6651 13.1656 11.1412 13.1656C10.8726 13.1656 10.614 13.1152 10.3655 13.0144C10.117 12.907 9.92226 12.7189 9.78123 12.4503C9.72078 12.6048 9.64691 12.729 9.5596 12.823C9.47229 12.9171 9.38162 12.9909 9.2876 13.0447C9.19358 13.0917 9.09284 13.1253 8.98538 13.1454C8.88464 13.1588 8.78726 13.1656 8.69324 13.1656H8.53205C8.44475 13.1656 8.38766 13.1387 8.3608 13.085C8.32722 13.0312 8.31043 12.9473 8.31043 12.8331C8.31043 12.7122 8.32722 12.6216 8.3608 12.5611C8.38766 12.5007 8.44475 12.4705 8.53205 12.4705H8.69324ZM12.1889 11.3925C12.1889 11.0433 12.1117 10.7612 11.9572 10.5463C11.8027 10.3247 11.5375 10.2139 11.1614 10.2139C10.4629 10.2139 10.1137 10.6202 10.1137 11.4328C10.1137 11.7754 10.2077 12.0339 10.3957 12.2085C10.5905 12.3831 10.839 12.4705 11.1412 12.4705C11.4837 12.4705 11.7423 12.3764 11.9169 12.1884C12.0982 12.0003 12.1889 11.7351 12.1889 11.3925Z"
                                                                  fill="currentColor"></path>
                                                        </svg>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="product-footer">
                                            <p class="subtitle">تعداد:</p>
                                            <div class="product-quantity w-100">
                                                <input type="number"
                                                       min="<?php echo e($product_card_item->min_order_quantity); ?>"
                                                       max="<?php echo e($product_card_item->inventory); ?>"
                                                       class="form-control quantity"
                                                       value="<?php echo e($product_card_item->min_order_quantity); ?>"
                                                       form="add-to-cart-form-<?php echo e($product_card_item->id); ?>"
                                                       name="quantity"
                                                       id="add-to-cart-quantity-<?php echo e($product_card_item->id); ?>">
                                            </div>
                                            <a href="#"
                                               class="d-flex align-items-center"
                                               onclick="addToCartProductCard(<?php echo e($product_card_item->id); ?>)">
                                                <span class="add-to-cart-loader-<?php echo e($product_card_item->id); ?>"
                                                      style="display: none;">
                                                    <svg xmlns="http://www.w3.org/2000/svg" style="margin: auto;"
                                                         width="30px" height="30px" viewBox="0 0 100 100"
                                                         preserveAspectRatio="xMidYMid">
                                                    <circle cx="50" cy="50" r="32" stroke-width="8" stroke="#ffa701"
                                                            stroke-dasharray="50.26548245743669 50.26548245743669"
                                                            fill="none" stroke-linecap="round">
                                                        <animateTransform attributeName="transform" type="rotate"
                                                                          repeatCount="indefinite" dur="1s"
                                                                          keyTimes="0;1"
                                                                          values="0 50 50;360 50 50"/>
                                                    </circle>
                                                     </svg>
                                            </span>
                                                <span class="add-to-cart-text-<?php echo e($product_card_item->id); ?>">
                                                     <i class="fi fi-rr-shopping-cart-add add-to-cart-footer-btn ml-3"></i>
                                                </span>
                                            </a>

                                        </div>
                                    </div>

                                </div>
                            </div>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/icworld/core/Modules/Product/Resources/views/frontend/product-cards/style-1.blade.php ENDPATH**/ ?>