<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex">
    <!-- Favicon icon -->
 <link href="/frontend/css/uicons-regular-rounded/css/uicons-regular-rounded.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="/assets/images/fav.png"/>
    {!! SEO::generate() !!}
    <link href="/backend/vendor/jqvmap/css/jqvmap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/backend/vendor/chartist/css/chartist.min.css">
    <!-- Vectormap -->
    <link href="/backend/vendor/jqvmap/css/jqvmap.min.css" rel="stylesheet">
    <link href="/backend/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="/backend/css/style.css" rel="stylesheet">
    <link href="/backend/vendor/owl-carousel/owl.carousel.css" rel="stylesheet">
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    @yield('head')

</head>

<body>

<!--*******************
    Preloader start
********************-->
<div id="preloader">
    <div class="sk-three-bounce">
        <div class="sk-child sk-bounce1"></div>
        <div class="sk-child sk-bounce2"></div>
        <div class="sk-child sk-bounce3"></div>
    </div>
</div>
<!--*******************
    Preloader end
********************-->

<!--**********************************
    Main wrapper start
***********************************-->
<div id="main-wrapper">

    {{--  Navbar Start  --}}
   @include('backend.layouts.partials.navbar')
    {{--  Navbar End  --}}

    {{--  ChatBox Start  --}}
    @include('backend.layouts.partials.chatbox')
    {{--  ChatBox End  --}}

    {{--  Header Start  --}}
    @include('backend.layouts.partials.header')
    {{--  Header End  --}}

    {{--  Sidebar Start  --}}
    @include('backend.layouts.partials.sidebar')
    {{--  Sidebar End  --}}

    {{--  Main Div Start  --}}
    <div class="content-body">
            @yield('content')
    </div>
    {{--  Main Div End  --}}


</div>

{{--scripts--}}
<script src="/backend/vendor/global/global.min.js"></script>
<script src="/backend/vendor/bootstrap-select/dist/js/bootstrap-select.min.js"></script>
<script src="/backend/js/custom.min.js"></script>
<script src="/backend/js/deznav-init.js"></script>
<script src="/backend/vendor/owl-carousel/owl.carousel.js"></script>

<!-- Chart piety plugin files -->
<script src="/backend/vendor/peity/jquery.peity.min.js"></script>


<!-- Alert -->


@include('sweetalert::alert')

<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>


@yield('script')
</body>

</html>
