@component('user::frontend.partials.content')
    <div class="row">
        <div class="col-md-4 mb-3 mt-3 mt-lg-0">
            <div class="single-product">
                <h3>
                    <i class="fi fi-rr-shopping-bag-add align-middle line-height-1"></i>
                    تعداد کل سفارش ها
                </h3>
                <span class="subtitle">{{auth()->user()->orders->where('status' , 'paid')->count()}}
                عدد
                </span>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="single-product">
                <h3>
                    <i class="fi fi-rr-truck-moving align-middle line-height-1"></i>
                    سفارش های ارسال شده
                </h3>
                <span class="subtitle">{{auth()->user()->orders->where('status' , 'posted')->count()}}
                عدد
                </span>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="single-product">
                <h3>
                    <i class="fi fi-rr-clock align-middle line-height-1"></i>
                    سفارش های در حال پردازش
                </h3>
                <span class="subtitle">{{auth()->user()->orders->where('status' , 'preparation')->count()}}
                عدد
                </span>
            </div>
        </div>
    </div>
    <div class="mt-4 single-product table-responsive">
        <h3>آخرین سفارش ها</h3>
        <table class="table table-hover">
            <tr>
                <th>کد سفارش</th>
                <th>مبلغ سفارش</th>
                <th>وضعیت سفارش</th>
                <th>نحوه ارسال</th>
                <th>عملیات</th>
            </tr>
            @if(auth()->user()->orders->count())

                @foreach(auth()->user()->orders->sortDesc()->take(4) as $order)
                    <tr>
                        <td>#{{$order->order_code}}</td>
                        <td>{{number_format($order->price)}}
                        تومان
                        </td>
                        <td>
                            @switch($order->status)
                                @case('paid')
                                <span class="badge bg-success">پرداخت شده</span>
                                @break
                                @case('unpaid')
                                <span class="badge bg-warning">پرداخت نشده</span>
                                @break
                                @case('preparation')
                                <span class="badge bg-primary">در حال پردازش</span>
                                @break
                                @case('canceled')
                                <span class="badge bg-danger">لغو شده</span>
                                @break
                                @case('posted')
                                <span class="badge bg-success">ارسال شده</span>
                                @break
                                @case('received')
                                <span class="badge bg-success">رسیده به مشتری</span>
                                @break
                            @endswitch
                        </td>
                        <td>{{$order->shipping->label}}</td>
                        <td>
                            <a href="{{route('profile.order.show' , $order)}}" class="badge bg-info">
                                جزئیات
                            </a>
                        </td>
                    </tr>
                @endforeach
            @else
                <div class="default-alert mb-3">
                    هنوز هیچ سفارشی ثبت نشده است
                </div>
            @endif
        </table>
    </div>
@endcomponent
