<?php

namespace Modules\User\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Modules\ACL\Entities\Permission;
use Modules\ACL\Entities\Role;
use Modules\Address\Entities\Address;
use Modules\Discount\Entities\Discount;
use Modules\LoginWithCode\Entities\Code;
use Modules\Order\Entities\Order;
use Modules\Product\Entities\Product;

class User extends Authenticatable
{
    use HasFactory;
    use Notifiable;

    protected $fillable = ['name', 'last_name' , 'email' , 'phone', 'is_admin', 'address', 'city', 'postal_code', 'last_seen' , 'password'];


    public function isAdmin()
    {
        foreach (auth()->user()->roles as $role){
            if ($role->id == 3){
                return false;
            }
            return true;
        }
    }

    public function whatIsUserRole()
    {
        foreach ($this->roles as $role){
            if ($role->id == 3){
                return false;
            }
            return true;
        }
    }

    public function getRole()
    {
        foreach ($this->roles as $role){
            return $role->label;
        }
    }

    //relations

    public function roles()
    {
        return $this->belongsToMany(Role::class);
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }

    public function hasRole($roles)
    {
        return !! $roles->intersect($this->roles)->all();
    }

    public function hasPermission($permission)
    {
        return $this->permissions->contains('name' , $permission->name) || $this->hasRole($permission->roles);
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function discounts()
    {
        return $this->hasMany(Discount::class);
    }

    public function addresses()
    {
        return $this->hasMany(Address::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function activeCode()
    {
        return $this->hasMany(Code::class);
    }
}
