<?php

namespace Modules\Product\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Product\Entities\Product;
use Artesaos\SEOTools\Facades\JsonLdMulti;
class ProductController extends Controller
{
    use SEOTools;
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('product::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('product::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show(Product $product)
    {
        $this->seo()
            ->setTitle($product->meta_title)
            ->addImages($product->single_image)
            ->setDescription($product->meta_description);
        $this->seo()->opengraph()->addProperty('type', 'Product');
        $this->seo()->opengraph()->setUrl(asset('product/' . $product->slug));
        $this->seo()->opengraph()->setSiteName('فروشگاه دنیای آی سی');
        $this->seo()->opengraph()->setDescription($product->meta_description);
        if ($product->image) {
            $this->seo()->opengraph()->addImage($product->image);
            JsonLd::addValue('primaryImageOfPage',asset($product->image));
        }
        $this->seo()->jsonLd()->setType('Product');
        $this->seo()->jsonLd()->setDescription($product->meta_description);
        $this->seo()->jsonLd()->addValue('sku' , $product->sku);
        
        SEOMeta::addKeyword($product->meta_keywords);
        $products = Product::all()->except($product->id);
        return view('product::frontend.single-product.content' , compact(['product' , 'products']));
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('product::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
