@component('frontend.layouts.components.page' , ['title' => $post->title])
    @slot('breadcrumb')
        <li class="tm-breadcrumb-item">وبلاگ</li>
        <li class="tm-breadcrumb-item">{{$post->title}}</li>
    @endslot
@section('head')
    <script type="application/ld+json">
        [{
        "@context": "https://schema.org/",
        "@type": "CreativeWorkSeason",
        "name": "{{$post->title}}",
        "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "5",
        "ratingCount": "{{$post->rating_count}}",
        "bestRating": "5",
        "worstRating": "1"
        }}]

    </script>
@stop
<section>
    <div class="container">
        <div class="row mt-5">
            <div class="col-md-9">

                <!--content-->
                <div class="mb-3">
                    <div class="container">
                        <div class="single-product">
                            {!! $post->body !!}
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-3">
                <div class="sticky-sidebar">
                    <img src="{{asset($post->image)}}" alt="" class="br-1 card-shadow">
                    <div class="blog-sidebar-feed mt-4 br-1 single-product">
                        <div class="title-box">
                            <div class="title-wrapper">
                                <h3 class="title title-line">مقالات دیگر</h3>
                            </div>
                        </div>
                        <ul class="blog-feed">
                            @foreach($posts as $post)
                                <li class="feed-item">
                                    <div class="feed-image">
                                        <a href="{{route('post.show' , $post)}}">
                                            @if($post->image)
                                                <img src="{{asset($post->image)}}" alt="">
                                            @else
                                                <img src="/images/other/no-image.jpg" alt="">
                                            @endif
                                        </a>
                                    </div>
                                    <div class="feed-details">
                                        <a href="../blog/blog-details.html">
                                            <h3>{{$post->title}}</h3>
                                        </a>
                                        <p class="subtitle">
                                            تاریخ انتشار:
                                            <a href="#" class="post-date">
                                                {{\Hekmatinasser\Verta\Verta::instance($post->created_at)->formatJalaliDate()}}
                                            </a>
                                        </p>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="{{asset('/js/responsive-sidebar.js')}}"></script>
    <script src="{{asset('/assets/js/comments.js')}}"></script>
@stop
@endcomponent
