@component('backend.layouts.components.main',['title' => 'مدیریت پرداخت ها',
'titleBar'=>true , 'button' => '' , 'route' => 'index'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item active">سفارش شماره {{ $order->id }} </li>
        <li class="breadcrumb-item active">لیست پرداخت‌ها</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست پرداخت‌ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                        <tr>
                            <th>آیدی پرداخت</th>
                            <th>شماره تراکنش</th>
                            <th>وضعیت پرداخت</th>
                            <th>زمان ثبت پرداخت</th>
                        </tr>

                        @foreach($payments as $payment)
                            <tr>
                                <td>{{ $payment->id }}</td>
                                <td>{{ $payment->resnumber }}</td>
                                <td>
                                    @switch($payment->status)
                                        @case('1')
                                        <span class="badge badge-success">پرداخت شده</span>
                                        @break
                                        @case('0')
                                        <span class="badge badge-warning">پرداخت نشده</span>
                                        @break
                                    @endswitch
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($payment->created_at)->formatJalaliDate()}}</td>
                            </tr>
                        @endforeach


                        </tbody>
                    </table>

                </div>
                {{ $payments->appends([ 'search' => request('search') ])->render() }}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
