@component('backend.layouts.components.main',['title' => 'مدیریت سفارشات', 'titleBar'=>true , 'button' => 'افزودن سفارش' , 'route' => 'admin.orders.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">سفارشات</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست سفارشات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                        <tr>
                            <th>کد سفارش</th>
                            <th>نام کاربر</th>
                            <th>هزینه</th>
                            <th>وضعیت</th>
                            <th>شماره پیگیری</th>
                            <th>زمان ثبت</th>
                            <th>ارسال به</th>
                            <th>اقدامات</th>
                        </tr>

                        @foreach($orders as $order)
                            <tr>
                                <td>#{{ $order->order_code }}</td>
                                <td>{{ $order->user->name }}</td>
                                <td>{{number_format($order->price)}}
                                    تومان
                                </td>
                                <td>
                                    @switch($order->status)
                                        @case('paid')
                                        <span class="badge badge-success">پرداخت شده</span>
                                        @break
                                        @case('preparation')
                                        <span class="badge badge-success">در حال پردازش</span>
                                        @break
                                        @case('unpaid')
                                        <span class="badge badge-warning">پرداخت نشده</span>
                                        @break
                                        @case('canceled')
                                        <span class="badge badge-danger">لغو شده</span>
                                        @break
                                        @case('posted')
                                        <span class="badge badge-success">ارسال شده</span>
                                        @break
                                        @case('received')
                                        <span class="badge badge-success">رسیده به مشتری</span>
                                        @break
                                    @endswitch

                                </td>
                                <td>{{ $order->tracking_serial ?? 'ثبت نشده' }}</td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($order->created_at)->formatJalaliDate()}}</td>
                                <td title="{{$order->address->address}}">{{$order->address->city->name}}</td>
                                <td class="d-flex">
                                    {{--                                        <a href="{{ route('admin.orders.show' , $order->id) }}" class="btn btn-sm btn-warning  ml-1">مشاهده جزئیات سفارش</a>--}}
                                    <a href="{{ route('admin.orders.payments' , $order->id) }}" class="btn btn-sm btn-info  ml-1"> پرداخت‌ها</a>
                                    <a href="{{ route('admin.orders.edit' , $order->id) }}" class="btn btn-sm btn-primary  ml-1">جزئیات و ویرایش</a>
                                    <form action="{{ route('admin.orders.destroy' , $order->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">حذف</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach


                        </tbody>
                    </table>
                </div>
                {{ $orders->appends([ 'search' => request('search') ])->render() }}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
