@component('backend.layouts.components.main',['title' => 'المان های صفحه اصلی', 'titleBar'=>true , 'button' => 'افزودن جدید' , 'route' => 'admin.mains.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">المان های صفحه اصلی</li>


    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست المان های صفحه اصلی</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>عنوان</th>
                            <th>دسته بندی</th>
                            <th>دارک مود</th>
                            <th>ترتیب</th>
                            @can('manage-main-page')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($mains as $main)

                            <tr>
                                <td>{{$main->title}}</td>
                                <td>
                                    {{$main->category->name}}
                                </td>
                                <td>
                                    @switch($main->is_dark)
                                        @case(1)
                                        بله
                                        @break
                                        @case(0)
                                        خیر
                                        @break
                                    @endswitch
                                </td>
                                <td>
                                    {{$main->order}}
                                </td>
                                <td>
                                    <form action="{{route('admin.mains.destroy', $main->id)}}" method="post"
                                          id="delete-{{$main->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-main-page')
                                        <a href="{{route('admin.mains.edit', $main->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$main->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$main->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$mains->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
