<?php

namespace Modules\Main\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Category\Entities\Category;
use Modules\Main\Entities\Main;
use Modules\Product\Entities\Product;

class MainController extends Controller
{
    use SEOTools;
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $this->seo()->setTitle('مریدیت صفحه اصلی');
        $mains = Main::simplePaginate(15);
        return view('main::backend.all' , compact('mains'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $categories = Category::where('category_type' , Product::class)->get();
        return view('main::backend.create' , compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $validData = $request->validate([
            'title' => 'required',
            'category_id' => 'required',
            'is_dark' => 'required',
            'order' => 'nullable',
            'icon' => 'nullable',
        ]);
        $main = Main::create($validData);
        alert()->success('موفق' , 'عملیات با موفقیت انجام شد');
        return  back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('main::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Main $main)
    {
        return view('main::backend.edit' , compact('main'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, Main $main)
    {
        $validData = $request->validate([
            'title' => 'required',
            'category_id' => 'required',
            'is_dark' => 'required',
            'order' => 'nullable',
            'icon' => 'nullable',
        ]);
        $main->update($validData);
        alert()->success('موفق' , 'عملیات با موفقیت انجام شد');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(Main $main)
    {
        $main->delete();
        alert()->success('موفق' , 'عملیات با موفقیت انجام شد');
        return back();
    }
}
