<?php

namespace Modules\LoginWithCode\Http\Controllers\Auth;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Validation\Rule;
use Modules\LoginWithCode\Entities\Code;
use Modules\LoginWithCode\Notifications\ActiveCodeNotification;
use Modules\User\Entities\User;


class LoginController extends Controller
{
    use SEOTools;

    public function showLogin()
    {
        $this->seo()
            ->settitle('ورود')
            ->setDescription('صفحه ورود دنیای آی سی');
        if (!auth()->user()) {
            return view('loginwithcode::auth.login');
        }
        return redirect('/');
    }

    public function login(Request $request)
    {
        if ($request->ajax()) {
            $validData = $request->validate([
                'phone' => [
                    'required', 'regex:/^(?:98|\+98|0098|0)?9[0-9]{9}$/',
                    Rule::unique('users' , 'phone')->ignore($request->phone , 'phone')
                ]
            ]);

            $user = User::wherePhone($validData['phone'])->first();
            if (!$user) {
                $user = User::create([
                   'phone' =>  $validData['phone']
                ]);
                $user->roles()->attach(3);
            }
            $code = Code::generateCode($user);
            $request->session()->flash('auth', [
                'user_id' => $user->id,
            ]);
            $user->notify(new ActiveCodeNotification($code, $user->phone));

            return response()->json([
                'success' => true,
                'data' => 'اوکی'
            ]);

        }
    }
}
