@component('backend.layouts.components.main',['title' => 'مدیریت نظرات ها', 'titleBar'=>true , 'button' => '' , 'route' => 'admin.comments.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">نظرات</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست نظرات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام کاربر</th>
                            <th>متن نظر</th>
                            <th>نظر در</th>
                            <th>تاریخ ایجاد</th>
                            <th>وضعیت</th>
                            @can('manage-comments')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($comments as $comment)
                            <tr>
                                <td>
                                    @if($comment->user->whatsUserRole())
                                        <span class="badge badge-pill badge-primary">مدیر</span>
                                    @endif
                                    {{$comment->user->name}}
                                </td>
                                <td>{{\Illuminate\Support\Str::limit($comment->body , 25)}}</td>
                                <td>
                                    {{$comment->commentable->title}}
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($comment->created_at)->formatJalaliDate()}}</td>
                                <td>
                                    @if($comment->status == 0)
                                        <span class="btn btn-xs btn-rounded btn-outline-warning">تایید نشده</span>
                                    @else
                                        <span class="btn btn-xs btn-rounded btn-outline-success">تایید شده</span>
                                    @endif
                                </td>
                                <td>
                                    <form action="{{route('admin.comments.destroy', $comment->id)}}" method="post"
                                          id="delete-{{$comment->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    <form action="{{route('admin.comment.status', $comment->id)}}" method="post"
                                          id="status-{{$comment->id}}">
                                        @method('post')
                                        @csrf
                                    </form>
                                    @can('manage-comments')
                                        <a href="{{route('admin.comments.edit', $comment->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$comment->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$comment->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>

                                        @if($comment->status == 0)
                                            <a role="button"
                                               class="btn btn-success light sharp" title="تایید کردن">
                                                <i class="fa fa-check"
                                                   onclick="document.getElementById('status-{{$comment->id}}').submit()"></i>
                                            </a>
                                        @else
                                            <a role="button"
                                               class="btn btn-warning light sharp" title="عدم تایید">
                                                <i class="fa fa-close"
                                                   onclick="document.getElementById('status-{{$comment->id}}').submit()"></i>
                                            </a>
                                        @endif
                                    @endcan
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$comments->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
