<?php

namespace Modules\Comment\Http\Controllers\Front;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Comment\Entities\Comment;
use Modules\Comment\Notifications\NotifyAdminOfNewComment;

class CommentController extends Controller
{
    public function store(Request $request)
    {
        $validData = $request->validate([
            'commentable_id' => 'required',
            'commentable_type' => 'required',
            'body' => 'required',
            'parent_id' => 'nullable',
        ]);
        $comment = new Comment();
        $comment->body = $validData['body'];
        $comment->commentable_id = $validData['commentable_id'];
        $comment->commentable_type = $validData['commentable_type'];
        $comment->parent_id = $validData['parent_id'];
        $comment->user_id = Auth::id();
        $comment->save();
        if ($comment->user->isAdmin()) {
            $comment->update(['status' => 1]);
        }
        $comment->user->notify(new NotifyAdminOfNewComment());
        return response()->json([
            'status' => 'success'
        ]);
    }
}
