@component('backend.layouts.components.main',['title' => 'افزودن دسته بندی','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن دسته بندی جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات دسته بندی</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.categories-posts.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نام</label>
                            <div class="col-sm-9">
                                <input name="name" type="text"
                                       class="form-control input-rounded @error('name') is-invalid @enderror"
                                       placeholder="نام" value="{{old('name')}}">
                                @error('name')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">لینک</label>
                            <div class="col-sm-9">
                                <input name="slug" type="text"
                                       class="form-control input-rounded @error('slug') is-invalid @enderror"
                                       placeholder="لینک" value="{{old('slug')}}">
                                @error('slug')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دسته بندی مادر</label>
                            <div class="col-sm-9">
                                <div class="dropdown bootstrap-select form-control default-select dropup">
                                    <select name="parent_id"
                                            class="form-control default-select input-rounded @error('parent_id') is-invalid @enderror"
                                            id="sel1" tabindex="-98">
                                        <option value="">ندارد</option>
                                        @include('category::backend.posts.partials.categories-dropdown' ,
                                        [
                                            'categories' => $categories ,
                                            'level' => 0,
                                            'edit' => false
                                            ])
                                    </select>
                                </div>

                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.categories-posts.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد دسته بندی جدید، روی دکمه "ساختن" کلیک کنید.
                </p>
                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-save"></i>
                        ساختن
                    </button>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}

@endcomponent
