<?php

function writers_weekly_pattern_styles()
{
	wp_enqueue_style('writers-weekly-patterns', get_stylesheet_directory_uri() . '/assets/css/patterns.css', array(), filemtime(get_template_directory() . '/assets/css/patterns.css'));
	if (is_admin()) {
		global $pagenow;
		if ('site-editor.php' === $pagenow) {
			// Do not enqueue editor style in site editor
			return;
		}
		wp_enqueue_style('writers-weekly-editor', get_stylesheet_directory_uri() . '/assets/css/editor.css', array(), filemtime(get_template_directory() . '/assets/css/editor.css'));
	}
}
add_action('enqueue_block_assets', 'writers_weekly_pattern_styles');


add_theme_support('wp-block-styles');

// Removes the default wordpress patterns
add_action('init', function () {
	remove_theme_support('core-block-patterns');
});

// Register customer Writers Weekly pattern categories
function writers_weekly_register_block_pattern_categories()
{
	register_block_pattern_category(
		'layout',
		array(
			'label'       => __('Layout', 'writers-weekly'),
			'description' => __('Writers Weekly layout patterns', 'writers-weekly'),
		)
	);
	register_block_pattern_category(
		'Content',
		array(
			'label'       => __('Content', 'writers-weekly'),
			'description' => __('Writers Weekly content patterns', 'writers-weekly'),
		)
	);
	register_block_pattern_category(
		'Contact',
		array(
			'label'       => __('Contact', 'writers-weekly'),
			'description' => __('Writers Weekly contact patterns', 'writers-weekly'),
		)
	);
}

add_action('init', 'writers_weekly_register_block_pattern_categories');



function writers_weekly_column_block_editor() {
    add_editor_style( '/assets/css/block-editor.css' );
		add_editor_style( get_stylesheet_directory_uri() . '/assets/css/block-editor.css' );

}
add_action( 'admin_init', 'writers_weekly_column_block_editor' );
