<?php

/**
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme wordcraft x for publication on WordPress.org
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

require_once get_template_directory() . '/inc/tgm/class-tgm-plugin-activation.php';

add_action('tgmpa_register', 'wordcraft_x_register_required_plugins', 0);
function wordcraft_x_register_required_plugins()
{
	$plugins = array(
		array(
			'name'      => 'Superb Addons',
			'slug'      => 'superb-blocks',
			'required'  => false,
		),
	);

	$config = array(
		'id'           => 'wordcraft-x',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => true,
		'message'      => '',
	);

	tgmpa($plugins, $config);
}


function wordcraft_x_pattern_styles()
{
	wp_enqueue_style('wordcraft-x-patterns', get_template_directory_uri() . '/assets/css/patterns.css', array(), filemtime(get_template_directory() . '/assets/css/patterns.css'));
	if (is_admin()) {
		global $pagenow;
		if ('site-editor.php' === $pagenow) {
			// Do not enqueue editor style in site editor
			return;
		}
		wp_enqueue_style('wordcraft-x-editor', get_template_directory_uri() . '/assets/css/editor.css', array(), filemtime(get_template_directory() . '/assets/css/editor.css'));
	}
}
add_action('enqueue_block_assets', 'wordcraft_x_pattern_styles');


add_theme_support('wp-block-styles');

// Removes the default wordpress patterns
add_action('init', function () {
	remove_theme_support('core-block-patterns');
});

// Register customer WordCraft X pattern categories
function wordcraft_x_register_block_pattern_categories()
{
	register_block_pattern_category(
		'header',
		array(
			'label'       => __('Header', 'wordcraft-x'),
			'description' => __('Header patterns', 'wordcraft-x'),
		)
	);
	register_block_pattern_category(
		'call_to_action',
		array(
			'label'       => __('Call To Action', 'wordcraft-x'),
			'description' => __('Call to action patterns', 'wordcraft-x'),
		)
	);
	register_block_pattern_category(
		'content',
		array(
			'label'       => __('Content', 'wordcraft-x'),
			'description' => __('WordCraft X content patterns', 'wordcraft-x'),
		)
	);
	register_block_pattern_category(
		'teams',
		array(
			'label'       => __('Teams', 'wordcraft-x'),
			'description' => __('Team patterns', 'wordcraft-x'),
		)
	);
	register_block_pattern_category(
		'banners',
		array(
			'label'       => __('Banners', 'wordcraft-x'),
			'description' => __('Banner patterns', 'wordcraft-x'),
		)
	);
	register_block_pattern_category(
		'layouts',
		array(
			'label'       => __('Layouts', 'wordcraft-x'),
			'description' => __('layout patterns', 'wordcraft-x'),
		)
	);
	register_block_pattern_category(
		'testimonials',
		array(
			'label'       => __('Testimonial', 'wordcraft-x'),
			'description' => __('Testimonial and review patterns', 'wordcraft-x'),
		)
	);

}

add_action('init', 'wordcraft_x_register_block_pattern_categories');




// Initialize information content
require_once trailingslashit(get_template_directory()) . 'inc/vendor/autoload.php';

use SuperbThemesThemeInformationContent\ThemeEntryPoint;
add_action("init", function () {
ThemeEntryPoint::init([
    'type' => 'block', // block / classic
    'theme_url' => 'https://superbthemes.com/wordcraft-x/',
    'demo_url' => 'https://superbthemes.com/demo/wordcraft-x/',
    'features' => array(
    	array(
    		'title' => __("Theme Designer", "wordcraft-x"),
    		'icon' => "lego-duotone.webp",
    		'description' => __("Choose from over 300 designs for footers, headers, landing pages & all other theme parts.", "wordcraft-x")
    	),
    	   	array(
    		'title' => __("Editor Enhancements", "wordcraft-x"),
    		'icon' => "1-1.png",
    		'description' => __("Enhanced editor experience, grid systems, improved block control and much more.", "wordcraft-x")
    	),
    	array(
    		'title' => __("Custom CSS", "wordcraft-x"),
    		'icon' => "2-1.png",
    		'description' => __("Add custom CSS with syntax highlight, custom display settings, and minified output.", "wordcraft-x")
    	),
    	array(
    		'title' => __("Animations", "wordcraft-x"),
    		'icon' => "wave-triangle-duotone.webp",
    		'description' => __("Animate any element on your website with one click. Choose from over 50+ animations.", "wordcraft-x")
    	),
    	array(
    		'title' => __("WooCommerce Integration", "wordcraft-x"),
    		'icon' => "shopping-cart-duotone.webp",
    		'description' => __("Choose from over 100 unique WooCommerce designs for your e-commerce store.", "wordcraft-x")
    	),
    	array(
    		'title' => __("Responsive Controls", "wordcraft-x"),
    		'icon' => "arrows-out-line-horizontal-duotone.webp",
    		'description' => __("Make any theme mobile-friendly with SuperbThemes responsive controls.", "wordcraft-x")
    	)
    )
]);
});