<?php
/**
 * Title: Main Banner
 * Slug: wens-wander/main-banner
 * Categories: wens-wander
 *
 * @package wens-wander
 * @since 1.0.0
 */

?>

<!-- wp:group {"metadata":{"name":"banner"},"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/main-banner.jpg","id":890,"dimRatio":50,"customOverlayColor":"#313041","isUserOverlayColor":true,"focalPoint":{"x":0.4,"y":0.94},"minHeight":800,"minHeightUnit":"px","sizeSlug":"large","align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull" style="min-height:800px"><img class="wp-block-cover__image-background wp-image-890 size-large" alt="" src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/main-banner.jpg" style="object-position:40% 94%" data-object-fit="cover" data-object-position="40% 94%"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim" style="background-color:#313041"></span><div class="wp-block-cover__inner-container"><!-- wp:group {"align":"wide","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"style":{"spacing":{"blockGap":"16px"}},"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"left","level":5,"style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontSize":"32px","fontStyle":"normal","fontWeight":"100"}},"textColor":"base"} -->
<h5 class="wp-block-heading has-text-align-left has-base-color has-text-color has-link-color" style="font-size:32px;font-style:normal;font-weight:100"><?php echo esc_html__( 'Explore The World', 'wens-wander' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"left","level":1,"align":"wide"} -->
<h1 class="wp-block-heading alignwide has-text-align-left"><?php echo esc_html__( 'Bespoke Journeys, First Class', 'wens-wander' ); ?> </h1>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base"} -->
<p class="has-text-align-left has-base-color has-text-color has-link-color"><?php echo esc_html__( 'Whether you are craving beaches, mountains, or cultural escapes, we bring the world to your fingertips.<br> Explore top-rated travel packages, flight deals, and expert travel guides all in one place.', 'wens-wander' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"30px"}},"border":{"radius":"0px"}},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons" style="border-radius:0px;margin-top:30px"><!-- wp:button {"textColor":"base","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"border":{"radius":"0px"}}} -->
<div class="wp-block-button"><a class="wp-block-button__link has-base-color has-text-color has-link-color wp-element-button" href="#" style="border-radius:0px"><?php echo esc_html__( 'Know More', 'wens-wander' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->