<?php
	if ( is_front_page() || is_home() ) {
	if (get_theme_mod('vt_feminine_featured_slider', 1) == 1) :
	$featured_cat = esc_html(get_theme_mod( 'vt_feminine_featured_cat' ));
	$get_featured_posts = get_theme_mod('vt_feminine_featured_id');
	$number = esc_html(get_theme_mod( 'vt_feminine_featured_slider_slides' ));
		
	if($get_featured_posts) {
		$featured_posts = explode(',', $get_featured_posts);
		$args = array( 'showposts' => $number, 'post_type' => array('post', 'page'), 'post__in' => $featured_posts, 'orderby' => 'post__in' );
	} else {
		$args = array( 'cat' => $featured_cat, 'showposts' => $number );
	}				
?>			

<?php $feat_query = new WP_Query( $args ); ?>		
<?php if ($feat_query->have_posts()) : ?>
				
	<div class="featured-area owl-theme">
		<div class="owl-carousel slider">

		<?php while ($feat_query->have_posts()) :
			$feat_query->the_post();
			$image_featured = get_the_post_thumbnail_url( get_the_ID(), 'full' );
		?>
			<div class="slide-item post" style="background-image: url(<?php echo esc_url($image_featured); ?>);">
                <div class="slide-item-text">
        			<div class="post-text-inner">
					
						<?php if (get_theme_mod('vt_feminine_category_slider', 1) == 1) : ?>
                          <p class="post-cats"><?php vt_feminine_first_category(); ?></p>
						<?php endif; ?>
						
            			<h3 class="post-title">
							<a href="<?php echo esc_url(get_permalink()); ?>"><?php the_title_attribute(); ?></a>
						</h3> 
						
						<div class="post-meta"><?php vt_feminine_posted_on() ?></div>
						
						<?php if (get_theme_mod('vt_feminine_read_more_slider', 1) == 1) : ?>
						<a class="feat-more" href="<?php the_permalink() ?>"><?php echo wp_kses_post( get_theme_mod( 'slider-cont-reading', __( 'Continue Reading', 'vt-feminine' ) ) ); ?></a>
						<?php endif; ?>
						
						<div class="slide-content-bg"></div>
						
                    </div>
        		</div>
			</div>
		<?php endwhile; ?>
        </div>
    </div><!-- .featured-slider-->
<?php
	endif;
	/* Restore original Post Data */
	wp_reset_postdata();
	
	endif;
	}
?>