/**
 *	@package feminine
 *	@since 1.0
 */
(function($){
	"use strict";	
    $(document).ready(function() {
            
        if ( $('.post').length ) { $('.post').fitVids(); }
            
        if ( $('select').length ) { $('select').chosen(); }

		// Toggle vtmenu
		$(".nav-toggle").on("click", function(){
			$(this).toggleClass("active");
			$(".vtmenu").slideToggle();
		});
		
		/* Full Slider */
		var owl = $('.slider');
		owl.owlCarousel({
			items: 1,
			lazyLoad: true,
			loop: true,
			margin: 0,
			dots: false,
			autoplay: true,
			smartSpeed: 3000,
			autoplayTimeout:7300,
			nav: false,
			navText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
			pagination: false,
			autoHeight: true,
			responsive: {
				0: {
					nav: false,
					mouseDrag: false,
					touchDrag: false,
					items: 1
				},
				600: {
					nav: false,
					mouseDrag: false,
					touchDrag: false,
					items: 1
				},
				1000: {
					//nav: true,
					nav: false,
					mouseDrag: true,
					touchDrag: true,
					items: 1
				}
			}
			
		});
		
		// Search in header.
		jQuery(document).on('click','.toggle-search', function(e){
			e.preventDefault();
			jQuery('.wrapper-search-top-bar').slideToggle();
			$( '.wrapper-search-top-bar input.search-field' ).focus();
		});
		
		// Fitvids
		$(".container").fitVids();
			
		// Scroll to top
		var offset = 250;
		var duration = 1000;
		jQuery(window).scroll(function() {
			if (jQuery(this).scrollTop() > offset) {
				jQuery('#backtotop').fadeIn(duration);
			} else {
				jQuery('#backtotop').fadeOut(duration);
			}
		});

		jQuery('#backtotop').click(function(event) {
			event.preventDefault();
			jQuery('html, body').animate({scrollTop: 0}, duration);
			return false;
		})
		
    });
})(jQuery);