<?php

/*-----------------------------------------------------------------------------------*/
/* Enqueu scripts */
/*-----------------------------------------------------------------------------------*/   

if (!function_exists('vagando_enqueue_scripts')) {

	function vagando_enqueue_scripts() {
        
		wp_deregister_style('google-fonts');
		wp_deregister_style('avventura-lite-style' );
		
        wp_enqueue_style('avventura-lite-parent-style' , get_template_directory_uri() . '/style.css' ); 
		wp_enqueue_style('vagando-style' , get_stylesheet_directory_uri() . '/style.css' ); 

        wp_enqueue_style(
			'vagando-' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')),
			get_stylesheet_directory_uri() . '/assets/skins/' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')) . '.css',
			array( 'vagando-style' ),
			'1.0.0'
		); 
		
        $googleFontsArgs = array(
			'family' =>    str_replace('|', '%7C', vagando_google_font_args()),
			'subset' =>    'latin,latin-ext'
		);

		wp_enqueue_style('google-fonts', add_query_arg ( $googleFontsArgs, "https://fonts.googleapis.com/css" ), array(), '1.0.0' );

		wp_enqueue_script(
			'jquery-marquee',
			get_stylesheet_directory_uri() . '/assets/js/jquery.marquee.js',
			array('jquery'),
			'2.3.4',
			TRUE
		);

		wp_enqueue_script(
			'vagando-template',
			get_stylesheet_directory_uri() . '/assets/js/template.js',
			array('jquery'),
			'1.0.0', 
			TRUE
		);

	}
	
	add_action( 'wp_enqueue_scripts', 'vagando_enqueue_scripts', 999);

}

/*-----------------------------------------------------------------------------------*/
/* Replace hooks */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('vagando_replace_hooks')) {

	function vagando_replace_hooks() {
	
		remove_action('avventura_lite_mobile_menu', 'avventura_lite_mobile_menu_function');
		remove_action('avventura_lite_top_sidebar', 'avventura_lite_top_sidebar_function');
		remove_action('avventura_lite_slick_slider', 'avventura_lite_slick_slider_function');
		remove_action('avventura_lite_thumbnail', 'avventura_lite_thumbnail_function');
		remove_action('avventura_lite_before_content', 'avventura_lite_before_content_function' );

		remove_action( 'avventura_lite_default_format', 'avventura_lite_default_format_function' );
		remove_action( 'avventura_lite_image_format', 'avventura_lite_image_format_function' );
		remove_action( 'avventura_lite_page_format', 'avventura_lite_page_format_function' );

    }
	
	add_action('init','vagando_replace_hooks', 9999);

}

/*-----------------------------------------------------------------------------------*/
/* Replace hooks */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('vagando_mobile_menu_function')) {

	function vagando_mobile_menu_function() {

?>

        <div id="sidebar-wrapper">
            
            <div id="scroll-sidebar" class="clearfix">

                <div class="wrap">

                	<a class="mobile-navigation" href="#modal-sidebar">
                		<i class="fa fa-times open"></i>
                	</a>
                	
	                <div class="mobilemenu-box">
					
                        <nav id="mobilemenu">
                        
                            <?php
                                            
                                wp_nav_menu(
                                    
                                    array(
                                        'theme_location' => 'main-menu', 
                                        'container' => 'false',
                                        'depth' => 3
                                    )
                                
                                );
                            
                            ?>
                        
                        </nav> 
					
                    </div>

					<div class="post-article">
			
						<div class="copyright">
								
							<p>
							
								<?php 
								
									echo esc_html__('Copyright ','vagando') . esc_html(get_bloginfo("name")) . " " . date("Y");
									echo ' | <a href="' . esc_url('https://www.themeinprogress.com/') . '" target="_blank">' . sprintf(esc_html__('Theme by %s', 'vagando'), 'ThemeinProgress') . '</a>';
									echo ' | <a href="' . esc_url('http://wordpress.org/') . '" title="' . esc_attr__('A Semantic Personal Publishing Platform', 'vagando') . '" rel="generator">' . sprintf(esc_html__('Proudly powered by %s', 'vagando'), 'WordPress') . '</a>';
		
								?> 
								
							</p>
									
						</div>
			
					</div>

            	</div>

            </div>
        
        </div>
        
<?php
	
	}

	add_action( 'vagando_mobile_menu', 'vagando_mobile_menu_function' );

}


/*-----------------------------------------------------------------------------------*/
/* Get categories */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('vagando_get_categories')) {

	function vagando_get_categories($first_element = 'none') {

		if ( $first_element == 'none') {
			$return['none'] = esc_attr__( 'None','vagando');
		} else {
			$return['all'] = esc_attr__( 'All categories','vagando');
		}

		$args = array(
			'taxonomy' => 'category',
			'hide_empty' => true,
		);


		foreach ( get_terms($args) as $cat) {
			$return[$cat->term_id] = $cat->name;
		}
		
		return $return;

	}

}

/*-----------------------------------------------------------------------------------*/
/* Customize register */
/*-----------------------------------------------------------------------------------*/   

if (!function_exists('vagando_customize_register')) {

	function vagando_customize_register( $wp_customize ) {

		$wp_customize->remove_section( 'slideshow_section');

		$wp_customize->remove_setting( 'avventura_lite_sticky_header');
		$wp_customize->remove_control( 'avventura_lite_sticky_header');

		$wp_customize->remove_setting( 'avventura_lite_header_layout');
		$wp_customize->remove_control( 'avventura_lite_header_layout');

		$wp_customize->remove_setting( 'avventura_lite_post_icon');
		$wp_customize->remove_control( 'avventura_lite_post_icon');

		$wp_customize->remove_setting( 'avventura_lite_view_category_title');
		$wp_customize->remove_control( 'avventura_lite_view_category_title');

		$wp_customize->remove_setting( 'avventura_lite_view_searched_item');
		$wp_customize->remove_control( 'avventura_lite_view_searched_item');

		$wp_customize->remove_setting( 'avventura_lite_view_readmore');
		$wp_customize->remove_control( 'avventura_lite_view_readmore');

		$wp_customize->remove_control( 'avventura_lite_menu_font_weight');
		$wp_customize->remove_control( 'avventura_lite_titles_font_weight');

		/**
		* Site identity > Site identity > Hide Tagline option
		*/

		$wp_customize->add_setting( 'vagando_hide_tagline', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_hide_tagline', array(
			'label' => esc_html__( 'Hide Tagline','vagando'),
			'section' => 'title_tagline',
			'type' => 'checkbox',
		));

		/* Typography panel > Google Fonts section
		========================================================================== */

		$wp_customize->add_section( 'vagando_fonts', array(
			'title' => esc_html__( 'Google Fonts','vagando'),
			'panel' => 'typography_panel',
			'priority' => 9,
			'description' => esc_html__('From this section you can select one of the 17 Google Fonts included with Vagando','vagando'),
		));

		/**
		 * Typography panel > Google Fonts section > Site font option
		 */

		$wp_customize->add_setting( 'vagando_body_font_family', array(
			'default' => 'Josefin+Sans:100,100italic,300,300italic,400,400italic,600,600italic,700,700italic',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_body_font_family' , array(
			'priority' => 9,
			'type' => 'select',
			'section' => 'vagando_fonts',
			'label' => esc_html__('Site font','vagando'),
			'description' => esc_html__('Choose the font for your website.','vagando'),
			'choices' => vagando_google_fonts(),
		));
        
		/**
		 * Typography panel > Menu section > Menu weight
		 */

        $wp_customize->add_control( 'avventura_lite_menu_font_weight' , array(
			'type' => 'select',
			'section' => 'menu_section',
			'label' => esc_html__('Menu weight.', 'vagando'),
			'description' => esc_html__('Choose a font weight for the menu', 'vagando'),
            'choices' => array(
                '100' => esc_html__( '100','vagando'),
                '300' => esc_html__( '300','vagando'),
                '400' => esc_html__( '400','vagando'),
                '600' => esc_html__( '600','vagando'),
                '700' => esc_html__( '700','vagando'),
            ),
		));
        
		/**
		 * Typography panel > Menu section > Titles weight
		 */

        $wp_customize->add_control( 'avventura_lite_titles_font_weight' , array(
			'type' => 'select',
			'section' => 'headlines_section',
			'label' => esc_html__('Titles weight', 'vagando'),
			'description' => esc_html__('Choose a font weight for the titles.', 'vagando'),
            'choices' => array(
                '100' => esc_html__( '100','vagando'),
                '300' => esc_html__( '300','vagando'),
                '400' => esc_html__( '400','vagando'),
                '600' => esc_html__( '600','vagando'),
                '700' => esc_html__( '700','vagando'),
            ),
		));

		/* Main settings panel > Featured posts section
		========================================================================== */

		$wp_customize->add_section('vagando_featured_posts_section', array(
			'title' => esc_html__( 'Featured posts', 'vagando' ),
			'description' => esc_html__( 'From this section you can manage the featured posts on the homepage', 'vagando' ),
			'panel' => 'general_panel',
			'priority' => 10,

		));

		/**
		* Main settings panel > Featured posts section > Enable featured posts option
		*/

		$wp_customize->add_setting( 'vagando_enable_featured_posts', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh',
		));
		
		$wp_customize->add_control( 'vagando_enable_featured_posts', array(
			'label' => esc_html__( 'Enable featured posts','vagando'),
			'description' => esc_html__( 'Would you like to enable the featured posts on the homepage?', 'vagando' ),
			'section' => 'vagando_featured_posts_section',
			'type' => 'checkbox',
		));

		/**
		* Main settings panel > Featured posts section > Featured posts only on the first page of pagination option
		*/

		$wp_customize->add_setting( 'vagando_enable_featured_posts_only_first_page_pagination', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh',
		));
		
		$wp_customize->add_control( 'vagando_enable_featured_posts_only_first_page_pagination', array(
			'label' => esc_html__( 'Featured posts only on the first page of pagination','vagando'),
			'description' => esc_html__( 'Would you like to show the featured posts only on the first page of pagination on your homepage? Enable this option to display the featured posts exclusively on the first page.', 'vagando' ),
			'section' => 'vagando_featured_posts_section',
			'type' => 'checkbox',
		));

	   /**
	   * Main settings panel > Featured posts section > Main column - Label option
		*/

		$wp_customize->add_setting( 'vagando_main_column_label', array(
			'default' => esc_html__('Recent','vagando'),
			'sanitize_callback' => 'sanitize_text_field',
		));
 
		$wp_customize->add_control( 'vagando_main_column_label' , array(
			'type' => 'text',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Main column &raquo; Label','vagando'),
			'description' => esc_html__('Please insert the label of the main column','vagando'),
		));

	   /**
		* Main settings panel > Featured posts section > Main column - Post category option
		*/

		$wp_customize->add_setting( 'vagando_main_column_posts_category', array(
			'default' => 'all',
			'sanitize_callback' => 'vagando_select_sanitize',
		));
 
		$wp_customize->add_control( 'vagando_main_column_posts_category' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Main column &raquo; Post category','vagando'),
			'description' => esc_html__('Please select the category for featured posts in the main column.','vagando'),
			'choices'  => vagando_get_categories('all'),
		));

		/**
		* Main settings panel > Featured posts section > Main column - Sort articles option
		*/

		$wp_customize->add_setting( 'vagando_main_column_posts_orderby', array(
			'default' => 'date',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_main_column_posts_orderby' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Main column &raquo; Sort articles','vagando'),
			'description' => esc_html__('How you want to order the articles in the main column?','vagando'),
			'choices' => array (
				'ID' => esc_html__( 'ID','vagando'),
				'author' => esc_html__( 'Author','vagando'),
				'title' => esc_html__( 'Post title','vagando'),
				'date' => esc_html__( 'Date','vagando'),
				'comment_count' => esc_html__( 'Number of comments','vagando'),
			),
		));

		/**
		* Main settings panel > Featured posts section > Main column - Order articles option
		*/

		$wp_customize->add_setting( 'vagando_main_column_posts_sort_order', array(
			'default' => 'desc',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_main_column_posts_sort_order' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Main column &raquo; Order articles','vagando'),
			'description' => esc_html__('Select whether to sort articles in ascending (oldest to newest) or descending (newest to oldest) order in the main column','vagando'),
			'choices' => array (
				'asc' => esc_html__( 'Ascending','vagando'),
				'desc' => esc_html__( 'Descending','vagando'),
			),
		));

		/**
		 * Main settings panel > Featured posts section > Main column - Post limit option
		 */
 
		$wp_customize->add_setting( 'vagando_main_column_posts_limit', array(
			'sanitize_callback' => 'vagando_limit_sanitize',
			'default' => 5,
		));
 
		$wp_customize->add_control( 'vagando_main_column_posts_limit' , array(
			'type' => 'number',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Main column &raquo; Post limit','vagando'),
			'description' => esc_html__('Please set the limit of articles in the main column.','vagando'),
			'input_attrs' => array(
				'min' => 1,
			),
		));

		/**
		* Main settings panel > Featured posts section > Main column - Slider transition option
		*/

		$wp_customize->add_setting( 'vagando_main_column_slider_transition', array(
			'default' => 'fade',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_main_column_slider_transition' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Main column &raquo; Slider transition','vagando'),
			'description' => esc_html__('Select the type of transition effect for the slider in the main column','vagando'),
			'choices' => array (
				'fade' => esc_html__( 'Fade', 'vagando' ),
				'slide' => esc_html__( 'Slide', 'vagando' ),
			),
		));

	   /**
	   * Main settings panel > Featured posts section > Main column - Post author label option
		*/

		$wp_customize->add_setting( 'vagando_featured_posts_post_author_label', array(
			'default' => esc_html__('By','vagando'),
			'sanitize_callback' => 'sanitize_text_field',
		));
 
		$wp_customize->add_control( 'vagando_featured_posts_post_author_label' , array(
			'type' => 'text',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Main column &raquo; Post author label','vagando'),
			'description' => esc_html__('Insert the label of post author','vagando'),
		));

	   /**
	   * Main settings panel > Featured posts section > Secondary column - Label option
		*/

		$wp_customize->add_setting( 'vagando_secondary_column_label', array(
			'default' => esc_html__('Oldest post','vagando'),
			'sanitize_callback' => 'sanitize_text_field',
		));
 
		$wp_customize->add_control( 'vagando_secondary_column_label' , array(
			'type' => 'text',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Secondary column &raquo; Label','vagando'),
			'description' => esc_html__('Please insert the label of the secondary column','vagando'),
		));

	   /**
		* Main settings panel > Featured posts section > Secondary column - Post category option
		*/

		$wp_customize->add_setting( 'vagando_secondary_column_posts_category', array(
			'default' => 'all',
			'sanitize_callback' => 'vagando_select_sanitize',
		));
 
		$wp_customize->add_control( 'vagando_secondary_column_posts_category' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Secondary column &raquo; Post category','vagando'),
			'description' => esc_html__('Please select the category for featured posts in the secondary column.','vagando'),
			'choices'  => vagando_get_categories('all'),
		));

		/**
		* Main settings panel > Featured posts section > Secondary column - Sort articles option
		*/

		$wp_customize->add_setting( 'vagando_secondary_column_posts_orderby', array(
			'default' => 'date',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_secondary_column_posts_orderby' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Secondary column &raquo; Sort articles','vagando'),
			'description' => esc_html__('How you want to order the articles in the secondary column?','vagando'),
			'choices' => array (
				'ID' => esc_html__( 'ID','vagando'),
				'author' => esc_html__( 'Author','vagando'),
				'title' => esc_html__( 'Post title','vagando'),
				'date' => esc_html__( 'Date','vagando'),
				'comment_count' => esc_html__( 'Number of comments','vagando'),
			),
		));

		/**
		* Main settings panel > Featured posts section > Secondary column - Order articles option
		*/

		$wp_customize->add_setting( 'vagando_secondary_column_posts_sort_order', array(
			'default' => 'asc',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_secondary_column_posts_sort_order' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Secondary column &raquo; Order articles','vagando'),
			'description' => esc_html__('Select whether to sort articles in ascending (oldest to newest) or descending (newest to oldest) order in the secondary column','vagando'),
			'choices' => array (
				'asc' => esc_html__( 'Ascending','vagando'),
				'desc' => esc_html__( 'Descending','vagando'),
			),
		));

		/**
		 * Main settings panel > Featured posts section > Secondary column - Post limit option
		 */
 
		$wp_customize->add_setting( 'vagando_secondary_column_posts_limit', array(
			'sanitize_callback' => 'vagando_limit_sanitize',
			'default' => 8,
		));
 
		$wp_customize->add_control( 'vagando_secondary_column_posts_limit' , array(
			'type' => 'number',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Secondary column &raquo; Post limit','vagando'),
			'description' => esc_html__('Please set the limit of articles in the secondary column','vagando'),
			'input_attrs' => array(
				'min' => 1,
			),
		));

	   /**
	   * Main settings panel > Featured posts section > Side column - Label option
		*/

		$wp_customize->add_setting( 'vagando_side_column_label', array(
			'default' => esc_html__('Popular','vagando'),
			'sanitize_callback' => 'sanitize_text_field',
		));
 
		$wp_customize->add_control( 'vagando_side_column_label' , array(
			'type' => 'text',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Side column &raquo; Label','vagando'),
			'description' => esc_html__('Please insert the label of side column','vagando'),
		));

	   /**
		* Main settings panel > Featured posts section > Side column - Post category option
		*/

		$wp_customize->add_setting( 'vagando_side_column_posts_category', array(
			'default' => 'all',
			'sanitize_callback' => 'vagando_select_sanitize',
		));
 
		$wp_customize->add_control( 'vagando_side_column_posts_category' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Side column &raquo; Post category','vagando'),
			'description' => esc_html__('Please select the category for featured posts in the side column','vagando'),
			'choices'  => vagando_get_categories('all'),
		));

		/**
		* Main settings panel > Featured posts section > Side column - Sort articles option
		*/

		$wp_customize->add_setting( 'vagando_side_column_posts_orderby', array(
			'default' => 'comment_count',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_side_column_posts_orderby' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Side column &raquo; Sort articles','vagando'),
			'description' => esc_html__('How you want to order the articles in the side column?','vagando'),
			'choices' => array (
				'ID' => esc_html__( 'ID','vagando'),
				'author' => esc_html__( 'Author','vagando'),
				'title' => esc_html__( 'Post title','vagando'),
				'date' => esc_html__( 'Date','vagando'),
				'comment_count' => esc_html__( 'Number of comments','vagando'),
			),
		));

		/**
		* Main settings panel > Featured posts section > Side column - Order articles option
		*/

		$wp_customize->add_setting( 'vagando_side_column_posts_sort_order', array(
			'default' => 'desc',
			'sanitize_callback' => 'vagando_select_sanitize',
		));

		$wp_customize->add_control( 'vagando_side_column_posts_sort_order' , array(
			'type' => 'select',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Side column &raquo; Order articles','vagando'),
			'description' => esc_html__('Select whether to sort articles in ascending (oldest to newest) or descending (newest to oldest) order in the side column','vagando'),
			'choices' => array (
				'asc' => esc_html__( 'Ascending','vagando'),
				'desc' => esc_html__( 'Descending','vagando'),
			),
		));

		/**
		 * Main settings panel > Featured posts section > Side column - Post limit option
		 */
 
		$wp_customize->add_setting( 'vagando_side_column_posts_limit', array(
			'sanitize_callback' => 'vagando_limit_sanitize',
			'default' => 8,
		));
 
		$wp_customize->add_control( 'vagando_side_column_posts_limit' , array(
			'type' => 'number',
			'section' => 'vagando_featured_posts_section',
			'label' => esc_html__('Side column &raquo; Post limit','vagando'),
			'description' => esc_html__('Please set the limit of articles in the side column','vagando'),
			'input_attrs' => array(
				'min' => 1,
			),
		));

		/* Main settings panel > Vagando newsticker section
		========================================================================== */

		$wp_customize->add_section('vagando_newsticker', array(
			'title' => esc_html__( 'Newsticker', 'vagando' ),
			'description' => esc_html__('From this section you can manage the news ticker','vagando'),
			'panel' => 'general_panel',
			'priority' => 9,
		));

	   /**
		* Main settings panel > Vagando newsticker section > Enable news ticker option
		*/

		$wp_customize->add_setting( 'vagando_enable_news_ticker', array(
			'default' => 'on',
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));

		$wp_customize->add_control( 'vagando_enable_news_ticker' , array(
			'type' => 'checkbox',
			'section' => 'vagando_newsticker',
			'label' => esc_html__('News ticker','vagando'),
			'description' => esc_html__('Do you want to enable the news ticker?','vagando'),
		));

	   /**
	   * Main settings panel > Vagando newsticker section > News ticker title option
		*/

		$wp_customize->add_setting( 'vagando_news_ticker_title', array(
			'default' => esc_html__('HOT','vagando'),
			'sanitize_callback' => 'sanitize_text_field',
		));
 
		$wp_customize->add_control( 'vagando_news_ticker_title' , array(
			'type' => 'text',
			'section' => 'vagando_newsticker',
			'label' => esc_html__('News ticker title','vagando'),
			'description' => esc_html__('Insert the title for the news ticker','vagando'),
		));
 
	   /**
		* Main settings panel > Vagando newsticker section > News ticker category option
		*/

		$wp_customize->add_setting( 'vagando_news_ticker_category', array(
			'default' => 'all',
			 'sanitize_callback' => 'vagando_select_sanitize',
		));
 
		$wp_customize->add_control( 'vagando_news_ticker_category' , array(
			'type' => 'select',
			'section' => 'vagando_newsticker',
			'label' => esc_html__('News ticker category','vagando'),
			'description' => esc_html__('Please select the category of the news ticker.','vagando'),
			'choices'  => vagando_get_categories('all'),
		));
 
		/**
		* Main settings panel > Vagando newsticker section > News ticker order option
		 */
 
		$wp_customize->add_setting( 'vagando_news_ticker_order', array(
			'default' => 'date',
			'sanitize_callback' => 'vagando_select_sanitize',
		));
 
		$wp_customize->add_control( 'vagando_news_ticker_order' , array(
			'type' => 'select',
			'section' => 'vagando_newsticker',
			'label' => esc_html__('News ticker order by','vagando'),
			'description' => esc_html__('How you want to order the articles?.','vagando'),
			'choices'  => array (
				'title' => esc_html__( 'Post title','vagando'),
				'rand' => esc_html__( 'Randomly','vagando'),
				'comment_count' => esc_html__( 'Comment count','vagando'),
				'date' => esc_html__( 'Post date','vagando'),
			),
		));
 
		/**
		* Main settings panel > Vagando newsticker section > News ticker sort order option
		 */
 
		$wp_customize->add_setting( 'vagando_news_ticker_sort_order', array(
			'default' => 'desc',
			'sanitize_callback' => 'vagando_select_sanitize',
		));
 
		$wp_customize->add_control( 'vagando_news_ticker_sort_order' , array(
			'type' => 'select',
			'section' => 'vagando_newsticker',
			'label' => esc_html__('News ticker sort order','vagando'),
			'description' => esc_html__('Select the order of the articles.','vagando'),
			'choices'  => array (
				'asc' => esc_html__( 'Ascending','vagando'),
				'desc' => esc_html__( 'Descending','vagando'),
			),
		));
 
		/**
		 * Main settings panel > Vagando newsticker section > News ticker limit option
		 */
 
		$wp_customize->add_setting( 'vagando_news_ticker_limit', array(
			'sanitize_callback' => 'vagando_limit_sanitize',
			'default' => 5,
		));
 
		$wp_customize->add_control( 'vagando_news_ticker_limit' , array(
			'type' => 'number',
			'section' => 'vagando_newsticker',
			'label' => esc_html__('News ticker post limit','vagando'),
			'description' => esc_html__('Please set the max items for the news ticker.','vagando'),
			'input_attrs' => array('min' => 1)
		));

		/**
		* Main settings panel > General settings section > Enable post category option
		*/

		$wp_customize->add_setting( 'vagando_view_category_title', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_view_category_title', array(
			'priority' => 1,
			'label' => esc_html__( 'Category title','vagando'),
			'description' => esc_html__('Do you want to view the category title?','vagando'),
			'section' => 'settings_section',
			'type' => 'checkbox',
		));

		/**
		* Main settings panel > General settings section > Enable post category option
		*/

		$wp_customize->add_setting( 'vagando_view_searched_item', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_view_searched_item', array(
			'priority' => 1,
			'label' => esc_html__( 'Searched item','vagando'),
			'description' => esc_html__('Do you want to view the searched item?','vagando'),
			'section' => 'settings_section',
			'type' => 'checkbox',
		));

		/* Main settings panel > Single post section
		========================================================================== */

		$wp_customize->add_section('vagando_post_single_post_section', array(
			'title' => esc_html__( 'Single post', 'vagando' ),
			'description' => esc_html__( 'From this section, you can manage (show or hide) various elements within individual posts, such as the category, publication date, author, etc.', 'vagando' ),
			'panel' => 'general_panel',
			'priority' => 13,

		));

		/**
		* Main settings panel > Single post section > Enable post category option
		*/

		$wp_customize->add_setting( 'vagando_enable_post_category', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_enable_post_category', array(
			'label' => esc_html__( 'Show post category','vagando'),
			'section' => 'vagando_post_single_post_section',
			'type' => 'checkbox',
		));

		/**
		* Main settings panel > Single post section > Enable post icon option
		*/

		$wp_customize->add_setting( 'vagando_enable_post_icon', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_enable_post_icon', array(
			'label' => esc_html__( 'Show post icon','vagando'),
			'section' => 'vagando_post_single_post_section',
			'type' => 'checkbox',
		));

		/**
		* Main settings panel > Single post section > Enable post date option
		*/

		$wp_customize->add_setting( 'vagando_enable_post_date', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_enable_post_date', array(
			'label' => esc_html__( 'Show post date','vagando'),
			'section' => 'vagando_post_single_post_section',
			'type' => 'checkbox',
		));

		/**
		* Main settings panel > Single post section > Enable post author option
		*/

		$wp_customize->add_setting( 'vagando_enable_post_author', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_enable_post_author', array(
			'label' => esc_html__( 'Show author','vagando'),
			'section' => 'vagando_post_single_post_section',
			'type' => 'checkbox',
		));

		/**
		* Main settings panel > Single post section > Post author label
		 */

		$wp_customize->add_setting( 'vagando_post_author_label', array(
			'default' => esc_html__(' by ','vagando'),
			'sanitize_callback' => 'sanitize_text_field',
		));

		$wp_customize->add_control( 'vagando_post_author_label' , array(
			'type' => 'text',
			'section' => 'vagando_post_single_post_section',
			'label' => esc_html__('Post author label','vagando'),
			'description' => esc_html__( 'Replace the default label','vagando'),
		));

		/**
		* Main settings panel > Single post section > Enable related posts option
		*/

		$wp_customize->add_setting( 'vagando_enable_related_posts', array(
			'default' => true,
			'sanitize_callback' => 'vagando_checkbox_sanize',
			'transport'  => 'refresh'
		));
		
		$wp_customize->add_control( 'vagando_enable_related_posts', array(
			'label' => esc_html__( 'Show related posts','vagando'),
			'section' => 'vagando_post_single_post_section',
			'type' => 'checkbox',
		));

		/**
		* Main settings panel > Single post section > Related posts label
		 */

		 $wp_customize->add_setting( 'vagando_related_posts_label', array(
			'default' => esc_html__('You may also like','vagando'),
			'sanitize_callback' => 'sanitize_text_field',
		));

		$wp_customize->add_control( 'vagando_related_posts_label' , array(
			'type' => 'text',
			'section' => 'vagando_post_single_post_section',
			'label' => esc_html__('Related posts section label','vagando'),
			'description' => esc_html__( 'Replace the default label','vagando'),
		));

		function vagando_select_sanitize ($value, $setting) {
		
			global $wp_customize;
					
			$control = $wp_customize->get_control( $setting->id );
				 
			if ( array_key_exists( $value, $control->choices ) ) {
					
				return $value;
					
			} else {
					
				return $setting->default;
					
			}
			
		}

		function vagando_checkbox_sanize( $input ) {
			return $input ? true : false;
		}

		function vagando_limit_sanitize($value, $setting) {

			global $wp_customize;

			$getSetting = $wp_customize->get_setting($setting->id);
			$newValue = ($value <= 0) ? $getSetting->default : absint($value);
			return $newValue;

		}

	}
	
	add_action( 'customize_register', 'vagando_customize_register', 11 );

}

/*-----------------------------------------------------------------------------------*/
/* Theme setup */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('vagando_theme_setup')) {

	function vagando_theme_setup() {

		load_child_theme_textdomain( 'vagando', get_stylesheet_directory() . '/languages' );
		
        require_once( trailingslashit( get_stylesheet_directory() ) . 'core/functions/function-style.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/functions/google-fonts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/featured-posts/horizontal-featured-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/featured-posts/vertical-featured-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/featured-posts/vertical-list-featured-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post/related-post.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/media.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/post-icon.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/before-content.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post-formats/default-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post-formats/image-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/post-formats/page-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/related-posts.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/templates/top-section.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/sidebars/top-sidebar.php' );

		add_image_size( 'vagando_featured_post_large', 549, 410, true );
		add_image_size( 'vagando_featured_post_small', 89, 89, true );

    }

	add_action( 'after_setup_theme', 'vagando_theme_setup', 999);

}

/*-----------------------------------------------------------------------------------*/
/* MESSAGGERO IS ARCHIVE */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('vagando_is_archive')) {

	function vagando_is_archive() {

		if ( 
			is_category() ||
			is_tag() ||
			is_author() ||
			is_year() ||
			is_month()
			
		) {
		
			return true;
		
		} else {
		
			return false;
		
		}

	}

}

/*-----------------------------------------------------------------------------------*/
/* Theme setup */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('vagando_widgets_init')) {

	function vagando_widgets_init() {

		unregister_sidebar('avventura-lite-scroll-widget-area');

	}

	add_action( 'widgets_init', 'vagando_widgets_init', 999);

}

/*-----------------------------------------------------------------------------------*/
/* Function to check if the searchform.php file is loaded inside a sidebar area */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'vagando_is_sidebar_area' ) ) {

	function vagando_is_sidebar_area() {

		$result = false;

		$activeSidebars = array(
			'avventura_lite_side_sidebar',
			'avventura_lite_top_sidebar',
			'avventura_lite_header_sidebar',
			'avventura_lite_bottom_sidebar',
			'avventura_lite_ooter_sidebar'
		);

		if ( in_array(current_filter(), $activeSidebars) ) {
			$result = true;
		}

		return $result;

	}

}

?>