<?php 

/**
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('vagando_before_content_function')) {

	function vagando_before_content_function( $type = "post" ) {
		
		if ( 
			$type == "post" &&
			(
				avventura_lite_setting('vagando_enable_post_category', true) == true ||
				avventura_lite_setting('vagando_enable_post_icon', true) == true
			)
		) :
			
			echo '<div class="post-meta">';

				if ( avventura_lite_setting('vagando_enable_post_category', true) == true ) : 

					echo '<span class="post-meta-category">'; 
						the_category(' . '); 
					echo '</span>';

				endif;

				if ( avventura_lite_setting('vagando_enable_post_icon', true) == true ) : 
					
					echo '<span class="post-meta-icon">';
						echo vagando_post_icon();
					echo '</span>';
				
				endif;

			echo '</div>';


		endif;
		
		if ( ! avventura_lite_is_single() ) {

			do_action('avventura_lite_get_title', 'blog' ); 

		} else {

			if ( !avventura_lite_is_woocommerce_active('is_cart') ) :
	
				if ( avventura_lite_is_single() && !is_page_template() ) :
							 
					do_action('avventura_lite_get_title', 'single');
							
				else :
					
					do_action('avventura_lite_get_title', 'blog'); 
							 
				endif;
	
			endif;

		}

		if ( 
			$type == "post" &&
			(
				avventura_lite_setting('vagando_enable_post_date', true) == true ||
				avventura_lite_setting('vagando_enable_post_author', true) == true
			)
		) :

			echo '<div class="post-meta">';

				if ( avventura_lite_setting('vagando_enable_post_date', true) == true ) : 

					echo '<span class="post-meta-date">';

						echo esc_html__('On ','vagando');
						echo get_the_date();

					echo '</span>';

				endif;

				if ( avventura_lite_setting('vagando_enable_post_author', true) == true ) : 

					echo '<span class="post-meta-author">';

						echo esc_html(avventura_lite_setting('vagando_post_author_label', __( ' by ', 'vagando' )));
						echo get_the_author_posts_link();
					
					echo '</span>';

				endif;

			echo '</div>';

		endif;

	} 
	
	add_action( 'avventura_lite_before_content', 'vagando_before_content_function' );

}

?>