<?php
function softura_css() {
	$parent_style = 'spintech-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'softura-style', get_stylesheet_uri(), array( $parent_style ));
}
add_action( 'wp_enqueue_scripts', 'softura_css',999);

/**
 * Import Options From Parent Theme
 *
 */
function softura_parent_theme_options() {
	$spintech_mods = get_option( 'theme_mods_spintech' );
	if ( ! empty( $spintech_mods ) ) {
		foreach ( $spintech_mods as $spintech_mod_k => $spintech_mod_v ) {
			set_theme_mod( $spintech_mod_k, $spintech_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'softura_parent_theme_options' );

require( get_stylesheet_directory() . '/inc/customizer/customizer-pro/class-customize.php');