<?php
$page_ids = array_filter(array(
	get_theme_mod('slider_page1'),
	get_theme_mod('slider_page2'),
	get_theme_mod('slider_page3'),
	get_theme_mod('slider_page4'),
));

// ✅ Slider settings
$data_banner = array(
	'effect'        => 'fade',
	'fadeEffect'    => array( 'crossFade' => true ),
	'slidesPerView' => 1,
	'centeredSlides'=> true,
	'keyboard'      => array( 'enabled' => true ),
	'spaceBetween'  => 20,
	'pagination'    => array(
		'el'        => '.swiper-pagination',
		'clickable' => true,
	),
	'navigation'    => array(
		'nextEl' => '.swiper-button-next',
		'prevEl' => '.swiper-button-prev',
	),
	'autoplay' => array(
		'delay'                => 9000,
		'disableOnInteraction' => false,
	),
);
?>

<section class="siaracorporatebusiness-section-banner-wrapper boxed as-carousel style_1 em-animate-content">
	<div class="siaracorporatebusiness-section-banner">
		<div class="row g-1">
			<div class="col-lg-12">
				<div class="siaracorporatebusiness-banner-wrapper siaracorporatebusiness-swiper-outer-bullets swiper"
					 data-banner='<?php echo esc_attr( json_encode( $data_banner ) ); ?>'>
					<div class="siaracorporatebusiness-banner swiper-wrapper">

						<?php if ( ! empty( $page_ids ) ) :
							$args = array(
								'post_type'      => 'page',
								'post__in'       => $page_ids,
								'orderby'        => 'post__in',
								'posts_per_page' => count($page_ids),
							);
							$banner_query = new WP_Query( $args );
							if ( $banner_query->have_posts() ) :
								while ( $banner_query->have_posts() ) : $banner_query->the_post(); ?>
									<div class="swiper-slide">
										<div class="banner-block-wrapper img-animate-zoom">
											<div class="banner-image siaracorporatebusiness-rounded-img">
												<a href="<?php the_permalink(); ?>">
													<?php the_post_thumbnail( 'siaracorporatebusiness-cover-image', array(
														'alt' => the_title_attribute( array( 'echo' => false ) ),
													) ); ?>
												</a>
											</div>
											<div class="banner-caption">
												<div class="banner-caption-inner">
													<h3 class="banner-title no-margin">
														<a href="<?php the_permalink(); ?>" class="text-decoration-none"><?php the_title(); ?></a>
													</h3>
													<div class="banner-excerpt hide-on-mobile hide-on-tablet">
														<p class="no-margin"><?php echo wp_trim_words( get_the_excerpt(), 20, '&hellip;' ); ?></p>
													</div>
													<div class="banner-read-more">
														<a href="<?php the_permalink(); ?>" class="siaracorporatebusiness-btn-link text-decoration-none style_3">
															<?php esc_html_e( 'Read More', 'siara-corporate-business' ); ?>
														</a>
													</div>
												</div>
											</div>
										</div>
									</div>
								<?php endwhile; wp_reset_postdata();
							endif;
						else :
							// Static default slider items
							$default_slides = array(
								array(
									'image' => get_template_directory_uri() . '/assets/images/slider-default1.jpg',
									'title' => 'Welcome to Our Business',
									'desc'  => 'We provide smart solutions for growing your business.',
									'link'  => '#',
								),
								array(
									'image' => get_template_directory_uri() . '/assets/images/slider-default2.jpg',
									'title' => 'We Build Your Ideas',
									'desc'  => 'Creative and professional solutions tailored for you.',
									'link'  => '#',
								),
							);

							foreach ( $default_slides as $slide ) : ?>
								<div class="swiper-slide">
									<div class="banner-block-wrapper img-animate-zoom">
										<div class="banner-image siaracorporatebusiness-rounded-img">
											<a href="<?php echo esc_url( $slide['link'] ); ?>">
												<img src="<?php echo esc_url( $slide['image'] ); ?>" alt="<?php echo esc_attr( $slide['title'] ); ?>" />
											</a>
										</div>
										<div class="banner-caption">
											<div class="banner-caption-inner">
												<h3 class="banner-title no-margin">
													<a href="<?php echo esc_url( $slide['link'] ); ?>" class="text-decoration-none"><?php echo esc_html( $slide['title'] ); ?></a>
												</h3>
												<div class="banner-excerpt hide-on-mobile hide-on-tablet">
													<p class="no-margin"><?php echo esc_html( $slide['desc'] ); ?></p>
												</div>
												<div class="banner-read-more">
													<a href="<?php echo esc_url( $slide['link'] ); ?>" class="siaracorporatebusiness-btn-link text-decoration-none style_3">
														<?php esc_html_e( 'Read More', 'siara-corporate-business' ); ?>
													</a>
												</div>
											</div>
										</div>
									</div>
								</div>
							<?php endforeach;
						endif; ?>
					</div>

					<div class="swiper-pagination"></div>
					<div class="swiper-button-next"></div>
					<div class="swiper-button-prev"></div>
				</div>
			</div>
		</div>
	</div>
</section>
