<section class="siaracorporatebusiness-section-services-wrapper">
    <div class="uf-wrapper">

        <?php
        $services_heading_text  = get_theme_mod( 'services_heading_text','Services Offer' );
        ?>
        <div class="heading">
            <h3><?php echo esc_html( $services_heading_text ); ?></h3>
        </div>

        <?php
        $service_page_ids = array();
        for ( $i = 1; $i <= 6; $i++ ) {
            $page_id = get_theme_mod( 'services_page' . $i, 0 );
            if ( $page_id ) {
                $service_page_ids[] = absint( $page_id );
            }
        }

        $container_class = '';
        $column_class    = 'col-lg-4 col-md-6 col-sm-12';
        ?>

        <div class="siaracorporatebusiness-section-services<?php echo esc_attr( $container_class ); ?>">
            <div class="row g-4">

                <?php if ( ! empty( $service_page_ids ) ) :

                    foreach ( $service_page_ids as $page_id ) :
                        $service_page = get_post( $page_id );

                        if ( $service_page && 'page' === $service_page->post_type && 'publish' === $service_page->post_status ) :
                            $title     = esc_html( $service_page->post_title );
                            $permalink = get_permalink( $service_page );
                            $excerpt   = has_excerpt( $service_page ) ? wp_kses_post( $service_page->post_excerpt ) : wp_trim_words( apply_filters( 'the_content', $service_page->post_content ), 25, '&hellip;' );

                            $current_box_index = array_search( $page_id, $service_page_ids ) + 1;
                            $icon_class = get_theme_mod( 'services_page' . $current_box_index . '_icon', '' );
                            ?>
                            <div class="<?php echo esc_attr( $column_class ); ?>">
                                <div class="service-box-item text-center">
                                    <?php if ( ! empty( $icon_class ) ) : ?>
                                        <div class="service-icon">
                                            <i class="<?php echo esc_attr( $icon_class ); ?>"></i>
                                        </div>
                                    <?php elseif ( has_post_thumbnail( $service_page ) ) : ?>
                                        <div class="service-thumbnail">
                                            <a href="<?php echo esc_url( $permalink ); ?>">
                                                <?php echo get_the_post_thumbnail( $service_page, 'siaracorporatebusiness-medium-img', array( 'alt' => esc_attr( $title ) ) ); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>

                                    <div class="service-info">
                                        <h3 class="service-title">
                                            <a href="<?php echo esc_url( $permalink ); ?>"><?php echo $title; ?></a>
                                        </h3>
                                        <div class="service-excerpt">
                                            <p><?php echo $excerpt; ?></p>
                                        </div>
                                        <div class="service-readmore">
                                            <a href="<?php echo esc_url( $permalink ); ?>" class="siaracorporatebusiness-btn-link">
                                                <?php esc_html_e( 'Learn More', 'siara-corporate-business' ); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        endif;
                    endforeach;

                    else :
                        // ✅ Static fallback services
                        $default_services = array(
                            array(
                                'title'   => 'Web Development',
                                'desc'    => 'Professional website development for businesses and startups.',
                                'image'   => get_template_directory_uri() . '/assets/images/services-default1.png',
                                'link'    => '#',
                            ),
                            array(
                                'title'   => 'Digital Marketing',
                                'desc'    => 'Boost your brand’s visibility and engagement online.',
                                'image'   => get_template_directory_uri() . '/assets/images/services-default2.png',
                                'link'    => '#',
                            ),
                            array(
                                'title'   => 'Graphic Design',
                                'desc'    => 'Creative and custom designs for all your branding needs.',
                                'image'   => get_template_directory_uri() . '/assets/images/services-default3.png',
                                'link'    => '#',
                            ),
                        );

                        foreach ( $default_services as $service ) : ?>
                            <div class="<?php echo esc_attr( $column_class ); ?>">
                                <div class="service-box-item text-center">
                                    <div class="service-thumbnail">
                                        <a href="<?php echo esc_url( $service['link'] ); ?>">
                                            <img src="<?php echo esc_url( $service['image'] ); ?>" alt="<?php echo esc_attr( $service['title'] ); ?>" />
                                        </a>
                                    </div>
                                    <div class="service-info">
                                        <h3 class="service-title">
                                            <a href="<?php echo esc_url( $service['link'] ); ?>"><?php echo esc_html( $service['title'] ); ?></a>
                                        </h3>
                                        <div class="service-excerpt">
                                            <p><?php echo esc_html( $service['desc'] ); ?></p>
                                        </div>
                                        <div class="service-readmore">
                                            <a href="<?php echo esc_url( $service['link'] ); ?>" class="siaracorporatebusiness-btn-link">
                                                <?php esc_html_e( 'Learn More', 'siara-corporate-business' ); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach;
                    endif;

                ?>
            </div>
        </div>
    </div>
</section>
