<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Siaracorporatebusiness_Ads_Code extends Siaracorporatebusiness_Widget_Base {
	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'siaracorporatebusiness_ads_code_widget';
		$this->widget_description = __( 'Advertisements or codes widget.', 'siara-corporate-business' );
		$this->widget_id          = 'siaracorporatebusiness_ads_code_widget';
		$this->widget_name        = __( 'Siaracorporatebusiness: Ads Code', 'siara-corporate-business' );
		$this->settings           = array(
			'ads_code'                  => array(
				'type'  => 'custom_html',
				'label' => __( 'Ads Code', 'siara-corporate-business' ),
				'rows'  => 10,
			),
			'align'                     => array(
				'type'    => 'select',
				'label'   => __( 'Alignment', 'siara-corporate-business' ),
				'desc'    => __( 'If you are using adsense code and it is not showing up, select "None" for the alignment.', 'siara-corporate-business' ),
				'options' => array(
					'unset'   => __( 'None', 'siara-corporate-business' ),
					'left'    => __( 'Left', 'siara-corporate-business' ),
					'center'  => __( 'Center', 'siara-corporate-business' ),
					'right'   => __( 'Right', 'siara-corporate-business' ),
					'stretch' => __( 'Stretch', 'siara-corporate-business' ),
				),
				'std'     => 'center',
			),
			'widget_visibility_heading' => array(
				'type'  => 'heading',
				'label' => __( 'Visibility Settings', 'siara-corporate-business' ),
			),
			'hide_on_desktop'           => array(
				'type'  => 'checkbox',
				'label' => __( 'Hide on Desktop', 'siara-corporate-business' ),
				'std'   => false,
			),
			'hide_on_tablet'            => array(
				'type'  => 'checkbox',
				'label' => __( 'Hide on Tablet', 'siara-corporate-business' ),
				'std'   => false,
			),
			'hide_on_mobile'            => array(
				'type'  => 'checkbox',
				'label' => __( 'Hide on Mobile', 'siara-corporate-business' ),
				'std'   => false,
			),
		);

		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		$before_widget = $args['before_widget'];
		$after_widget  = $args['after_widget'];

		echo wp_kses_post( $before_widget );

		$ad_class = '';
		if ( isset( $instance['hide_on_desktop'] ) && $instance['hide_on_desktop'] ) {
			$ad_class .= ' hide-on-desktop';
		}
		if ( isset( $instance['hide_on_tablet'] ) && $instance['hide_on_tablet'] ) {
			$ad_class .= ' hide-on-tablet';
		}
		if ( isset( $instance['hide_on_mobile'] ) && $instance['hide_on_mobile'] ) {
			$ad_class .= ' hide-on-mobile';
		}

		do_action( 'siaracorporatebusiness_before_ads_code' );

		if ( isset( $instance['ads_code'] ) && $instance['ads_code'] ) {
			$content = apply_filters( 'widget_custom_html_content', $instance['ads_code'], $instance, $this );
			?>
			<div class="siaracorporatebusiness-ads-code-widget<?php echo esc_attr( $ad_class ); ?>" style="justify-items:<?php echo esc_attr( $instance['align'] ); ?>;" >
				<?php echo $content; ?>
			</div>
			<?php
		}

		do_action( 'siaracorporatebusiness_after_ads_code' );

		echo wp_kses_post( $after_widget );

		echo ob_get_clean();
	}
}
