<?php

/*Header Options*/
$wp_customize->add_section(
	'header_options',
	array(
		'title' => __( 'Header Options', 'siara-corporate-business' ),
		'panel' => 'header_options_panel',
	)
);

// header topbar text.
$wp_customize->add_setting(
	'header_topbar_text',
	array(
		'default'           => $theme_options_defaults['header_topbar_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_topbar_text',
	array(
		'label'           => __( 'Topbar Text', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 11,
	)
);

// header topbar_joinwithus text.
$wp_customize->add_setting(
	'header_topbar_joinwithus_text',
	array(
		'default'           => $theme_options_defaults['header_topbar_joinwithus_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_topbar_joinwithus_text',
	array(
		'label'           => __( 'Join With Us Text', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 12,
	)
);

// header topbar_joinwithus link.
$wp_customize->add_setting(
	'header_topbar_joinwithus_link',
	array(
		'default'           => $theme_options_defaults['header_topbar_joinwithus_link'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_topbar_joinwithus_link',
	array(
		'label'           => __( 'Join With Us Link', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 13,
	)
);


// header phone number.
$wp_customize->add_setting(
	'header_phone_number',
	array(
		'default'           => $theme_options_defaults['header_phone_number'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_phone_number',
	array(
		'label'           => __( 'Phone Number', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 14,
	)
);

// header mail text.
$wp_customize->add_setting(
	'header_mail_text',
	array(
		'default'           => $theme_options_defaults['header_mail_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_mail_text',
	array(
		'label'           => __( 'Mail Text', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 15,
	)
);

// header time text.
$wp_customize->add_setting(
	'header_time_text',
	array(
		'default'           => $theme_options_defaults['header_time_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_time_text',
	array(
		'label'           => __( 'Time Text', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 16,
	)
);

// header socialicon_fb link.
$wp_customize->add_setting(
	'header_socialicon_fb_link',
	array(
		'default'           => $theme_options_defaults['header_socialicon_fb_link'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_socialicon_fb_link',
	array(
		'label'           => __( 'Facebook Link', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 17,
	)
);

// header socialicon_insta link.
$wp_customize->add_setting(
	'header_socialicon_insta_link',
	array(
		'default'           => $theme_options_defaults['header_socialicon_insta_link'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_socialicon_insta_link',
	array(
		'label'           => __( 'Instagram Link', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 18,
	)
);

// header socialicon_telegram link.
$wp_customize->add_setting(
	'header_socialicon_telegram_link',
	array(
		'default'           => $theme_options_defaults['header_socialicon_telegram_link'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_socialicon_telegram_link',
	array(
		'label'           => __( 'Telegram Link', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 19,
	)
);

// header button text.
$wp_customize->add_setting(
	'header_button_text',
	array(
		'default'           => $theme_options_defaults['header_button_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_button_text',
	array(
		'label'           => __( 'Button Text', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 20,
	)
);

// header button link.
$wp_customize->add_setting(
	'header_button_link',
	array(
		'default'           => $theme_options_defaults['header_button_link'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_button_link',
	array(
		'label'           => __( 'Button Link', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'priority'        => 20,
	)
);

/* Header Background Color*/
$wp_customize->add_setting(
	'header_bg_color',
	array(
		'default'           => $theme_options_defaults['header_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'header_bg_color',
		array(
			'label'    => __( 'Header Background Color', 'siara-corporate-business' ),
			'section'  => 'header_options',
			'type'     => 'color',
			'priority' => 21,
		)
	)
);

/* Header Style */
$wp_customize->add_setting(
	'header_style',
	array(
		'default'           => $theme_options_defaults['header_style'],
		'sanitize_callback' => 'siaracorporatebusiness_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Siaracorporatebusiness_Radio_Image_Control(
		$wp_customize,
		'header_style',
		array(
			'label'       => __( 'Header Style', 'siara-corporate-business' ),
			'description' => __( 'Some options related to header may not show in the front-end based on header style chosen.', 'siara-corporate-business' ),
			'section'     => 'header_options',
			'choices'     => siaracorporatebusiness_get_header_layouts(),
			'priority'    => 20,
		)
	)
);

/*Ad Banner Image*/
$wp_customize->add_setting(
	'ad_banner_image',
	array(
		'default'           => $theme_options_defaults['ad_banner_image'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new WP_Customize_Media_Control(
		$wp_customize,
		'ad_banner_image',
		array(
			'label'           => __( 'Ad Banner Image', 'siara-corporate-business' ),
			'description'     => __( 'Use image with 16:9 aspect ratio for best results', 'siara-corporate-business' ),
			'section'         => 'header_options',
			'active_callback' => 'siaracorporatebusiness_is_ad_banner_enabled',
			'priority'        => 30,
			'mime_type'       => 'image',
		)
	)
);

/*Ad Banner Link.*/
$wp_customize->add_setting(
	'ad_banner_link',
	array(
		'default'           => $theme_options_defaults['ad_banner_link'],
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
	'ad_banner_link',
	array(
		'label'           => __( 'Ad Banner Link', 'siara-corporate-business' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'description'     => __( 'Leave empty if you don\'t want the image to have a link', 'siara-corporate-business' ),
		'active_callback' => 'siaracorporatebusiness_is_ad_banner_enabled',
		'priority'        => 40,
	)
);

/*Centered Logo*/
$wp_customize->add_setting(
	'center_logo',
	array(
		'default'           => $theme_options_defaults['center_logo'],
		'sanitize_callback' => 'siaracorporatebusiness_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Siaracorporatebusiness_Toggle_Control(
		$wp_customize,
		'center_logo',
		array(
			'label'           => __( 'Centered Logo', 'siara-corporate-business' ),
			'description'     => __( 'Center the logo if no ad banner is present', 'siara-corporate-business' ),
			'section'         => 'header_options',
			'active_callback' => 'siaracorporatebusiness_is_ad_banner_enabled',
			'priority'        => 50,
		)
	)
);

// Padding Top.
$wp_customize->add_setting(
	'header_padding_desktop_top',
	array(
		'sanitize_callback' => 'siaracorporatebusiness_sanitize_empty_value_number',
	)
);
$wp_customize->add_control(
	'header_padding_desktop_top',
	array(
		'label'       => __( 'Header Padding Top', 'siara-corporate-business' ),
		'description' => __( 'Enter numeric value in px. For example, 20. Do not enter "px", only enter numeric value.', 'siara-corporate-business' ),
		'section'     => 'header_options',
		'type'        => 'text',
		'priority'    => 60,
	)
);

// Padding Bottom.
$wp_customize->add_setting(
	'header_padding_desktop_bottom',
	array(
		'sanitize_callback' => 'siaracorporatebusiness_sanitize_empty_value_number',
	)
);
$wp_customize->add_control(
	'header_padding_desktop_bottom',
	array(
		'label'       => __( 'Header Padding Bottom', 'siara-corporate-business' ),
		'description' => __( 'Enter numeric value in px. For example, 20. Do not enter "px", only enter numeric value.', 'siara-corporate-business' ),
		'section'     => 'header_options',
		'type'        => 'text',
		'priority'    => 60,
	)
);