<?php
// Add Home Page services Section.
$wp_customize->add_section(
	'home_services_options',
	array(
		'title' => __( 'Services Options', 'siara-corporate-business' ),
		'panel' => 'theme_home_option_panel',
	)
);

// Enable services Section.
$wp_customize->add_setting(
	'enable_services',
	array(
		'default'           => $theme_options_defaults['enable_services'],
		'sanitize_callback' => 'siaracorporatebusiness_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Siaracorporatebusiness_Toggle_Control(
		$wp_customize,
		'enable_services',
		array(
			'label'    => __( 'Enable Home services', 'siara-corporate-business' ),
			'section'  => 'home_services_options',
			'priority' => 10,
		)
	)
);


// Services heading Text.
$wp_customize->add_setting(
	'services_heading_text',
	array(
		'default'           => $theme_options_defaults['services_heading_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'services_heading_text',
	array(
		'label'           => __( 'Services Heading Text', 'siara-corporate-business' ),
		'section'         => 'home_services_options',
		'type'            => 'text',
		'active_callback' => 'siaracorporatebusiness_is_services_posts_enabled',
		'priority'        => 11,
	)
);

// Services Page 1.
$wp_customize->add_setting(
    'services_page1',
    array(
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Siaracorporatebusiness_Dropdown_Pages_Control( // Using your new Page control!
        $wp_customize,
        'services_page1',
        array(
            'label'           => __( 'Choose a Service Page 1', 'siara-corporate-business' ),
            'section'         => 'home_services_options', // Ensure this matches your section ID
            'active_callback' => 'siaracorporatebusiness_is_services_posts_enabled',
            'priority'        => 12,
        )
    )
);

// Services Page 2.
$wp_customize->add_setting(
    'services_page2',
    array(
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Siaracorporatebusiness_Dropdown_Pages_Control( // Using your new Page control!
        $wp_customize,
        'services_page2',
        array(
            'label'           => __( 'Choose a Service Page 2', 'siara-corporate-business' ),
            'section'         => 'home_services_options', // Ensure this matches your section ID
            'active_callback' => 'siaracorporatebusiness_is_services_posts_enabled',
            'priority'        => 13,
        )
    )
);

// Services Page 3.
$wp_customize->add_setting(
    'services_page3',
    array(
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Siaracorporatebusiness_Dropdown_Pages_Control( // Using your new Page control!
        $wp_customize,
        'services_page3',
        array(
            'label'           => __( 'Choose a Service Page 3', 'siara-corporate-business' ),
            'section'         => 'home_services_options', // Ensure this matches your section ID
            'active_callback' => 'siaracorporatebusiness_is_services_posts_enabled',
            'priority'        => 14,
        )
    )
);
