<?php

$class  = siaracorporatebusiness_get_sticky_menu();
?>
<div class="site-header-row-wrapper siaracorporatebusiness-primary-bar-row<?php echo esc_attr( $class ); ?>">
	<div class="primary-bar-row-wrapper">
		<div class="topbar-wrapper">
			<div class="uf-wrapper">
				<?php
					$header_topbar_text  = get_theme_mod( 'header_topbar_text','Our Mission: Empower Innovation, Drive Excellence, Enhance Growth.' );
					$header_topbar_joinwithus_text  = get_theme_mod( 'header_topbar_joinwithus_text','Join With Us' );
					$header_topbar_joinwithus_link  = get_theme_mod( 'header_topbar_joinwithus_link','#' );
					$header_phone_number  = get_theme_mod( 'header_phone_number','+123-456-789' );
					$header_mail_text  = get_theme_mod( 'header_mail_text','asdf@gmail.com' );
					$header_time_text  = get_theme_mod( 'header_time_text','Mon–Sat, 10Am–7Pm' );
					$header_socialicon_fb_link  = get_theme_mod( 'header_socialicon_fb_link','#' );
					$header_socialicon_insta_link  = get_theme_mod( 'header_socialicon_insta_link','#' );
					$header_socialicon_telegram_link  = get_theme_mod( 'header_socialicon_telegram_link','#' );
					$header_button_text  = get_theme_mod( 'header_button_text','Get Stared' );
					$header_button_link  = get_theme_mod( 'header_button_link','#' );
				?>

				<div class="topbar">
					<div class="topbar-container">
						<!-- Left Side -->
						<div class="topbar-left-section">
							<div class="topbar-left-box">
								<!-- Topbar text and time in a row -->
								<div class="topbar-text-row">
									<span class="topbar-text">
										<?php echo esc_html( $header_topbar_text ); ?>
									</span>
									<span class="topbar-time">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#ffffff" viewBox="0 0 256 256"><path d="M128,24A104,104,0,1,0,232,128,104.11,104.11,0,0,0,128,24Zm56,112H128a8,8,0,0,1-8-8V72a8,8,0,0,1,16,0v48h48a8,8,0,0,1,0,16Z"></path></svg>
										<?php echo esc_html( $header_time_text ); ?>
									</span>
								</div>
								<!-- Social icons below the text row -->
								<div class="social-icons">
									<a href="<?php echo esc_url( $header_socialicon_fb_link ); ?>">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
											<path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951"/>
										</svg>
									</a>
									<a href="<?php echo esc_url( $header_socialicon_insta_link ); ?>">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-instagram" viewBox="0 0 16 16">
											<path d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.9 3.9 0 0 0-1.417.923A3.9 3.9 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.9 3.9 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.9 3.9 0 0 0-.923-1.417A3.9 3.9 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599s.453.546.598.92c.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.5 2.5 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.5 2.5 0 0 1-.92-.598 2.5 2.5 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233s.008-2.388.046-3.231c.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92s.546-.453.92-.598c.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92m-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217m0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334"/>
										</svg>
									</a>
									<a href="<?php echo esc_url( $header_socialicon_telegram_link ); ?>">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-telegram" viewBox="0 0 16 16">
											<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.287 5.906q-1.168.486-4.666 2.01-.567.225-.595.442c-.03.243.275.339.69.47l.175.055c.408.133.958.288 1.243.294q.39.01.868-.32 3.269-2.206 3.374-2.23c.05-.012.12-.026.166.016s.042.12.037.141c-.03.129-1.227 1.241-1.846 1.817-.193.18-.33.307-.358.336a8 8 0 0 1-.188.186c-.38.366-.664.64.015 1.088.327.216.589.393.85.571.284.194.568.387.936.629q.14.092.27.187c.331.236.63.448.997.414.214-.02.435-.22.547-.82.265-1.417.786-4.486.906-5.751a1.4 1.4 0 0 0-.013-.315.34.34 0 0 0-.114-.217.53.53 0 0 0-.31-.093c-.3.005-.763.166-2.984 1.09"/>
										</svg>
									</a>
								</div>
							</div>
						</div>
						
						<!-- Right Side -->
						<div class="topbar-right-section">
							<div class="topbar-right">
								<!-- Phone Contact -->
								<div class="contact-info">
									<div class="contact-item">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#ffffff" viewBox="0 0 256 256"><path d="M176,16H80A24,24,0,0,0,56,40V216a24,24,0,0,0,24,24h96a24,24,0,0,0,24-24V40A24,24,0,0,0,176,16ZM80,32h96a8,8,0,0,1,8,8v8H72V40A8,8,0,0,1,80,32Zm96,192H80a8,8,0,0,1-8-8v-8H184v8A8,8,0,0,1,176,224Z"></path></svg>
										<div class="contact-details">
											<span class="contact-label">Call now</span>
											<a href="tel:<?php echo esc_html( $header_phone_number ); ?>" class="contact-value">
												<?php echo esc_html( $header_phone_number ); ?>
											</a>
										</div>
									</div>
									
									<!-- Email Contact -->
									<div class="contact-item">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#ffffff" viewBox="0 0 256 256"><path d="M224,48H32a8,8,0,0,0-8,8V192a16,16,0,0,0,16,16H216a16,16,0,0,0,16-16V56A8,8,0,0,0,224,48ZM98.71,128,40,181.81V74.19Zm11.84,10.85,12,11.05a8,8,0,0,0,10.82,0l12-11.05,58,53.15H52.57ZM157.29,128,216,74.18V181.82Z"></path></svg>
										<div class="contact-details">
											<span class="contact-label">Email</span>
											<a href="mailto:<?php echo esc_html( $header_mail_text ); ?>" class="contact-value">
												<?php echo esc_html( $header_mail_text ); ?>
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
		</div>
		<div class=" navigation-bar">
			<div class="uf-wrapper">
				<div class="bg-white">

					<div class="nav-container">
						<!-- Logo Section -->
						<div class="nav-logo">
							<?php get_template_part( 'template-parts/header/site-branding' );?>
						</div>
						
						<!-- Center Menu Section -->
						<div class="nav-menu-center">
							<?php
								siaracorporatebusiness_primary_bar_offcanvas();
								siaracorporatebusiness_primary_bar_menu();
							?>
						</div>
						
						<!-- Right Section - Search and CTA -->
						<div class="nav-right-section">
							<!-- Search Icon -->
							<div class="nav-search">
								<button class="search-toggle" id="searchToggle">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#333" viewBox="0 0 256 256">
										<path d="M229.66,218.34l-50.07-50.06a88.11,88.11,0,1,0-11.31,11.31l50.06,50.07a8,8,0,0,0,11.32-11.32ZM40,112a72,72,0,1,1,72,72A72.08,72.08,0,0,1,40,112Z"/>
									</svg>
								</button>
								<div class="search-form-container" id="searchForm">
									<?php
									get_search_form(
										array(
											'aria_label' => __( 'Search for:', 'siara-consultancy' ),
										)
									);
									?>
								</div>
							</div>
							
							<!-- Get Started Button -->
							<div class="nav-cta">
								<a href="<?php echo esc_html( $header_button_link ); ?>" class="cta-button">
									<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#ffffff" viewBox="0 0 256 256">
										<path d="M228.44,89.34l-96-64a8,8,0,0,0-8.88,0l-96,64A8,8,0,0,0,24,96V200a16,16,0,0,0,16,16H216a16,16,0,0,0,16-16V96A8,8,0,0,0,228.44,89.34ZM96.72,152,40,192V111.53Zm16.37,8h29.82l56.63,40H56.46Zm46.19-8L216,111.53V192Z"/>
									</svg>
									<?php echo esc_html( $header_button_text ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>