<?php
/**
 * Default theme options.
 *
 * @package Sen Business
 */


if ( ! function_exists( 'sen_business_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	
	function sen_business_get_default_theme_options() {

		$theme_data = wp_get_theme();
		$defaults = array();

		$defaults['show_header_contact_info'] 	= true;
		$defaults['menu_btn_text'] 	= __( 'Hire Me','sen-business' );
	    $defaults['menu_btn_url'] 	='#';
		$defaults['disable_homepage_content_section'] 			= false;
		$defaults['show_topbar'] 			= true;
		$defaults['topbar_layout_option'] 			= 'contact-info-option';
	    $defaults['header_email']             	= __( 'info@sensationaltheme.com','sen-business' );
	    $defaults['header_phone' ]            	= __( '+1-541-754-3010','sen-business' );
	    $defaults['header_location' ]           = __( 'London, UK','sen-business' );
	    $defaults['enable_header_contact_info'] 	= true;
	    $defaults['header_email_text']             	= __( 'Email ID','sen-business' );
	    $defaults['header_phone_text' ]            	= __( 'Free Call','sen-business' );
	    $defaults['header_location_text' ]           = __( 'Visit Us','sen-business' );
	    $defaults['header_email_address']             	= __( 'info@sensationaltheme.com','sen-business' );
	    $defaults['header_phone_contact' ]            	= __( '+1-541-754-3010','sen-business' );
	    $defaults['header_location_address' ]           = __( 'London, UK','sen-business' );
	    $defaults['show_header_social_links'] 	= true;
	    $defaults['show_menu_social_links'] 	= true;
	    $defaults['header_social_links']		= array();
	    $defaults['disable_header_background_section'] = false;
	    $defaults['show_header_search'] 	= true;
	    $defaults['show_current_date'] 	= true;
	    $defaults['top_login_text'] 	= __( 'Login','sen-business' );
	    $defaults['top_login_url'] 	='#';
	    $defaults['top_register_text'] 	= __( 'Register','sen-business' );
	    $defaults['top_register_url'] 	= '#';
	    $defaults['search_login_layout'] 	= 'login-option';
	    $defaults['colorscheme_hue'] 	= '#034951';
	    $defaults['medi_text_color'] 	= '#191B1D';
	    $defaults['medi_secondary_color'] 	= '#14457B';
	    $defaults['topbar_background_color'] 	= '#000';
	    $defaults['topbar_color'] 	= '#ffffff';
	    $defaults['enable_center_logo'] 	= true;
	    $defaults['enable_menu_social_links'] 	= false;


	    $defaults['menu_background_color'] 	= '#fff';
	    $defaults['menu_text_hover'] 	= 'menu-hover-none';
	    $defaults['header_text_hover'] 	= 'title-hover-none';
	    $defaults['number_of_menu_items'] 	= 6;
	    $defaults['preloader_loader_enable'] 	= false;
	    $defaults['preloader_loader_options'] 	= 'loader-1';
	    $defaults['header_text_transform_options'] 	= 'none';
	    $defaults['header_text_decoration_options'] 	= 'none';
	    $defaults['header_font_style_options'] 	= 'none';
	    $defaults['header_text_design'] 	= false;
	    $defaults['homepage_color_layout_options']			= 'lite-layout';
	    $defaults['header_layout_options']			= 'header-five';
	    $defaults['homepage_design_layout_options']			= 'home-main';
	    $defaults['homepage_sidebar_position']			= 'home-right-sidebar';
	    $defaults['header_top_buttom_padding']			= 10;

	    //Slider Section
		$defaults['disable_slider_section']	= true;
		$defaults['slider_title']	   	 		= esc_html__( 'Explore latest slider articles', 'sen-business' );
		$defaults['slider_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['slider_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_slider_items']			= 6;
		$defaults['number_of_slider_column']			= 1;
		$defaults['slider_excerpt_length']			= 10;
		$defaults['slider_content_type']			= 'slider_category';
		$defaults['slider_content_align']			= 'content-left';
		$defaults['slider_background_color']			= '#F7A839';
		$defaults['slider_category_enable']		= false;
		$defaults['slider_posted_on_enable']		= true;
		$defaults['slider_author_enable']		= false;
		$defaults['slider_content_enable']		= false;

	    // Catlist Category Section
		$defaults['disable_catlist_section']	= true;
		$defaults['number_of_catlist_column']			= 7;
		$defaults['number_of_catlist_items']			= 10;
		$defaults['catlist_content_type']			= 'post-category';
		$defaults['catlist_title']	   	 		= esc_html__( 'My Major Category', 'sen-business' );
		$defaults['catlist_subtitle']	   	 		= esc_html__( 'I love natural beauty, and I think it’s your best look, but I think makeup as an artist is so transformative.', 'sen-business' );

		//Video Section
		$defaults['disable_video_section']	= true;
		$defaults['video_title']	   	 		= esc_html__( 'Latest video news', 'sen-business' );
		$defaults['video_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['video_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_video_items']			= 6;
		$defaults['number_of_video_column']			= 4;
		$defaults['video_excerpt_length']			= 10;
		$defaults['video_content_type']			= 'video_category';
		$defaults['video_content_align']			= 'content-left';
		$defaults['video_background_color']			= '#F7A839';
		$defaults['video_category_enable']		= false;
		$defaults['video_posted_on_enable']		= true;
		$defaults['video_author_enable']		= false;
		$defaults['video_content_enable']		= false;
		$defaults['number_of_video_ads']			= 2;
		$defaults['video_column_option']			= 'col-2';
		$defaults['disable_video_ads_section']	= false;

		// Featured News Section
		$defaults['disable_featuredpost_section']	= true;
		$defaults['featuredpost_title']	   	 	= esc_html__( 'Featured News', 'sen-business' );
		$defaults['featuredpost_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['featuredpost_right_title']	   	 	= esc_html__( 'Featured News', 'sen-business' );
		$defaults['number_of_featuredpost_items']			= 15;
		$defaults['featuredpost_excerpt_length']			= 5;
		$defaults['featuredpost_layout_option']			= 'default-featuredpost';
		$defaults['featuredpost_content_type']			= 'featuredpost_category';
		$defaults['featuredpost_lite_dark_background']	= 'lite-bg';
		$defaults['featuredpost_category_enable']		= true;
		$defaults['featuredpost_posted_on_enable']		= true;
		$defaults['featuredpost_content_enable']		= false;
		$defaults['featuredpost_author_enable']		= true;
		$defaults['featuredpost_post_count_enable']		= false;
		$defaults['featuredpost_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_featuredpost_ads']			= 2;
		$defaults['featuredpost_column_option']			= 'col-2';
		$defaults['disable_featuredpost_ads_section']	= false;

		//Must Read Section
		$defaults['disable_mustread_section']	= true;
		$defaults['mustread_title']	   	 		= esc_html__( 'Top News You Need to See', 'sen-business' );
		$defaults['mustread_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['mustread_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_mustread_items']			= 8;
		$defaults['number_of_mustread_column']			= 4;
		$defaults['mustread_excerpt_length']			= 20;
		$defaults['mustread_content_type']			= 'mustread_category';
		$defaults['mustread_content_align']			= 'content-left';
		$defaults['mustread_background_color']			= '#F7A839';
		$defaults['mustread_category_enable']		= true;
		$defaults['mustread_posted_on_enable']		= true;
		$defaults['mustread_author_enable']		= true;
		$defaults['mustread_content_enable']		= false;
		$defaults['mustread_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_mustread_ads']			= 2;
		$defaults['mustread_column_option']			= 'col-2';
		$defaults['disable_mustread_ads_section']	= false;

		//Recent Section
		$defaults['disable_recent_section']	= true;
		$defaults['recent_title']	   	 		= esc_html__( 'Top Stories You Need to See', 'sen-business' );
		$defaults['recent_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['recent_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_recent_items']			= 8;
		$defaults['number_of_recent_column']			= 4;
		$defaults['recent_excerpt_length']			= 20;
		$defaults['recent_content_type']			= 'recent_category';
		$defaults['recent_content_align']			= 'content-left';
		$defaults['recent_background_color']			= '#F7A839';
		$defaults['recent_category_enable']		= true;
		$defaults['recent_posted_on_enable']		= true;
		$defaults['recent_author_enable']		= true;
		$defaults['recent_content_enable']		= true;
		$defaults['recent_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_recent_ads']			= 2;
		$defaults['recent_column_option']			= 'col-2';
		$defaults['disable_recent_ads_section']	= false;

		//Recent Section
		$defaults['disable_list_section']	= true;
		$defaults['list_title']	   	 		= esc_html__( 'List News', 'sen-business' );
		$defaults['list_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['list_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_list_items']			= 16;
		$defaults['number_of_list_column']			= 4;
		$defaults['list_excerpt_length']			= 5;
		$defaults['list_content_type']			= 'list_category';
		$defaults['list_content_align']			= 'content-left';
		$defaults['list_background_color']			= '#F7A839';
		$defaults['list_category_enable']		= true;
		$defaults['list_posted_on_enable']		= true;
		$defaults['list_author_enable']		= true;
		$defaults['list_content_enable']		= false;
		$defaults['list_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_list_ads']			= 2;
		$defaults['list_column_option']			= 'col-2';
		$defaults['disable_list_ads_section']	= false;


		//Popular Section
		$defaults['disable_popular_section']	= true;
		$defaults['popular_title']	   	 		= esc_html__( 'The Most Loved Stories', 'sen-business' );
		$defaults['popular_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['popular_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_popular_items']			= 10;
		$defaults['number_of_popular_column']			= 5;
		$defaults['popular_excerpt_length']			= 40;
		$defaults['popular_content_type']			= 'popular_category';
		$defaults['popular_content_align']			= 'content-left';
		$defaults['popular_background_color']			= '#fff';
		$defaults['popular_category_enable']		= true;
		$defaults['popular_posted_on_enable']		= true;
		$defaults['popular_author_enable']		= true;
		$defaults['popular_content_enable']		= true;
		$defaults['popular_post_count_enable']		= false;
		$defaults['number_of_popular_ads']			= 1;
		$defaults['popular_column_option']			= 'col-1';
		$defaults['disable_popular_ads_section']	= false;


		//Popular Section
		$defaults['disable_fixheight_section']	= true;
		$defaults['fixheight_title']	   	 		= esc_html__( 'Discover the Beauty of Destination', 'sen-business' );
		$defaults['fixheight_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['number_of_fixheight_items']			= 10;
		$defaults['number_of_fixheight_column']			= 3;
		$defaults['fixheight_excerpt_length']			= 20;
		$defaults['fixheight_right_content_type']			= 'fixheight_right_post';
		$defaults['fixheight_right_excerpt_length']			= 20;
		$defaults['fixheight_content_type']			= 'fixheight_category';
		$defaults['fixheight_content_align']			= 'content-left';
		$defaults['fixheight_background_color']			= '#fff';
		$defaults['fixheight_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['fixheight_right_category_enable']		= true;
		$defaults['fixheight_right_posted_on_enable']		= true;
		$defaults['fixheight_right_author_enable']		= true;
		$defaults['fixheight_right_content_enable']		= false;
		$defaults['fixheight_category_enable']		= false;
		$defaults['fixheight_posted_on_enable']		= true;
		$defaults['fixheight_author_enable']		= false;
		$defaults['fixheight_content_enable']		= true;
		$defaults['fixheight_post_count_enable']		= false;
		$defaults['number_of_fixheight_ads']			= 1;
		$defaults['fixheight_column_option']			= 'col-1';
		$defaults['disable_fixheight_ads_section']	= false;

		// Category News Section
		$defaults['disable_categorynews_section']	= true;
		$defaults['number_of_categorynews_items']			= 5;
		$defaults['number_of_categorynews_column']			= 3;
		$defaults['categorynews_see_all_txt']	   	 		= esc_html__( 'See All', 'sen-business' );
		$defaults['categorynews_category_enable']		= true;
		$defaults['categorynews_posted_on_enable']		= true;
		$defaults['categorynews_content_enable']		= true;
		$defaults['categorynews_author_enable']		= true;
		$defaults['number_of_categorynews_ads']			= 1;
		$defaults['categorynews_column_option']			= 'col-1';
		$defaults['disable_categorynews_ads_section']	= false;

		//Hero Section
		$defaults['disable_hero_section']	= true;

		//Hero Left Side
		$defaults['hero_left_title']	   	 		= esc_html__( 'Breaking News', 'sen-business' );
		$defaults['hero_left_content_type']			= 'hero_left_category';
		$defaults['hero_left_category_enable']		= true;
		$defaults['hero_left_posted_on_enable']		= true;
		$defaults['hero_left_author_enable']		= false;
		$defaults['hero_left_content_enable']		= false;
		$defaults['hero_left_post_count_enable']		= true;
		$defaults['number_of_hero_left_items']			= 12;
		$defaults['hero_left_excerpt_length']			= 20;

		//Hero Right Side
		$defaults['hero_right_content_type']			= 'hero_right_category';
		$defaults['hero_right_category_enable']		= true;
		$defaults['hero_right_posted_on_enable']		= true;
		$defaults['hero_right_author_enable']		= true;
		$defaults['hero_right_content_enable']		= true;
		$defaults['hero_right_post_count_enable']		= false;
		$defaults['number_of_hero_right_items']			= 6;
		$defaults['hero_right_excerpt_length']			= 30;
		$defaults['number_of_hero_ads']			= 1;
		$defaults['hero_column_option']			= 'col-1';
		$defaults['disable_hero_ads_section']	= false;

		//Banner Section
		$defaults['disable_banner_section']	= true;

		//Banner Left Side
		
		$defaults['banner_left_content_type']			= 'banner_left_category';
		$defaults['banner_left_category_enable']		= true;
		$defaults['banner_left_posted_on_enable']		= true;
		$defaults['banner_left_author_enable']		= false;
		$defaults['banner_left_content_enable']		= false;
		$defaults['banner_left_post_count_enable']		= true;
		$defaults['number_of_banner_left_items']			= 6;
		$defaults['banner_left_excerpt_length']			= 20;

		//Banner Right Side
		$defaults['banner_right_title']	   	 		= esc_html__( 'Others News', 'sen-business' );
		$defaults['banner_right_content_type']			= 'banner_right_category';
		$defaults['banner_right_category_enable']		= true;
		$defaults['banner_right_posted_on_enable']		= false;
		$defaults['banner_right_author_enable']		= false;
		$defaults['banner_right_content_enable']		= false;
		$defaults['banner_right_post_count_enable']		= false;
		$defaults['number_of_banner_right_items']			= 8;
		$defaults['banner_right_excerpt_length']			= 10;
		$defaults['number_of_banner_ads']			= 1;
		$defaults['banner_column_option']			= 'col-1';
		$defaults['disable_banner_ads_section']	= false;
		$defaults['banner_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['banner_see_all_url']			= '#';

		//Trending Section
		$defaults['disable_trending_section']	= true;
		$defaults['trending_title']	   	 		= esc_html__( 'Whats Hot Right Now', 'sen-business' );
		$defaults['trending_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['number_of_trending_items']			= 12;
		$defaults['number_of_trending_column']			= 4;
		$defaults['trending_excerpt_length']			= 20;
		$defaults['trending_content_type']			= 'trending_category';
		$defaults['trending_content_align']			= 'content-left';
		$defaults['trending_background_color']			= '#fff';
		$defaults['trending_category_enable']		= true;
		$defaults['trending_posted_on_enable']		= true;
		$defaults['trending_author_enable']		= true;
		$defaults['trending_content_enable']		= true;
		$defaults['trending_views_enable']		= true;
		$defaults['trending_readtime_enable']		= true;
		$defaults['trending_see_all_txt']			= esc_html__( 'See All', 'sen-business' );
		$defaults['number_of_trending_ads']			= 2;
		$defaults['trending_column_option']			= 'col-2';
		$defaults['disable_trending_ads_section']	= false;

		// Shop product Section
		$defaults['disable_shopproduct_section']	= true;
		$defaults['shopproduct_title']	   	 		= esc_html__( 'Product', 'sen-business' );
		$defaults['shopproduct_readmore']	   	 		= esc_html__( 'Boy Now', 'sen-business' );
		$defaults['shopproduct_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['number_of_shopproduct_items']	= 2;
		$defaults['shopproduct_content_type']		= 'product';
		$defaults['shopproduct_background_color']	   	= '#fff';

		// Gallery Section
		$defaults['disable_subscription_section']	= true;
		;$defaults['subscription_title']	   				= esc_html__( 'Subscribe To Our Newsletter', 'sen-business' );
		$defaults['subscription_description']	   	 		= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['subscription_bnt_text']	   	 		= esc_html__( 'Subscribe', 'sen-business' );

		// Banner Section
		$defaults['disable_banner_section']	= true;
		$defaults['banner_title']	   	 		= esc_html__( 'Whats Hot Right Now', 'sen-business' );
		$defaults['banner_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'sen-business' );
		$defaults['number_of_banner_items']			= 4;
		$defaults['number_of_banner_column']			= 4;
		$defaults['banner_excerpt_length']			= 20;
		$defaults['banner_content_type']			= 'banner_category';
		$defaults['banner_content_align']			= 'content-left';
		$defaults['banner_background_color']			= '#fff';
		$defaults['banner_category_enable']		= true;
		$defaults['banner_posted_on_enable']		= true;
		$defaults['banner_author_enable']		= true;
		$defaults['banner_content_enable']		= true;
		$defaults['banner_views_enable']		= true;
		$defaults['banner_readtime_enable']		= true;
		$defaults['banner_see_all_txt']			= esc_html__( 'See All', 'sen-business' );

		// Instagram Section
		$defaults['disable_instagram_section']	= false;
		$defaults['instagram_title']	   	 	= esc_html__( 'Instagram', 'sen-business' );

		// Latest News Section
		$defaults['latest_posts_title']	   	 	= esc_html__( 'Latest News', 'sen-business' );
		$defaults['number_of_latest_posts_column']	= 1;
		$defaults['pagination_type']		= 'numeric';
		$defaults['latest_category_enable']		= true;
		$defaults['latest_author_enable']		= true;
		$defaults['latest_comment_enable']		= true;
		$defaults['latest_content_enable']		= true;
		$defaults['latest_read_more_text_enable']		= true;
		$defaults['latest_posted_on_enable']		= true;
		$defaults['latest_video_enable']		= false;
		$defaults['blog_layout_content_type']		= 'blog-three';
		$defaults['archive_content_align']		= 'content-left';
		$defaults['archive_post_header_title_enable']		= true;
		$defaults['archive_post_header_image_enable']		= false;
		$defaults['remove_category_text_archive_page']		= true;
		$defaults['blog_post_header_image_enable']		= false;
		$defaults['blog_post_header_title_enable']		= true;
		$defaults['background_image_enable']		= true;
		
		// Decoration Option
		$defaults['decoration_side_enable']		= true;
		

		// Category Design Option
		$defaults['category_design_content_type']		= 'category-six';
		$defaults['enable_category_icon']		= false;

		// Image Option
		$defaults['image_design_type']		= 'o-image';
		$defaults['enable_image_radius']		= false;
		

		// Single News Option
		$defaults['single_post_category_enable']		= true;
		$defaults['single_post_posted_on_enable']		= true;
		$defaults['single_post_video_enable']		= true;
		$defaults['single_post_comment_enable']		= true;
		$defaults['single_post_author_enable']		= true;
		$defaults['single_post_pagination_enable']		= true;
		$defaults['single_post_image_enable']		= true;
		$defaults['single_post_header_image_enable']		= false;
		$defaults['single_post_header_title_enable']		= true;
		$defaults['single_post_header_image_as_header_image_enable']		= false;
		$defaults['sen_business_single_related_posts']		= true;
		$defaults['single_post_content_align']		= 'content-left';
		$defaults['sen_business_single_related_post_title']		= esc_html__( 'Related Newss', 'sen-business' );

		// Single Page Option
		$defaults['single_page_video_enable']		= true;
		$defaults['single_page_image_enable']		= true;
		$defaults['single_page_header_image_enable']		= false;
		$defaults['single_page_header_title_enable']		= true;
		$defaults['single_page_header_image_as_header_image_enable']		= false;
		$defaults['single_page_content_align']		= 'content-left';
		
		$defaults['theme_typography']			=  'default';
		$defaults['body_theme_typography']		=  'default';		
		$defaults['archive_typography']			=  'default';
		$defaults['body_archive_typography']		=  'default';		
		$defaults['page_typography']			=  'default';
		$defaults['body_page_typography']		=  'default';		
		$defaults['post_typography']			=  'default';
		$defaults['body_post_typography']		=  'default';		
		$defaults['site_title_typography']			=  'default';
		$defaults['site_tagline_typography']		=  'default';

		// animation
		$defaults['animation_slide_type']		= 'animation-b-t';
		$defaults['enable_animation']		= false;

		//Site Layout
		$defaults['site_layout_theme_options']			= 'default-site-layout';
		
		//General Section
		$defaults['latest_readmore_text']			= esc_html__('Read More','sen-business');
		$defaults['excerpt_length']					= 30;
		$defaults['layout_options_blog']			= 'right-sidebar';
		$defaults['layout_options_archive']			= 'right-sidebar';
		$defaults['layout_options_page']			= 'right-sidebar';	
		$defaults['layout_options_single']			= 'right-sidebar';	

		//Footer section 
		$defaults['scroll_top_visible']		= true;		
		$defaults['copyright_text']				= esc_html__( 'Copyright &copy; All rights reserved.', 'sen-business' );
		$defaults['powered_by_text']			= esc_html__( 'Sen Business by Sensational Theme', 'sen-business' );
		$defaults['enable_footer_background_image'] 	= true;
		$defaults['footer_copyright_font_color'] 	= '#fff';
		$defaults['footer_copyright_background_color'] 	= '#000';

		// Pass through filter.
		$defaults = apply_filters( 'sen_business_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;


/**
*  Get theme options
*/
if ( ! function_exists( 'sen_business_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function sen_business_get_option( $key ) {

			$default_options = sen_business_get_default_theme_options();
		
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;