<?php
/**
 * Header options.
 *
 * @package Sen Agency
 */

$default = sen_agency_get_default_theme_options();

// Header panel
    $wp_customize->add_panel(
        'sen_agency_header_panel',
        array(
            'title' => esc_html__( 'Header', 'sen-agency' ),
            'priority' => 11
        )
    );

    $wp_customize->get_section( 'header_image' )->panel         = 'sen_agency_header_panel';
// Header Author Section
$wp_customize->add_section( 'section_home_header', 
	array(
		'title'      => __( 'Header Options', 'sen-agency' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'sen_agency_header_panel',
		)
);
// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[header_layout_options]', array(
	'default'           => $default['header_layout_options'],
	'sanitize_callback' => 'sen_agency_sanitize_select',
	'type'				=> 'theme_mod',
) );

$wp_customize->add_control( 'theme_options[header_layout_options]', array(
	'label'             => esc_html__( 'Choose Header Layout', 'sen-agency' ),
	'section'           => 'section_home_header',
	'type'              => 'radio',
	'choices'				=> array( 
		'header-one'     => esc_html__( 'Header One(Normal)', 'sen-agency' ),  
		'header-five'     => esc_html__( 'Header Two(Header Contact)', 'sen-agency' ), 
		)
) );
// Login Button Text
$wp_customize->add_setting('theme_options[menu_btn_text]', 
    array(
    'default'           => $default['menu_btn_text'],
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control('theme_options[menu_btn_text]', 
    array(
    'label'       => __('Button Text', 'sen-agency'),
    'section'     => 'section_home_header',   
    'settings'    => 'theme_options[menu_btn_text]',   
    'type'        => 'text'
    )
);
// Login Button Url
$wp_customize->add_setting('theme_options[menu_btn_url]', 
    array(
    'default'           => $default['menu_btn_url'],
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control('theme_options[menu_btn_url]', 
    array(
    'label'       => __('Button Link', 'sen-agency'),
    'section'     => 'section_home_header',   
    'settings'    => 'theme_options[menu_btn_url]',  
    'type'        => 'url'
    )
);
$wp_customize->add_control( new Sen_Agency_Switch_Control( $wp_customize, 'theme_options[show_header_contact_info]', array(
    'label'             => __( 'Show Contact Info', 'sen-agency' ),
    'section'           => 'section_home_header',
    'settings'         => 'theme_options[show_header_contact_info]',
    'on_off_label'      => sen_agency_switch_options(),
) ) );

/** Location */
$wp_customize->add_setting( 'theme_options[header_location_text]', array(
    'default'           => $default['header_location_text'],
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control(
    'theme_options[header_location_text]',
    array(
        'label'           => __( 'Location Title Text', 'sen-agency' ),
        'section'         => 'section_home_header',
        'active_callback' => 'sen_agency_header_five',
    )
);
$wp_customize->add_setting( 'theme_options[header_location_address]', array(
    'default'           => $default['header_location_address'],
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control(
    'theme_options[header_location_address]',
    array(
        'label'           => __( 'Address', 'sen-agency' ),
        'description'     => __( 'Enter Location.', 'sen-agency' ),
        'section'         => 'section_home_header',
        'active_callback' => 'sen_agency_header_five',
    )
);

/** Phone */
$wp_customize->add_setting( 'theme_options[header_phone_text]', array(
    'default'           => $default['header_phone_text'],
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control(
    'theme_options[header_phone_text]',
    array(
        'label'           => __( 'Phone Title Text', 'sen-agency' ),
        'section'         => 'section_home_header',
        'active_callback' => 'sen_agency_header_five',
    )
);

$wp_customize->add_setting( 'theme_options[header_phone_contact]', array(
    'default'           => $default['header_phone_contact'],
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control(
    'theme_options[header_phone_contact]',
    array(
        'label'           => __( 'Contact', 'sen-agency' ),
        'description'     => __( 'Enter phone number.', 'sen-agency' ),
        'section'         => 'section_home_header',
        'active_callback' => 'sen_agency_header_five',
    )
);

/** Email */
$wp_customize->add_setting( 
    'theme_options[header_email_text]', 
    array(
        'default'           => $default['header_email_text'],
        'sanitize_callback' => 'sanitize_email',
    ) 
);

$wp_customize->add_control(
    'theme_options[header_email_text]',
    array(
        'label'           => __( 'Email Title Text', 'sen-agency' ),
        'section'         => 'section_home_header',
        'active_callback' => 'sen_agency_header_five',
    )
);
$wp_customize->add_setting( 
    'theme_options[header_email_address]', 
    array(
        'default'           => $default['header_email_address'],
        'sanitize_callback' => 'sanitize_email',
    ) 
);

$wp_customize->add_control(
    'theme_options[header_email_address]',
    array(
        'label'           => __( 'Email', 'sen-agency' ),
        'description'     => __( 'Enter valid email address.', 'sen-agency' ),
        'section'         => 'section_home_header',
        'active_callback' => 'sen_agency_header_five',
    )
);
