<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit(); // Exit if accessed directly.
}

if (!class_exists('Savalog_Slider')) {
    class Savalog_Slider extends Widget_Base
    {
        public function __construct($data = [], $args = null)
        {
            parent::__construct($data, $args);
            wp_enqueue_style(
                'savalog-slider-style',
                esc_url(
                    SAVALOG_TEMPLATE_URI . '/widgets/assets/css/slider.css'
                ),
                ['savalog-main-style'],
                null
            );

            wp_enqueue_script('savalog-slider-script', esc_url(SAVALOG_TEMPLATE_URI . '/widgets/assets/js/slider.js'), ['jquery', 'savalog-slick-script'], '1.0.0', true);
        }
        public function get_name()
        {
            return 'honrix_slider';
        }

        public function get_title()
        {
            return __('Savalog: Post Slider', 'savalog');
        }

        public function get_icon()
        {
            return 'eicon-post-slider';
        }

        public function get_categories()
        {
            return ['honrix-addon'];
        }

        protected function register_controls()
        {
            $this->start_controls_section('content_section', [
                'label' => __('Slider', 'savalog'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]);

            $args = array(
                "post_type" => "post",
                "orderby" => "ID",
                "post_status" => "publish",
                "order" => "DESC",
            );

            $posts_arr = [];
            $_posts = get_posts($args);
            if (count($_posts) > 0) {
                foreach ($_posts as $post) {
                    $posts_arr[$post->ID] = $post->post_title;
                }
            }

            $this->add_control(
                'slides',
                [
                    'label' => esc_html__('Select Posts', 'savalog'),
                    'type' => \Elementor\Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => $posts_arr,
                ]
            );

            $this->add_control(
                'autoplay_speed',
                [
                    'label' => esc_html__('Autoplay Speed', 'savalog'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => '4000',
                    'options' => [
                        '1000' => '1000',
                        '2000' => '2000',
                        '3000' => '3000',
                        '4000' => '4000',
                        '5000' => '5000',
                        '6000' => '6000',
                        '7000' => '7000',
                        '8000' => '8000',
                    ]
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            // if (\Elementor\Plugin::$instance->editor->is_edit_mode() == false) {
            wp_localize_script('savalog-slider-script', 'savalog_slider_params', array(
                'autoplay_speed' => esc_js($settings['autoplay_speed']),
            ));
            $slider_posts = [];
            if ($settings['slides']):
                foreach ($settings['slides'] as $post) {
                    $slider_posts[] = $post;
                }
            endif;

            $args = array(
                'post__in' => $slider_posts,
                'order' => 'ASC'
            );

            $slider_posts = get_posts($args);
            if (count($slider_posts) > 0): ?>
                <div class="savalog-home-slider">
                    <?php foreach ($slider_posts as $post) :
                        $post_thumbnail_url = get_the_post_thumbnail_url($post->ID);
                        if (!empty($post_thumbnail_url)): ?>
                            <div class="position-relative">
                                <img src="<?php echo esc_url($post_thumbnail_url); ?>" alt="<?php echo esc_html($post->post_title); ?>" />
                                <div class="slider-content position-absolute w-100 h-100 top-0 start-0 d-flex flex-column align-items-center justify-content-center">
                                    <div class="text-center">
                                        <?php $categories_list = wp_get_post_categories($post->ID, array('fields' => 'all')); ?>
                                        <?php if (count($categories_list) > 0) : ?>
                                            <div>
                                                <span class="entry-categories mb-2">
                                                    <?php foreach ($categories_list as $category): ?>
                                                        <span><a href="<?php echo esc_url(get_category_link($category->term_id)); ?>"><?php echo esc_html($category->name); ?></a></span>
                                                    <?php endforeach; ?>
                                                </span>
                                            </div>
                                        <?php endif; ?>
                                        <h2 class="entry-title d-inline-block mb-2"><?php echo wp_kses_post($post->post_title); ?></h2>
                                        <div class="entry-read-more my-4">
                                            <a href="<?php echo esc_url(get_permalink($post->ID)) ?>" rel="bookmark"><?php echo esc_html(get_theme_mod('savalog_archive_content_read_more_text', __('Continue Reading...', 'savalog'))) ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php endif;
                    endforeach; ?>
                </div>
<?php endif;

            // }
        }
    }
    Plugin::instance()->widgets_manager->register_widget_type(
        new Savalog_Slider()
    );
}
