<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit(); // Exit if accessed directly.
}

if (!class_exists('Honrix_Skip_Link')) {
    class Honrix_Skip_Link extends Widget_Base
    {
        public function __construct($data = [], $args = null)
        {
            parent::__construct($data, $args);
        }

        public function get_name()
        {
            return 'honrix_skip_link';
        }

        public function get_title()
        {
            return __('Honrix: Skip Link', 'savalog');
        }

        public function get_icon()
        {
            return 'eicon-link';
        }

        public function get_categories()
        {
            return ['honrix-addon'];
        }

        protected function register_controls()
        {

        }

        protected function render()
        { ?>
            <a class='skip-link screen-reader-text' href='#content' aria-label="<?php echo esc_attr__('Skip to content', 'savalog'); ?>">
                <?php echo esc_html__('Skip to content', 'savalog'); ?>
            </a>
<?php
        }
    }
    Plugin::instance()->widgets_manager->register_widget_type(
        new Honrix_Skip_Link()
    );
}
