<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit(); // Exit if accessed directly.
}

if (!class_exists('Honrix_Product_Search')) {
    class Honrix_Product_Search extends Widget_Base
    {
        public function __construct($data = [], $args = null)
        {
            parent::__construct($data, $args);
        }
        public function get_name()
        {
            return 'honrix_product_search';
        }

        public function get_title()
        {
            return __('Honrix: Search', 'savalog');
        }

        public function get_icon()
        {
            return 'eicon-site-search';
        }

        public function get_categories()
        {
            return ['honrix-addon'];
        }

        protected function register_controls()
        {
            $this->start_controls_section('icon_style_section', [
                'label' => esc_html__('Icon', 'savalog'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]);

            $this->start_controls_tabs(
                'item_style_tabs'
            );

            $this->start_controls_tab(
                'item_style_normal_tab',
                [
                    'label' => esc_html__('Normal', 'savalog'),
                ]
            );

            $this->add_responsive_control('item_color', [
                'label' => esc_html__('Color', 'savalog'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .hrix-header-popup-search-icon' => 'color: {{VALUE}}',
                ],
            ]);

            $this->end_controls_tab();

            $this->start_controls_tab(
                'item_style_hover_tab',
                [
                    'label' => esc_html__('Hover', 'savalog'),
                ]
            );
            $this->add_responsive_control('item_hover_color', [
                'label' => esc_html__('Color', 'savalog'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffbd28',
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .hrix-header-popup-search-icon:hover' => 'color: {{VALUE}}',
                ],
            ]);

            $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->end_controls_section();
        }

        protected function render()
        { ?>
            <div class="hrix-widget-product-search">
                <?php do_action('savalog_search'); ?>
            </div>
<?php
        }
    }
    Plugin::instance()->widgets_manager->register_widget_type(
        new Honrix_Product_Search()
    );
}
