<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit(); // Exit if accessed directly.
}

if (!class_exists('Honrix_Loading_Page')) {
    class Honrix_Loading_Page extends Widget_Base
    {
        public function __construct($data = [], $args = null)
        {
            parent::__construct($data, $args);
        }

        public function get_name()
        {
            return 'honrix_loading_page';
        }

        public function get_title()
        {
            return __('Honrix: Loading Page', 'savalog');
        }

        public function get_icon()
        {
            return 'eicon-spinner';
        }

        public function get_categories()
        {
            return ['honrix-addon'];
        }

        protected function register_controls() {}

        protected function render()
        { ?>
            <?php if (get_theme_mod('savalog_loading_display', 'yes') === 'yes'): ?>
                <div id="spinner" class="show position-fixed translate-middle w-100 vh-100 top-50 start-50 align-items-center justify-content-center">
                    <div class="spinner"><span class="loader rounded-circle"></span></div>
                </div>
<?php
            endif;
        }
    }
    Plugin::instance()->widgets_manager->register_widget_type(
        new Honrix_Loading_Page()
    );
}
