<?php
if (defined('ELEMENTOR_VERSION')) {
    add_action('wp_enqueue_scripts', function () {
        /* Scripts */

        if (\Elementor\Plugin::$instance->preview->is_preview_mode()) {
            wp_register_script('honrix-elementor-preview-js', esc_url(SAVALOG_TEMPLATE_URI . '/widgets/assets/js/preview.js'), ['jquery'], '1.0.0', true);
        } else {
            wp_register_script('honrix-widget-slider-script', esc_url(SAVALOG_TEMPLATE_URI . '/widgets/assets/js/slider.js'), ['owl-carousel-js'], '1.0.0', true);
        }

        wp_register_style('honrix-widget-slider-css', esc_url(SAVALOG_TEMPLATE_URI . '/widgets/assets/css/slider.css'), ['savalog-main-style']);
    });

    add_action('elementor/preview/enqueue_scripts', function () {
        wp_enqueue_script('honrix-elementor-preview-js');
    });

    add_action('elementor/widgets/widgets_registered', function () {
        get_template_part('/widgets/skip-link/skip-link');
        get_template_part('/widgets/loading-page/loading-page');
        get_template_part('/widgets/logo/logo');
        get_template_part('/widgets/menu/menu');
        get_template_part('/widgets/product-search/product-search');
        get_template_part('/widgets/posts/posts');
    });
}
