(function ($, elementor) {
  "use strict";

  var loadingPageWidget = {
    init: function () {
      var widgets = {
        "honrix_loading_page.default": loadingPageWidget.loadingPage,
      };
      $.each(widgets, function (widget, callback) {
        elementor.hooks.addAction("frontend/element_ready/" + widget, callback);
      });
    },

    loadingPage: function () {
      console.log("loading");
      var spinner = function () {
        setTimeout(function () {
          if ($("#spinner").length > 0) {
            $("#spinner").removeClass("show");
          }
        }, 1);
      };
      spinner();
    },
  };
  $(window).on("elementor/frontend/init", loadingPageWidget.init);

  var menuWidget = {
    init: function () {
      var widgets = {
        "honrix_menu.default": menuWidget.menu,
      };
      $.each(widgets, function (widget, callback) {
        elementor.hooks.addAction("frontend/element_ready/" + widget, callback);
      });
    },

    menu: function () {
      const $dropdown = $(".dropdown");
      const $dropdownToggle = $(".dropdown-toggle");
      const $dropdownMenu = $(".dropdown-menu");
      const showClass = "show";

      if ($(window).width() > 991) {
        $dropdown.hover(
          function () {
            const $this = $(this);
            $this.addClass(showClass);
            $this.find($dropdownToggle).first().attr("aria-expanded", "true");
            $this.find($dropdownMenu).first().addClass(showClass);
          },
          function () {
            const $this = $(this);
            $this.removeClass(showClass);
            $this.find($dropdownToggle).first().attr("aria-expanded", "false");
            $this.find($dropdownMenu).first().removeClass(showClass);
          }
        );
      } else if ($(window).width() < 992) {
        $dropdownToggle.click(function (event) {
          event.preventDefault();
          const $this = $(this).parent();
          if ($this.find($dropdownMenu).first().hasClass(showClass)) {
            $this.removeClass(showClass);
            $this.find($dropdownToggle).first().attr("aria-expanded", "false");
            $this.find($dropdownMenu).first().removeClass(showClass);
          } else {
            $this.addClass(showClass);
            $this.find($dropdownToggle).first().attr("aria-expanded", "true");
            $this.find($dropdownMenu).first().addClass(showClass);
          }
        });
      } else {
        $dropdown.off("mouseenter mouseleave");
      }
    },
  };
  $(window).on("elementor/frontend/init", menuWidget.init);

  var searchWidget = {
    init: function () {
      var widgets = {
        "honrix_product_search.default": searchWidget.search,
      };
      $.each(widgets, function (widget, callback) {
        elementor.hooks.addAction("frontend/element_ready/" + widget, callback);
      });
    },

    search: function () {
      $(".hrix-header-popup-search-icon").click(function () {
        $(".hrix-header-popup-search-form").addClass("show");
      });

      $(".hrix-header-popup-search-form .close").click(function () {
        $(".hrix-header-popup-search-form").removeClass("show");
      });
    },
  };

  $(window).on("elementor/frontend/init", searchWidget.init);

  var postsWidget = {
    init: function () {
      var widgets = {
        "honrix_posts.default": postsWidget.masonry,
      };
      $.each(widgets, function (widget, callback) {
        elementor.hooks.addAction("frontend/element_ready/" + widget, callback);
      });
    },

    masonry: function ($scope) {
      $("#hrx-widget-slider-" + $scope[0].dataset.id).addClass(
        "owl-carousel owl-theme"
      );
      $("#hrx-widget-slider-" + $scope[0].dataset.id).owlCarousel({
        autoplay: 4000,
        autoplayTimeout: 4000,
        smartSpeed: 250,
        nav: true,
        navText: [
          '<i class="fas fa-chevron-left"></i>',
          '<i class="fas fa-chevron-right"></i>',
        ],
        dots: false,
        loop: true,
        lazyLoad: true,
        center: true,
        responsive: {
          0: {
            items: 1,
          },
          576: {
            items: 1,
          },
          768: {
            items: 1,
          },
          992: {
            items: 1,
          },
        },
      });

      $(".honrix-gallery-slider").addClass("owl-carousel owl-theme");
      $(".honrix-gallery-slider").owlCarousel({
        autoplay: 4000,
        autoplayTimeout: 4000,
        smartSpeed: 250,
        nav: true,
        navText: [
          '<i class="fas fa-chevron-left"></i>',
          '<i class="fas fa-chevron-right"></i>',
        ],
        dots: false,
        loop: true,
        lazyLoad: true,
        center: true,
        responsive: {
          0: {
            items: 1,
          },
          576: {
            items: 1,
          },
          768: {
            items: 1,
          },
          992: {
            items: 1,
          },
        },
      });
      $(".honrix-gallery-slider").trigger("refresh.owl.carousel");

      setTimeout(function () {
        $(".honrix-masonry").masonry({
          gutter: 14,
        });
      }, 200);
    },
  };
  $(window).on("elementor/frontend/init", postsWidget.init);
})(jQuery, window.elementorFrontend);
