<?php

/**
 * savalog blog list
 *
 * @package savalog
 */
?>

<?php if (is_search()) : ?>
    <div class="savalog-archive-title pt-3 pb-3">
        <div class="row mx-auto <?php echo esc_attr(get_theme_mod('savalog_boxed', 'boxed')) === 'boxed' ? 'container' : 'container-fluid'; ?>">
            <h1 class="page-title m-0 mb-2"><?php echo esc_html('Search Results for: ', 'savalog') . '<span class="search-term">' . esc_html(get_search_query()); ?></span></h1>
        </div>
    </div>
<?php elseif (is_archive()) : ?>
    <div class="hrix-archive-title pt-3 pb-3">
        <div class="row mx-auto <?php echo esc_attr(get_theme_mod('savalog_boxed', 'boxed')) === 'boxed' ? 'container' : 'container-fluid'; ?>">
            <?php the_archive_title('<h1 class="page-title m-0 mb-2">', '</h1>'); ?>
            <?php the_archive_description('<div class="archive-description">', '</div>'); ?>
        </div>
    </div>
<?php endif; ?>

<div id="content" class="honrix-content savalog-archive pb-4">
    <div class="row mx-auto pt-4 <?php echo esc_attr(get_theme_mod('savalog_boxed', 'boxed')) == 'boxed' ? 'container' : 'container-fluid'; ?>">
        <?php
        $right_sidebar = $left_sidebar = false;
        $right_sidebar = get_theme_mod('savalog_right_sidebar_display', 'yes') === 'yes' && is_active_sidebar('right_sidebar');
        $left_sidebar = get_theme_mod('savalog_left_sidebar_display', 'yes') === 'yes' && is_active_sidebar('left_sidebar');

        $column_count = get_theme_mod('savalog_archive_columns', '2');
        $archive_mode = get_theme_mod('savalog_archive_mode', 'grid');
        if ($archive_mode === 'list') {
            $column_count = 1;
        }

        $post_counter = 1;

        ?>
        <?php if ($left_sidebar) : ?>
            <div class="col-12 col-md-3">
                <?php is_rtl() ? get_sidebar('right') : get_sidebar('left'); ?>
            </div>
        <?php endif; ?>
        <div class="col-12 col-md-<?php echo (12 - ($left_sidebar ? 3 : 0) - ($right_sidebar ? 3 : 0));  ?>">
            <div>
                <div class="posts honrix-entries column-<?php echo esc_html($column_count); ?> <?php echo esc_attr($archive_mode === 'masonry' ? 'savalog-masonry' : $archive_mode) ?>">
                    <?php if (have_posts()) : ?>
                        <?php while (have_posts()) :/* loop start*/
                            the_post(); ?>
                            <?php savalog_post_card(['post_counter'=>$post_counter]); ?>
                            <?php $post_counter++; ?>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </div>
                <?php honrix_entries_pagination(); ?>
            </div>
        </div>
        <?php if ($right_sidebar) : ?>
            <div class="col-12 col-md-3">
                <?php is_rtl() ? get_sidebar('left') : get_sidebar('right'); ?>
            </div>
        <?php endif; ?>
    </div>
</div>
</div>