<?php
if (!function_exists('savalog_init_widget_area')) {
    function savalog_init_widget_area()
    {
        if (get_theme_mod('savalog_top_bar_display', 'yes') === 'yes') {
            register_sidebar([
                'name' => __('Top Left', 'savalog'),
                'id' => 'savalog_top_left',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget' => '</aside>',
                'before_title' => '<h5 class="widget-title fs-4 m-0 mb-3 pb-1">',
                'after_title' => '</h5>',
            ]);

            register_sidebar([
                'name' => __('Top Right', 'savalog'),
                'id' => 'savalog_top_right',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget' => '</aside>',
                'before_title' => '<h5 class="widget-title fs-4 m-0 mb-3 pb-1">',
                'after_title' => '</h5>',
            ]);

            register_sidebar([
                'name' => __('Mobile Top Bar', 'savalog'),
                'id' => 'savalog_mobile_top_bar',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget' => '</aside>',
                'before_title' => '<h5 class="widget-title fs-4 m-0 mb-3 pb-1">',
                'after_title' => '</h5>',
            ]);
        }

        register_sidebar(
            array(
                'name' => __('Left Sidebar', 'savalog'),
                'id' => 'left_sidebar',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget' => '</aside>',
                'before_title' => '<h5 class="widget-title fs-4 m-0 mb-3 pb-1">',
                'after_title' => '</h5>',
            )
        );

        register_sidebar(
            array(
                'name' => __('Right Sidebar', 'savalog'),
                'id' => 'right_sidebar',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget' => '</aside>',
                'before_title' => '<h5 class="widget-title fs-4 m-0 mb-3 pb-1">',
                'after_title' => '</h5>',
            )
        );

        for ($counter = 1; $counter <= get_theme_mod('savalog_footer_columns', '3'); $counter++) :
            $name = 'Footer Column %s';
            $name = sprintf($name, $counter);
            register_sidebar(
                array(
                    'name' => $name,
                    'id' => 'footer' . $counter,
                    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h5 class="widget-title fs-4 m-0 mb-3 pb-1">',
                    'after_title' => '</h5>',
                )
            );
        endfor;

        register_sidebar([
            'name' => __('Copyright Widgets', 'savalog'),
            'id' => 'copyright_widgets',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h5 class="widget-title fs-4 m-0 mb-3 pb-1">',
            'after_title' => '</h5>',
        ]);
    }

    add_action('widgets_init', 'savalog_init_widget_area');
}
