<?php
if (!function_exists('savalog_entry_title')) {
    function savalog_entry_title()
    {
?>
        <?php if (is_singular()) : ?>
            <?php if (is_sticky()) : ?>
                <?php
                the_title(sprintf('<h1 class="entry-title mb-2 fs-4 d-flex align-items-center gap-2"><span class="fas fa-thumbtack"></span> ', esc_url(get_permalink())), '</h1>');
                ?>
            <?php else : ?>
                <?php
                the_title(sprintf('<h1 class="entry-title mb-2 fs-4">', esc_url(get_permalink())), '</h1>');
                ?>
            <?php endif; ?>
        <?php else : ?>
            <?php if (is_sticky()) : ?>
                <?php
                the_title(sprintf('<h2 class="entry-title mb-2 fs-5 d-flex align-items-center gap-2"><span class="fas fa-thumbtack"></span><a href="%1$s" rel="bookmark" aria-label="%2$s">', esc_url(get_permalink()), esc_html(get_the_title())), '</a></h2>');
                ?>
            <?php else : ?>
                <?php the_title(sprintf('<h2 class="entry-title mb-2 fs-5"><a href="%1$s" rel="bookmark" aria-label="%2$s">', esc_url(get_permalink()), esc_html(get_the_title())), '</a></h2>'); ?>
            <?php endif; ?>
        <?php endif; ?>
        <?php
    }
}

if (!function_exists('savalog_singular_thumbnail')) {
    function savalog_singular_thumbnail()
    {
        if (class_exists('WooCommerce')) {
            if (
                is_shop() ||
                is_cart() ||
                is_checkout() ||
                is_account_page() ||
                is_product_category() ||
                is_product_tag() ||
                is_product() ||
                is_wc_endpoint_url()
            ) {
                return;
            }
        }

        if (has_post_thumbnail()): ?>
            <div class="post-thumbnail d-flex justify-content-center">
                <?php the_post_thumbnail(); ?>
            </div>
        <?php endif;
    }
}
if (!function_exists('savalog_post_thumbnail')) {
    function savalog_post_thumbnail($is_singular = null)
    {
        if (null === $is_singular) {
            $is_singular =  is_singular();
        }

        if (get_theme_mod('savalog_archive_display_thumbnail') === 'yes'): ?>
            <?php if (get_post_format() === 'video') :
                $content = get_the_content(); ?>
                <div class="post-thumbnail d-flex justify-content-center">
                    <?php
                    if (has_block('core/video', $content)) {
                        savalog_print_first_instance_of_block('core/video', $content);
                    } elseif (has_block('core/embed', $content)) {
                        savalog_print_first_instance_of_block('core/embed', $content);
                    } else {
                        savalog_print_first_instance_of_block('core-embed/*', $content);
                    } ?>
                </div>
            <?php
            elseif (get_post_format() === 'audio') :
                $content = get_the_content(); ?>
                <div class="post-thumbnail d-flex justify-content-center position-relative">
                    <div class="overflow-hidden">
                        <?php the_post_thumbnail(); ?>
                    </div>
                    <?php
                    if (has_block('core/audio', $content)) {
                        savalog_print_first_instance_of_block('core/audio', $content);
                    } elseif (has_block('core/embed', $content)) {
                        savalog_print_first_instance_of_block('core/embed', $content);
                    } else {
                        savalog_print_first_instance_of_block('core-embed/*', $content);
                    } ?>
                </div>
                <?php
            elseif (get_post_format() === 'gallery') :
                $content = get_the_content();
                if (has_block('core/gallery', $content)) : ?>
                    <div class="post-thumbnail">
                        <?php
                        $blocks = parse_blocks($content);
                        $block_name = 'core/gallery';
                        foreach ($blocks as $block) {
                            if (!isset($block['blockName'])) {
                                continue;
                            }
                            if ('*' === $block_name[-1]) {
                                $is_matching_block = 0 === strpos($block['blockName'], rtrim($block_name, '*'));
                            } else {
                                $is_matching_block = $block_name === $block['blockName'];
                            }

                            if ($is_matching_block) {
                                $inner_blocks = $block['innerBlocks'];
                        ?>
                                <div class="honrix-gallery-slider">
                                    <?php
                                    foreach ($inner_blocks as $inner_block) {
                                        $inner_html = $inner_block['innerHTML'];
                                        preg_match('/src="([^"]+)/i', $inner_html, $srces);
                                        $src = str_ireplace('src="', '',  $srces[0]);
                                    ?>
                                        <div>
                                            <img src="<?php echo esc_url($src); ?>" alt="<?php echo esc_html(get_the_title()); ?>" />
                                        </div>
                                    <?php
                                    } ?>
                                </div>
                        <?php
                            }
                        }
                        ?>
                    </div>
                <?php
                endif; ?>
            <?php else: ?>
                <?php if (has_post_thumbnail()): ?>
                    <a href="<?php echo esc_url(get_permalink()); ?>" aria-label="<?php echo esc_html(get_the_title()); ?>">
                        <div class="post-thumbnail d-flex justify-content-center overflow-hidden">
                            <?php the_post_thumbnail(); ?>
                            <?php
                            switch (get_post_format()) {
                                case 'image':
                                    echo '<span class="fas fa-image"></span>';
                                    break;
                                case 'quote':
                                    echo '<span class="fas fa-quote-left"></span>';
                                    break;
                                case 'chat':
                                    echo '<span class="fas fa-comments"></span>';
                                    break;
                                case 'link':
                                    echo '<span class="fas fa-link"></span>';
                                    break;
                            }
                            ?>
                        </div>
                    </a>
            <?php endif;
            endif;
        endif;
    }
}

if (!function_exists('savalog_post_card')) {
    function savalog_post_card($args)
    {
        if ($args['post_counter'] === 1 && get_theme_mod('savalog_archive_mode', 'grid') !== 'masonry'): ?>
            <article class="post-<?php the_ID(); ?> d-flex flex-column">
                <div class="d-flex justify-content-center mb-4">
                    <span class="d-inline-block fst-italic me-2"><?php echo esc_html__('In', 'savalog') ?></span>
                    <?php savalog_entry_category(); ?>
                </div>
                <div class="d-flex justify-content-center mb-4"><?php savalog_entry_title(); ?></div>
                <div class="d-flex align-items-center justify-content-center mb-4">
                    <span class="date"><?php echo esc_html(get_the_date('M j, Y')); ?></span>
                    <span class="dot mx-3"></span>
                    <span class="author-name">
                        <span class="d-inline-block fst-italic"><?php echo esc_html__('By', 'savalog') ?></span>
                        <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
                    </span>
                    <span class="dot mx-3"></span>
                    <span class="comments">
                        <?php echo intval(get_comments_number()); ?>
                        <?php
                        if (intval(get_comments_number()) > 1) {
                            esc_html_e('Comments', 'savalog');
                        } else {
                            esc_html_e('Comment', 'savalog');
                        }
                        ?>
                    </span>
                </div>
                <div class="d-flex justify-content-center mb-4"><?php savalog_post_thumbnail(false); ?></div>
                <?php
                $display_read_more_text = get_theme_mod('savalog_archive_content_read_more_text', __('Continue Reading...', 'savalog'));
                ?>
                <div class="d-flex justify-content-center mb-4 text-center"><?php honrix_entry_content(); ?></div>
                <div class="entry-read-more mb-4 d-flex justify-content-center">
                    <a href="<?php echo esc_url(get_permalink()) ?>" rel="bookmark"><?php echo esc_html($display_read_more_text) ?></a>
                </div>
            </article>

        <?php else: ?>
            <article class="post-<?php the_ID(); ?> d-flex flex-column">
                <div class="mb-4"><?php savalog_post_thumbnail(false); ?></div>
                <div class="d-flex justify-content-center mb-4">
                    <span class="d-inline-block fst-italic me-2"><?php echo esc_html__('In', 'savalog') ?></span>
                    <?php savalog_entry_category(); ?>
                </div>

                <div class="d-flex justify-content-center mb-4"><?php savalog_entry_title(); ?></div>

                <div class="d-flex align-items-center justify-content-center mb-4">
                    <span class="date"><?php echo esc_html(get_the_date('M j, Y')); ?></span>
                    <span class="dot mx-3"></span>
                    <span class="author-name">
                        <span class="d-inline-block fst-italic"><?php echo esc_html__('By', 'savalog') ?></span>
                        <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
                    </span>
                    <span class="dot mx-3"></span>
                    <span class="comments">
                        <?php echo intval(get_comments_number()); ?>
                        <?php
                        if (intval(get_comments_number()) > 1) {
                            esc_html_e('Comments', 'savalog');
                        } else {
                            esc_html_e('Comment', 'savalog');
                        }
                        ?>
                    </span>
                </div>

                <?php
                $display_read_more_text = get_theme_mod('savalog_archive_content_read_more_text', __('Continue Reading...', 'savalog'));
                ?>
                <div class="mb-4 text-center"><?php honrix_entry_content(); ?></div>
                <div class="entry-read-more mb-4 d-flex justify-content-center">
                    <a href="<?php echo esc_url(get_permalink()) ?>" rel="bookmark"><?php echo esc_html($display_read_more_text) ?></a>
                </div>
            </article>
        <?php endif;
    }
}

if (!function_exists('savalog_entry_category')) {
    function savalog_entry_category()
    {
        $categories_list = get_the_category_list(_x(', ', 'Used between list items, there is a space after the comma.', 'savalog'));
        if ($categories_list) : ?>
            <span class="entry-categories">
                <?php printf('<span class="screen-reader-text">%1$s </span> %2$s', esc_html__('Used before category names.', 'savalog'), wp_kses($categories_list, array('a' => array('href' => array(), 'rel' => array())))); ?>
            </span>
        <?php
        endif;
    }
}

if (!function_exists('savalog_post_avatar')) {
    function savalog_post_avatar($avatar_size = 100)
    {
        if ('post' === get_post_type()) : ?>
            <div class="entry-avatar text-center mb-4">
                <?php
                $author_avatar_size = apply_filters('savalog_author_avatar_size', $avatar_size); ?>
                <span class="screen-reader-text"><?php esc_html_e('Used before post author name.', 'savalog'); ?></span>
                <div class="author-avatar position-relative mb-3"><span class="line position-absolute start-0 top-50"></span><?php echo get_avatar(get_the_author_meta('user_email'), $author_avatar_size); ?></div>
                <div class="author-title mb-2"><span class="text-uppercase fw-bold"><?php echo esc_html__('Author', 'savalog') ?></span></div>
                <div class="author-name mb-2"><a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" class="d-inline-block fs-6 fw-bold text-decoration-none text-uppercase"><?php echo get_the_author(); ?></a></div>
                <div class="author-description"><?php echo esc_html(get_the_author_meta('description')); ?></div>
            </div>
        <?php
        endif;
    }
}

if (!function_exists('savalog_post_tags')) {
    function savalog_post_tags()
    {
        $tags_list = get_the_tag_list('', _x(' ', 'Used between list items, there is a space after the comma.', 'savalog')); // phpcs:ignore WordPress.WP.I18n.NoEmptyStrings
        if ($tags_list && !is_wp_error($tags_list)) :
        ?>
            <div class="entry-tags mb-4">
                <?php esc_html_e('Tags: ','savalog'); ?>
                <?php
                printf(
                    '%1$s',
                    wp_kses($tags_list, array('a' => array('href' => array(), 'rel' => array())))

                );
                ?>
            </div>
        <?php
        endif;
    }
}

if (!function_exists('savalog_post_navigation')) {
    function savalog_post_navigation()
    {
        $prev_post = get_adjacent_post(false, '', true);
        $next_post = get_adjacent_post(false, '', false);
        if (!empty($prev_post) || !empty($next_post)) :
            $prev_title = !empty(esc_attr(get_theme_mod('savalog_single_navigation_prev_title', __('Previous Article', 'savalog')))) ? '<div>' . esc_attr(get_theme_mod('savalog_single_navigation_prev_title', 'Previous Article')) . '</div>' : '';
            $next_title = !empty(esc_attr(get_theme_mod('savalog_single_navigation_next_title', __('Next Article', 'savalog')))) ? '<div>' . esc_attr(get_theme_mod('savalog_single_navigation_next_title', 'Next Article')) . '</div>' : '';
        ?>
            <div class="entry-navigation py-2 border-top border-bottom mb-4">
                <div class="row">
                    <div class="pre-post col-12 col-md-6 text-capitalize">
                        <?php

                        if (!empty($prev_post)) { ?>
                            <small><?php echo wp_kses_post($prev_title); ?></small>
                            <a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>" title="<?php echo esc_attr(honrix_check_post_title($prev_post->post_title)); ?>" class="fs-5">
                                <div><?php echo wp_kses_post(honrix_check_post_title($prev_post->post_title)); ?></div>
                            </a>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="next-post col-12 col-md-6 text-capitalize d-flex flex-column align-items-end">
                        <?php

                        if (!empty($next_post)) { ?>
                            <small><?php echo wp_kses_post($next_title); ?></small>
                            <a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>" title="<?php echo esc_attr(honrix_check_post_title($next_post->post_title)); ?>" class="fs-5">
                                <div><?php echo wp_kses_post(honrix_check_post_title($next_post->post_title)); ?></div>
                            </a>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        <?php
        endif;
    }
}

if (!function_exists('savalog_related_posts')) {
    function savalog_related_posts()
    { ?>
        <?php
        $categories = get_the_category();
        if (count($categories) > 0) :
        ?>

            <?php
            $terms = get_the_terms(get_the_ID(), 'category');

            if (empty($terms)) $terms = array();

            $term_list = wp_list_pluck($terms, 'slug');

            $related_args = array(
                'post_type' => 'post',
                'posts_per_page' => 3,
                'post_status' => 'publish',
                'post__not_in' => array(get_the_ID()),
                //                        'orderby' => 'rand',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'category',
                        'field' => 'slug',
                        'terms' => $term_list
                    )
                )
            );

            $the_query = new WP_Query($related_args);
            global $cl_from_element;
            $cl_from_element['is_related'] = true;
            if ($the_query->have_posts()) :
            ?>
                <div class="related-posts mb-4">
                    <h2 class="related-posts-title mb-3 fs-4 text-center">
                        <?php esc_html_e('Related Posts', 'savalog') ?>
                    </h2>
                    <div class="row">
                        <?php $counter = 1;
                        while ($the_query->have_posts() && $counter < 4) :
                            $the_query->the_post(); ?>
                            <div class="related-post col-12 col-md-4">

                                <a href="<?php echo esc_url(get_permalink()); ?>">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="related-post-thumbnail overflow-hidden mb-2 d-flex justify-content-center">
                                            <?php the_post_thumbnail(); ?>
                                        </div>
                                    <?php endif; ?>
                                </a>

                                <?php the_title(sprintf('<h2 class="related-post-title m-0 mb-2 d-flex justify-content-center"><a href="%s" rel="bookmark" class="d-block fs-5 text-capitalize">', esc_url(get_permalink())), '</a></h2>'); ?>
                                <div class="d-flex align-items-center justify-content-center">
                                    <span class="date"><?php echo esc_html(get_the_date('M j, Y')); ?></span>
                                    <span class="dot mx-3"></span>
                                    <span class="author-name">
                                        <span class="d-inline-block fst-italic"><?php echo esc_html__('By', 'savalog') ?></span>
                                        <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
                                    </span>
                                    <span class="dot mx-3"></span>
                                    <span class="comments">
                                        <?php echo intval(get_comments_number()); ?>
                                        <?php
                                        if (intval(get_comments_number()) > 1) {
                                            esc_html_e('Comments', 'savalog');
                                        } else {
                                            esc_html_e('Comment', 'savalog');
                                        }
                                        ?>
                                    </span>
                                </div>
                            </div>
                        <?php
                            $counter++;
                        endwhile;
                        ?>
                    </div>
                </div>
            <?php endif;

            wp_reset_query();
            $cl_from_element['is_related'] = false;
            ?>

            <?php endif;
    }
}

if (!function_exists('savalog_post_comment')) {
    function savalog_post_comment()
    {
        if (get_theme_mod('savalog_comment_display', 'yes') == 'yes') :
            if (comments_open() || get_comments_number()) : ?>
                <div class="entry-comment mt-5 py-3">
                    <?php comments_template(); ?>
                </div>
            <?php elseif (!comments_open()) : ?>
<?php
                $close_comment_msg = get_theme_mod('savalog_comment_close_message', __('Comments are closed for this section.', 'savalog'));
                if (!empty($close_comment_msg)) :
                    sprintf('<div class="entry-comment">%1$s</div>', $close_comment_msg);
                endif;
            endif;
        endif;
    }
}
