<?php
if (!function_exists('savalog_print_first_instance_of_block')) {
    function savalog_print_first_instance_of_block($block_name, $content = null, $instances = 1)
    {
        $instances_count = 0;
        $blocks_content  = '';

        if (! $content) {
            $content = get_the_content();
        }

        // Parse blocks in the content.
        $blocks = parse_blocks($content);

        // Loop blocks.
        foreach ($blocks as $block) {

            // Sanity check.
            if (! isset($block['blockName'])) {
                continue;
            }

            // Check if this the block matches the $block_name.
            $is_matching_block = false;

            // If the block ends with *, try to match the first portion.
            if ('*' === $block_name[-1]) {
                $is_matching_block = 0 === strpos($block['blockName'], rtrim($block_name, '*'));
            } else {
                $is_matching_block = $block_name === $block['blockName'];
            }

            if ($is_matching_block) {
                // Increment count.
                $instances_count++;

                // Add the block HTML.
                $blocks_content .= render_block($block);

                // Break the loop if the $instances count was reached.
                if ($instances_count >= $instances) {
                    break;
                }
            }
        }

        if ($blocks_content) {
            /** This filter is documented in wp-includes/post-template.php */
            echo apply_filters('the_content', $blocks_content); // phpcs:ignore WordPress.Security.EscapeOutput
            return true;
        }

        return false;
    }
}

if (!function_exists('savalog_search')) {
    function savalog_search()
    {
?>
        <div class="hrix-header-popup-search-icon fs-4 me-2" tabindex="0"><i class="fas fa-search"></i></div>
        <div class="hrix-header-search-form hrix-header-popup-search-form">
            <span class="close btn rounded-circle d-flex align-items-center justify-content-center m-3 shadow-sm position-absolute" tabindex="0"><i class="fa fa-times"></i></span>
            <form method="get" action="<?php echo esc_url(home_url('/')); ?>" class="d-flex overflow-hidden">
                <select class="hrix-header-search-select d-inline-block position-relative rounded-0" name="product_cat">
                    <option value=""><?php esc_html_e('All', 'savalog'); ?></option>
                    <?php
                    $storely_product_categories = get_categories();
                    if (is_array($storely_product_categories)) {
                        foreach ($storely_product_categories as $category) {
                            $option = '<option value="' . esc_attr($category->category_nicename) . '">';
                            $option .= esc_html($category->cat_name);
                            $option .= ' (' . absint($category->category_count) . ')';
                            $option .= '</option>';
                            echo wp_kses_post($option);
                        }
                    }
                    ?>
                </select>
                <div class="hrix-header-search-search-section d-flex">
                    <input class="hrix-header-search-input w-100 border-0 ps-2 pe-2" name="s" type="text" placeholder="<?php esc_attr_e('Search', 'savalog'); ?>" />
                    <input type="hidden" name="post_type" value="post" />
                    <button class="hrix-header-search-button w-25 fw-bold border-0" type="submit" aria-label="<?php esc_attr_e('Search', 'savalog'); ?>"><i class="fas fa-search"></i></button>
                </div>
            </form>
        </div>
<?php
    }
    add_action('savalog_search', 'savalog_search', 10, 3);
}

if (!function_exists('savalog_nav_menu')) {
    function savalog_nav_menu()
    { ?>
        <div class="honrix-is-mobile">
            <?php
            if (
                has_nav_menu('mobile-menu') ||
                has_nav_menu('main-menu')
            ) : ?>
                <button class="hrix-navbar-toggler" type="button">
                    <span class="fa fa-bars"></span>
                </button>
                <div class="hrix-mobile-navigation-menu position-fixed top-0 w-100 h-100">
                    <div class="w-75 w-md-50 px-1 py-2 position-relative">
                        <div class="d-flex align-items-center justify-content-end pb-4 mb-2">
                            <span class="close btn rounded-circle d-flex align-items-center justify-content-center shadow-sm" tabindex="0"><i class="fa fa-times"></i></span>
                        </div>
                        <nav class="hrix-mobile-menu w-100 active">
                            <?php
                            wp_nav_menu([
                                'theme_location' => has_nav_menu('mobile-menu')
                                    ? 'mobile-menu'
                                    : 'main-menu',
                                'container' => 'div',
                                'container_class' => 'navbar-nav py-0 w-100',
                                'menu_class' => 'nav navbar-nav wrap',
                                'items_wrap' => '%3$s',
                                'walker' => new Honrix_Walker_Nav_Menu()
                            ]); ?>
                        </nav>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="honrix-is-pc">
            <nav class="hrix-header-menu navbar navbar-expand-lg navbar-dark py-lg-0">
                <?php if (has_nav_menu('main-menu')) : ?>
                    <div class="hrix-menu collapse navbar-collapse" id="navbarCollapse">
                        <?php
                        wp_nav_menu([
                            'theme_location' => 'main-menu',
                            'container' => 'div',
                            'container_class' => 'navbar-nav py-0',
                            'items_wrap' => '%3$s',
                            'walker' => new Honrix_Walker_Nav_Menu()
                        ]); ?>
                    </div>
                <?php endif; ?>
            </nav>
        </div>
        <?php
    }
    add_action('savalog_nav_menu', 'savalog_nav_menu');
}