<?php

/**
 * Enqueue scripts and styles.
 */

if (!function_exists('savalog_enqueue_scripts')) {
    function savalog_enqueue_scripts()
    {
        if (get_theme_mod('savalog_enqueue_fontawesome', 'yes') === 'yes') {
            wp_enqueue_style('font-awesome', HONRIX_PARENT_TEMPLATE_URI . '/framework/font-awesome/css/all.min.css', array(), '1');
        }

        /* Bootstrap */
        if (get_theme_mod('savalog_enqueue_bootstrap', 'yes') === 'yes') {
            wp_enqueue_style(
                'bootstrap-css',
                esc_url(
                    HONRIX_PARENT_TEMPLATE_URI . '/assets/css/bootstrap.min.css'
                ),
                [],
                null
            );
        }

        /* css styles */
        wp_enqueue_style(
            'savalog-style',
            get_stylesheet_uri()
        );
        wp_enqueue_style('savalog-main-style', esc_url(SAVALOG_TEMPLATE_URI . '/assets/css/style.css'), array('savalog-style'), null);

        wp_enqueue_style('savalog-archive', esc_url(SAVALOG_TEMPLATE_URI . '/assets/css/archive.css'), array('savalog-main-style'), null);

        wp_enqueue_style('savalog-post', esc_url(SAVALOG_TEMPLATE_URI . '/assets/css/post.css'), array('savalog-main-style'), null);

        wp_enqueue_style('savalog-footer', esc_url(SAVALOG_TEMPLATE_URI . '/assets/css/footer.css'), array('savalog-main-style'), null);

        wp_enqueue_style(
            'owl-carousel-css',
            esc_url(
                HONRIX_PARENT_TEMPLATE_URI .
                    '/lib/owlcarousel/assets/owl.carousel.min.css'
            ),
            ['font-awesome'],
            null
        );
        wp_enqueue_style(
            'owl-carousel-theme-css',
            esc_url(
                HONRIX_PARENT_TEMPLATE_URI .
                    '/lib/owlcarousel/assets/owl.theme.default.min.css'
            ),
            ['owl-carousel-css'],
            null
        );
        wp_enqueue_style(
            'savalog-google-font',
            esc_url(
                get_theme_mod('savalog_google_font_url', 'https://fonts.googleapis.com/css2?family=Josefin+Sans:ital,wght@0,100..700;1,100..700&display=swap')
            ),
            false
        );

        if (get_theme_mod('savalog_enqueue_bootstrap', 'yes') === 'yes') {
            wp_enqueue_script(
                'bootstrap-js',
                esc_url(HONRIX_PARENT_TEMPLATE_URI . '/framework/bootstrap/bootstrap.bundle.min.js'),
                ['jquery'],
                '1.0.0',
                true
            );
        }

        if (get_theme_mod('savalog_enqueue_fontawesome', 'yes') === 'yes') {
            wp_enqueue_script(
                'font-awesome-js',
                esc_url(HONRIX_PARENT_TEMPLATE_URI . '/assets/js/fontawesome.min.all.js'),
                [],
                '1.0.0',
                true
            );
        }

        wp_enqueue_script(
            'owl-carousel-js',
            esc_url(
                HONRIX_PARENT_TEMPLATE_URI .
                    '/lib/owlcarousel/owl.carousel.min.js'
            ),
            ['jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script('jquery-masonry');
        
        wp_enqueue_script(
            'savalog-script',
            esc_url(SAVALOG_TEMPLATE_URI . '/assets/js/custom.js'),
            ['jquery-masonry','jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script('savalog-slick-script', esc_url(SAVALOG_TEMPLATE_URI . '/assets/slick/slick.min.js'), array('jquery'), '1.0.0', true);

        wp_enqueue_script('savalog-home-slider-script', esc_url(SAVALOG_TEMPLATE_URI . '/assets/js/slider.js'), array('savalog-slick-script'), '1.0.0', true);

        if (get_theme_mod('savalog_archive_mode', 'grid') === 'masonry') {
            wp_enqueue_script('jquery-masonry');
            wp_enqueue_script('savalog-masonry-init', esc_url(SAVALOG_TEMPLATE_URI . '/assets/js/masonry-init.js'), array('jquery','jquery-masonry'), '1', true);
        }


        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }

        // Responsive embeds script.
        wp_enqueue_script(
            'savalog-responsive-embeds-script',
            HONRIX_PARENT_TEMPLATE_URI . '/assets/js/responsive-embeds.js',
            array(),
            wp_get_theme()->get('Version'),
            true
        );
    }

    add_action('wp_enqueue_scripts', 'savalog_enqueue_scripts');
}

if (!function_exists('savalog_admin_style')) {
    function savalog_admin_style()
    {
        wp_enqueue_style('savalog-admin-css', HONRIX_PARENT_TEMPLATE_URI . '/assets/css/admin.css', array(), '1');
    }
    add_action('admin_enqueue_scripts', 'savalog_admin_style');
}

if (!function_exists('savalog_customizer_control_toggle')) {
    function savalog_customizer_control_toggle()
    {
        wp_enqueue_script('savalog-customize-controls-toggle', HONRIX_PARENT_TEMPLATE_URI . '/inc/customize/assets/customize-controls-toggle.js', array('jquery', 'customize-preview'), '1.30', true);
    }
    add_action('customize_controls_enqueue_scripts', 'savalog_customizer_control_toggle');
}
